/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.ingestion_api.exceptions;

import akka.actor.ActorSystem;
import akka.stream.Materializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.impact.api.CrawlerConfig;
import com.xebialabs.impact.api.CrawlerJobMetadata;
import com.xebialabs.impact.api.ReportCrawlerLogMessageRequestVM;
import com.xebialabs.impact.wave.ExceptionHandler;
import com.xebialabs.impact.wave.WaveAction;
import com.xebialabs.impact.wave.WaveActionResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataIngestionLoggingExceptionHandler
implements ExceptionHandler {
    public static final int MAX_FAILURES = 32;
    private static Logger logger = LoggerFactory.getLogger(DataIngestionLoggingExceptionHandler.class);
    private final ObjectMapper objectMapper;
    private final String pluginId;
    private final IngestionApiAsync ingestionApiAsync;

    public DataIngestionLoggingExceptionHandler(ObjectMapper objectMapper, String pluginId, IngestionApiAsync ingestionApiAsync) {
        this.objectMapper = objectMapper;
        this.pluginId = pluginId;
        this.ingestionApiAsync = ingestionApiAsync;
    }

    public CompletionStage<Void> apply(ActorSystem actorSystem, Materializer materializer, WaveAction waveAction, Throwable throwable) {
        String stackTrace;
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
            stackTrace = sw.toString();
        }
        catch (IOException e) {
            stackTrace = e.toString();
        }
        logger.error("Exception: ", throwable);
        return this.ingestionApiAsync.reportCrawlerLog(new ReportCrawlerLogMessageRequestVM().setPluginId(this.pluginId).setTenantId(AgathaConfiguration.getTenantId()).setNetworkId(AgathaConfiguration.getNetworkId()).setDataSourceId(waveAction.getDataSourceDetails().getDataSourceId()).setLogLevel(CrawlerConfig.LogReportLevel.ERROR).setLogContent(stackTrace)).thenComposeAsync(this.resendMessage(waveAction, stackTrace)).thenComposeAsync(v -> waveAction.sendAckOrNack(WaveActionResult.AckOrNack.ACK));
    }

    private Function<Void, CompletionStage<Void>> resendMessage(WaveAction waveAction, String stackTrace) {
        CrawlerJobMetadata metadata = waveAction.getMetadata();
        metadata.setFailures(metadata.getFailures() + 1);
        boolean dlq = metadata.getFailures() > 32;
        metadata.setErrorMessage(stackTrace);
        waveAction.setDelayedUntil(System.currentTimeMillis() + (long)(metadata.getFailures() * 675000));
        return v -> waveAction.sendMessages(Collections.singletonList(waveAction), dlq);
    }
}

