/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.ComputingGraphBase;
import com.xebialabs.impact.wave.scripting.engine.ContextBase;
import com.xebialabs.impact.wave.scripting.engine.Handler;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import io.vavr.CheckedFunction2;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingHandler<S, C extends ContextBase<C>>
extends Handler<S, C> {
    private static final Logger logger = LoggerFactory.getLogger(MappingHandler.class);
    private final Class<S> src;
    private final Class<?>[] dst;
    private final CheckedFunction2<ObjectWrapper<S, C>, C, Object> fn;

    public MappingHandler(String name, Class<S> src, Class<?>[] dst, CheckedFunction2<ObjectWrapper<S, C>, C, Object> fn) {
        super(name, src, new Class[0], dst);
        this.src = src;
        this.dst = dst;
        this.fn = fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> handle(ComputingGraphBase<?, C> computingGraph, ObjectWrapper<?, C> object) {
        C context = computingGraph.makeContext(object, "map", new AtomicInteger(0), null, this.destinations);
        try {
            object.rememberProcessedClass();
            logger.info("Going to call +");
            Object result = null;
            try {
                result = this.fn.apply(object, context);
            }
            finally {
                logger.info("Going to call -");
            }
            return computingGraph.handleHandlerResult(object, context, result, false);
        }
        catch (Throwable throwable) {
            return computingGraph.handleHandlerResult(object, context, CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
                throw new IllegalStateException(throwable);
            }), false);
        }
    }
}

