import com.xebialabs.impact.api.BaseCrawlerMessage
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM
import com.xebialabs.impact.wave.scripting.PluginInterface

class CrawlEntities extends BaseCrawlerMessage {
    String contextKeyToUse

}

class CrawlFields extends BaseCrawlerMessage {

}

class LaunchMessages {
    List<BaseCrawlerMessage> messages;
}

PluginInterface.launch().into(LaunchMessages).via { message, ctx ->
    l = new LaunchMessages();
    CrawlEntities crawlEntities = new CrawlEntities()
    if (message.metadata.incremental) {
        crawlEntities.contextKeyToUse = "seen"
    } else {
        crawlEntities.contextKeyToUse = "seen-" + message.metadata.runTimestamp
    }
    crawlEntities.setRequestContext([crawlEntities.contextKeyToUse])
    CrawlFields crawlFields = new CrawlFields()
    crawlFields.setMessageKey("0-crawlFields")
    crawlEntities.setMessageKey("1-crawlEntities")
    l.messages = [
            crawlFields,
            crawlEntities
    ];
    ctx.emit(l);
}

PluginInterface.pushMessages(LaunchMessages).mapRequest { launchMessages ->
    new PushCrawlerUMMessagesRequestVM()
            .setMessages(launchMessages.messages)
}