/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io.compression;

import akka.annotation.InternalApi;
import akka.stream.impl.io.compression.DeflateCompressor;
import akka.stream.impl.io.compression.GzipCompressor$;
import akka.stream.impl.io.compression.GzipDecompressor$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b!B\u0001\u0003\u0001)a!AD${SB\u001cu.\u001c9sKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t1bY8naJ,7o]5p]*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u0013)\taa\u001d;sK\u0006l'\"A\u0006\u0002\t\u0005\\7.Y\n\u0003\u00015\u0001\"AD\b\u000e\u0003\tI!\u0001\u0005\u0002\u0003#\u0011+g\r\\1uK\u000e{W\u000e\u001d:fgN|'\u000f\u0003\u0005\u0013\u0001\t\u0005\t\u0015!\u0003\u0015\u0003A\u0019w.\u001c9sKN\u001c\u0018n\u001c8MKZ,Gn\u0001\u0001\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u0007%sG\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0003;y\u0001\"A\u0004\u0001\t\u000fIQ\u0002\u0013!a\u0001)!A\u0001\u0005\u0001EC\u0002\u0013E\u0013%\u0001\u0005eK\u001ad\u0017\r^3s+\u0005\u0011\u0003CA\u0012+\u001b\u0005!#BA\u0013'\u0003\rQ\u0018\u000e\u001d\u0006\u0003O!\nA!\u001e;jY*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016%\u0005!!UM\u001a7bi\u0016\u0014\bbB\u0017\u0001\u0005\u0004%IAL\u0001\tG\",7m[*v[V\tq\u0006\u0005\u0002$a%\u0011\u0011\u0007\n\u0002\u0006\u0007J\u001b5G\r\u0005\u0007g\u0001\u0001\u000b\u0011B\u0018\u0002\u0013\rDWmY6Tk6\u0004\u0003bB\u001b\u0001\u0001\u0004%IAN\u0001\u000bQ\u0016\fG-\u001a:TK:$X#A\u001c\u0011\u0005UA\u0014BA\u001d\u0017\u0005\u001d\u0011un\u001c7fC:Dqa\u000f\u0001A\u0002\u0013%A(\u0001\biK\u0006$WM]*f]R|F%Z9\u0015\u0005u\u0002\u0005CA\u000b?\u0013\tydC\u0001\u0003V]&$\bbB!;\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0004BB\"\u0001A\u0003&q'A\u0006iK\u0006$WM]*f]R\u0004\u0003bB#\u0001\u0001\u0004%IAR\u0001\nEf$Xm\u001d*fC\u0012,\u0012a\u0012\t\u0003+!K!!\u0013\f\u0003\t1{gn\u001a\u0005\b\u0017\u0002\u0001\r\u0011\"\u0003M\u00035\u0011\u0017\u0010^3t%\u0016\fGm\u0018\u0013fcR\u0011Q(\u0014\u0005\b\u0003*\u000b\t\u00111\u0001H\u0011\u0019y\u0005\u0001)Q\u0005\u000f\u0006Q!-\u001f;fgJ+\u0017\r\u001a\u0011\t\u000bE\u0003A\u0011\u000b*\u0002%\r|W\u000e\u001d:fgN<\u0016\u000e\u001e5Ck\u001a4WM\u001d\u000b\u0004'bS\u0006C\u0001+W\u001b\u0005)&BA\u0014\u000b\u0013\t9VK\u0001\u0006CsR,7\u000b\u001e:j]\u001eDQ!\u0017)A\u0002M\u000bQ!\u001b8qkRDQa\u0017)A\u0002q\u000baAY;gM\u0016\u0014\bcA\u000b^?&\u0011aL\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003+\u0001L!!\u0019\f\u0003\t\tKH/\u001a\u0005\u0006G\u0002!\t\u0006Z\u0001\u0010M2,8\u000f[,ji\"\u0014UO\u001a4feR\u00111+\u001a\u0005\u00067\n\u0004\r\u0001\u0018\u0005\u0006O\u0002!\t\u0006[\u0001\u0011M&t\u0017n\u001d5XSRD')\u001e4gKJ$\"aU5\t\u000bm3\u0007\u0019\u0001/\t\u000b-\u0004A\u0011\u00027\u0002\u0013U\u0004H-\u0019;f\u0007J\u001cGCA\u001fn\u0011\u0015I&\u000e1\u0001T\u0011\u0015y\u0007\u0001\"\u0003q\u0003\u0019AW-\u00193feR\t1\u000bC\u0003s\u0001\u0011%\u0001/A\u0004ue\u0006LG.\u001a:)\u0005\u0001!\bCA;y\u001b\u00051(BA<\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0003sZ\u00141\"\u00138uKJt\u0017\r\\!qS\u001eA1PAA\u0001\u0012\u0003QA0\u0001\bHu&\u00048i\\7qe\u0016\u001c8o\u001c:\u0011\u00059ih\u0001C\u0001\u0003\u0003\u0003E\tA\u0003@\u0014\u0005u|\bcA\u000b\u0002\u0002%\u0019\u00111\u0001\f\u0003\r\u0005s\u0017PU3g\u0011\u0019YR\u0010\"\u0001\u0002\bQ\tA\u0010C\u0005\u0002\fu\f\n\u0011\"\u0001\u0002\u000e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"!a\u0004+\u0007Q\t\tb\u000b\u0002\u0002\u0014A!\u0011QCA\u000f\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011!C;oG\",7m[3e\u0015\t9h#\u0003\u0003\u0002 \u0005]!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
@InternalApi
public class GzipCompressor
extends DeflateCompressor {
    private Deflater deflater;
    private final int compressionLevel;
    private final CRC32 checkSum;
    private boolean headerSent;
    private long bytesRead;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$1() {
        return GzipCompressor$.MODULE$.$lessinit$greater$default$1();
    }

    private Deflater deflater$lzycompute() {
        GzipCompressor gzipCompressor = this;
        synchronized (gzipCompressor) {
            if (!this.bitmap$0) {
                this.deflater = new Deflater(this.compressionLevel, true);
                this.bitmap$0 = true;
            }
        }
        return this.deflater;
    }

    @Override
    public Deflater deflater() {
        return !this.bitmap$0 ? this.deflater$lzycompute() : this.deflater;
    }

    private CRC32 checkSum() {
        return this.checkSum;
    }

    private boolean headerSent() {
        return this.headerSent;
    }

    private void headerSent_$eq(boolean x$1) {
        this.headerSent = x$1;
    }

    private long bytesRead() {
        return this.bytesRead;
    }

    private void bytesRead_$eq(long x$1) {
        this.bytesRead = x$1;
    }

    @Override
    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        this.updateCrc(input);
        return this.header().$plus$plus(super.compressWithBuffer(input, buffer));
    }

    @Override
    public ByteString flushWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.flushWithBuffer(buffer));
    }

    @Override
    public ByteString finishWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.finishWithBuffer(buffer)).$plus$plus(this.trailer());
    }

    private void updateCrc(ByteString input) {
        this.checkSum().update((byte[])input.toArray(ClassTag$.MODULE$.Byte()));
        this.bytesRead_$eq(this.bytesRead() + (long)input.length());
    }

    private ByteString header() {
        ByteString byteString;
        if (!this.headerSent()) {
            this.headerSent_$eq(true);
            byteString = GzipDecompressor$.MODULE$.Header();
        } else {
            byteString = ByteString$.MODULE$.empty();
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    private ByteString trailer() {
        void var3_3;
        int crc = (int)this.checkSum().getValue();
        int tot = (int)this.bytesRead();
        ByteString trailer = GzipCompressor.int32$1(crc).$plus$plus(GzipCompressor.int32$1(tot));
        return var3_3;
    }

    private static final ByteString int32$1(int i) {
        return ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{i, i >> 8, i >> 16, i >> 24}), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    public GzipCompressor(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        super(compressionLevel, true);
        this.checkSum = new CRC32();
        this.headerSent = false;
        this.bytesRead = 0L;
    }
}

