/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.ingestion_api;

import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.impact.api.CrawlerMessageWithCredentials;
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM;
import com.xebialabs.impact.wave.AsyncActionConsumer;
import com.xebialabs.impact.wave.WaveSystem;
import com.xebialabs.impact.wave.ingestion_api.BaseDataIngestionConsumer;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class DataIngestionAsyncActionConsumer
extends BaseDataIngestionConsumer
implements AsyncActionConsumer {
    public DataIngestionAsyncActionConsumer(IngestionApiAsync ingestionApiAsync, String pluginId) {
        super(ingestionApiAsync, pluginId);
    }

    public CompletionStage<Void> apply(CrawlerMessageWithCredentials thisAction, Collection<CrawlerMessageWithCredentials> nextActions, WaveSystem waveSystem, Boolean dlq) {
        return this.ingestionApiAsync.pushUMMessage(new PushCrawlerUMMessagesRequestVM().setMessages(nextActions.stream().map(m -> {
            String canonicalName = m.getClass().getCanonicalName();
            if (canonicalName == null) {
                throw new IllegalArgumentException("Class [" + m.getClass().getName() + "] does not have canonical name");
            }
            m.getMessage().setDataKey(canonicalName);
            return m.getMessage();
        }).collect(Collectors.toList())).setDataSourceId(thisAction.getMessage().getDataSourceDetails().getDataSourceId()).setNetworkId(AgathaConfiguration.getNetworkId()).setPluginId(this.pluginId).setDlq(dlq.booleanValue()).setTenantId(AgathaConfiguration.getTenantId()));
    }
}

