import com.xebialabs.impact.api.BaseCrawlerMessage
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM
import com.xebialabs.impact.wave.scripting.PluginInterface

class CrawlEntities extends BaseCrawlerMessage {
    String workspaceId
    String contextKeyToUse

}

class CrawlFields extends BaseCrawlerMessage {
}

class LaunchMessages {
}

class LaunchMessagesForSubscription {
    String subscriptionId
}

class LaunchMessagesForWorkspace {
    List<BaseCrawlerMessage> messages = new ArrayList()
}


PluginInterface.launch().into(LaunchMessages).via { message, ctx ->
    l = new LaunchMessages();
    ctx.emit(l);
}

PluginInterface.request(LaunchMessages).into(LaunchMessagesForSubscription).mapToRequest({request, ctx ->
    RequestHelper.get(ctx.getCrawlerMessageWithCredentials().credentials.endpoint + "webservice/v2.0/subscription", ctx)
}).parseResponse({request, httpResponse, parser, ctx ->
    parser.readStringValueAndThen(".Subscription.ObjectID", {subscriptionId ->
        LaunchMessagesForSubscription launchMessagesForSubscription = new LaunchMessagesForSubscription()
        launchMessagesForSubscription.subscriptionId = subscriptionId
        ctx.emit(launchMessagesForSubscription)
    })
})

PluginInterface.request(LaunchMessagesForSubscription).into(LaunchMessagesForWorkspace).mapToRequest({request, ctx ->
    RequestHelper.get(ctx.getCrawlerMessageWithCredentials().credentials.endpoint + "webservice/v2.0/Subscription/" + request.subscriptionId + "/Workspaces", ctx)
}).parseResponse({request, httpResponse, parser, ctx ->
    LaunchMessagesForWorkspace l = new LaunchMessagesForWorkspace()

    CrawlFields crawlFields = new CrawlFields()
    crawlFields.setMessageKey("0-crawlFields")
    l.messages.add(crawlFields)

    parser.readStringValueAndThen(".QueryResult.Results[].ObjectID", {workspaceId ->
        List<String> filterValues = ctx.crawlerMessageWithCredentials.credentials.getFilterValues("WORKSPACE_IDS")
        if (filterValues.isEmpty() || filterValues.stream().filter({workspaceId.equals(it)}).count() > 0) {
            message = ctx.crawlerMessageWithCredentials.message
            CrawlEntities crawlEntities = new CrawlEntities()
            if (message.metadata.incremental) {
                crawlEntities.contextKeyToUse = "seen-" + workspaceID
            } else {
                crawlEntities.contextKeyToUse = "seen-" + workspaceId + "-" + message.metadata.runTimestamp
            }
            crawlEntities.setRequestContext([crawlEntities.contextKeyToUse])
            crawlEntities.setMessageKey("1-crawlEntities-" + workspaceId)
            crawlEntities.workspaceId = workspaceId
            l.messages.add(crawlEntities)
        }
    })
    parser.onFinish({
        ctx.emit(l)
    })
})

PluginInterface.pushMessages(LaunchMessagesForWorkspace).mapRequest { launchMessages ->
    new PushCrawlerUMMessagesRequestVM()
            .setMessages(launchMessages.messages)
}