/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ResolvedServerInfo;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Deprecated
@Immutable
public final class ResolvedServerInfoGroup {
    private final List<ResolvedServerInfo> resolvedServerInfoList;
    private final Attributes attributes;

    private ResolvedServerInfoGroup(List<ResolvedServerInfo> resolvedServerInfoList, Attributes attributes) {
        Preconditions.checkArgument((!resolvedServerInfoList.isEmpty() ? 1 : 0) != 0, (Object)"empty server list");
        this.resolvedServerInfoList = Collections.unmodifiableList(new ArrayList<ResolvedServerInfo>(resolvedServerInfoList));
        this.attributes = (Attributes)Preconditions.checkNotNull((Object)attributes, (Object)"attributes");
    }

    public List<ResolvedServerInfo> getResolvedServerInfoList() {
        return this.resolvedServerInfoList;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public EquivalentAddressGroup toEquivalentAddressGroup() {
        ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>(this.resolvedServerInfoList.size());
        for (ResolvedServerInfo resolvedServerInfo : this.resolvedServerInfoList) {
            addrs.add(resolvedServerInfo.getAddress());
        }
        return new EquivalentAddressGroup(addrs, this.attributes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Attributes attributes) {
        return new Builder(attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedServerInfoGroup that = (ResolvedServerInfoGroup)o;
        return Objects.equal(this.resolvedServerInfoList, that.resolvedServerInfoList) && Objects.equal((Object)this.attributes, (Object)that.attributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resolvedServerInfoList, this.attributes});
    }

    public String toString() {
        return "[servers=" + this.resolvedServerInfoList + ", attrs=" + this.attributes + "]";
    }

    @Deprecated
    public static final class Builder {
        private final List<ResolvedServerInfo> group = new ArrayList<ResolvedServerInfo>();
        private final Attributes attributes;

        public Builder(Attributes attributes) {
            this.attributes = attributes;
        }

        public Builder() {
            this(Attributes.EMPTY);
        }

        public Builder add(ResolvedServerInfo resolvedServerInfo) {
            this.group.add(resolvedServerInfo);
            return this;
        }

        public Builder addAll(Collection<ResolvedServerInfo> resolvedServerInfo) {
            this.group.addAll(resolvedServerInfo);
            return this;
        }

        public ResolvedServerInfoGroup build() {
            return new ResolvedServerInfoGroup(this.group, this.attributes);
        }
    }
}

