/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.base.CaseFormat;

public class PropertyNamingStrategyWrapper
extends PropertyNamingStrategy.PropertyNamingStrategyBase {
    private static final PropertyNamingStrategy.PropertyNamingStrategyBase SNAKE_TO_CAMEL = new SnakeToCamelNamingStrategy();
    private final PropertyNamingStrategy.PropertyNamingStrategyBase delegate;

    public PropertyNamingStrategyWrapper(PropertyNamingStrategy delegate) {
        this.delegate = delegate instanceof PropertyNamingStrategy.PropertyNamingStrategyBase ? (PropertyNamingStrategy.PropertyNamingStrategyBase)delegate : SNAKE_TO_CAMEL;
    }

    public String translate(String fieldName) {
        return this.delegate.translate(fieldName);
    }

    private static class SnakeToCamelNamingStrategy
    extends PropertyNamingStrategy.PropertyNamingStrategyBase {
        private SnakeToCamelNamingStrategy() {
        }

        public String translate(String fieldName) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName);
        }
    }
}

