/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2Codec;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ObjectUtil;

public final class Http2CodecBuilder {
    private static final Http2FrameLogger HTTP2_FRAME_LOGGER = new Http2FrameLogger(LogLevel.INFO, Http2Codec.class);
    private final Http2StreamChannelBootstrap bootstrap;
    private final boolean server;
    private Http2Settings initialSettings;
    private Http2FrameLogger frameLogger;
    private Http2HeadersEncoder.SensitivityDetector headersSensitivityDetector;

    public Http2CodecBuilder(boolean server, ChannelHandler streamHandler) {
        this(server, new Http2StreamChannelBootstrap().handler(streamHandler));
    }

    public Http2CodecBuilder(boolean server, Http2StreamChannelBootstrap bootstrap) {
        this.bootstrap = (Http2StreamChannelBootstrap)ObjectUtil.checkNotNull((Object)bootstrap, (String)"bootstrap");
        this.server = server;
        this.initialSettings = Http2Settings.defaultSettings();
        this.frameLogger = HTTP2_FRAME_LOGGER;
        this.headersSensitivityDetector = null;
    }

    public Http2CodecBuilder initialSettings(Http2Settings initialSettings) {
        this.initialSettings = initialSettings;
        return this;
    }

    public Http2Settings initialSettings() {
        return this.initialSettings;
    }

    public Http2CodecBuilder frameLogger(Http2FrameLogger frameLogger) {
        this.frameLogger = frameLogger;
        return this;
    }

    public Http2FrameLogger frameLogger() {
        return this.frameLogger;
    }

    public Http2CodecBuilder headersSensitivityDetector(Http2HeadersEncoder.SensitivityDetector headersSensitivityDetector) {
        this.headersSensitivityDetector = headersSensitivityDetector;
        return this;
    }

    public Http2HeadersEncoder.SensitivityDetector headersSensitivityDetector() {
        return this.headersSensitivityDetector;
    }

    private Http2FrameWriter frameWriter() {
        return this.headersSensitivityDetector() == null ? new DefaultHttp2FrameWriter() : new DefaultHttp2FrameWriter(this.headersSensitivityDetector());
    }

    public Http2Codec build() {
        return new Http2Codec(this.server, this.bootstrap, this.frameWriter(), this.frameLogger(), this.initialSettings());
    }
}

