/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseFetcher;
import com.xebialabs.agatha.crawlers.github.messages.GithubCommitsJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubRepoJobMessage;
import com.xebialabs.agatha.crawlers.github.models.Commit;
import com.xebialabs.agatha.crawlers.github.models.dtos.CollectionResponse;
import com.xebialabs.agatha.crawlers.github.services.GithubBaseCrawl;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubCommitsCrawl
extends GithubBaseCrawl<GithubCommitsJobMessage, CollectionResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(GithubCommitsCrawl.class);

    public GithubCommitsCrawl(GithubCrawler crawler, GithubCommitsJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new GithubResponseFetcher(crawler));
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            GithubJobMessage msg = ((GithubCrawler)this.crawler).generateNewMessage(GithubCommitsJobMessage.class, this.message).setLimit(((GithubCommitsJobMessage)this.message).getLimit()).setPage(((GithubCommitsJobMessage)this.message).nextPage());
            return this.createDataMessage(GithubCommitsJobMessage.class.getSimpleName(), msg);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<CollectionResponse> processGithubMessage() throws CrawlerWorkException {
        logger.debug("Process GithubCommitsJobMessage for endpoint {} - org {}, repo - {} ", new Object[]{((GithubCommitsJobMessage)this.message).getBaseUrl(), ((GithubCommitsJobMessage)this.message).getOrgName(), ((GithubCommitsJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse<CollectionResponse> crawledDataWrappedResponse = this.getResponseFetcher().fetchEntities(new TypeReference<List<Commit>>(){}, ((GithubCommitsJobMessage)this.message).url(((GithubCrawler)this.crawler).getOldestValidDate()));
        this.handleResponse((CollectionResponse)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(CollectionResponse<Commit> response) throws CrawlerWorkException {
        logger.debug("Found {} commits in org - {}, repo - {}", new Object[]{response.getResults().size(), ((GithubCommitsJobMessage)this.message).getOrgName(), ((GithubCommitsJobMessage)this.message).getRepoName()});
        List<Commit> commits = response.getResults();
        this.sendCommitDepthJobMessages((GithubRepoJobMessage)this.message, commits.stream().map(Commit::getSha).collect(Collectors.toSet()));
    }
}

