/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawlerRateLimited;
import com.xebialabs.agatha.crawlers.CrawlerExecutor;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubUrlHelper;
import com.xebialabs.agatha.crawlers.github.components.GithubCrawlResolver;
import com.xebialabs.agatha.crawlers.github.messages.GithubJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubRepoJobMessage;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.crawlers.shared.utils.ProbeUtils;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.CrawlerCredentialsDTO;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubCrawler
extends AbstractHttpCrawlerRateLimited {
    private static final Logger logger = LoggerFactory.getLogger(GithubCrawler.class);
    private final CrawlResolver<GithubCrawler> crawlResolver = new GithubCrawlResolver();
    private static final LoadingCache<CrawlerCredentialsDTO.CredentialsWrapper, Boolean> blockedCredentials = GithubCrawler.buildCache(180000L);

    public GithubCrawler() {
        super("GithubPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD);
    }

    public GithubCrawler(Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        super("GithubPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD, ingestionApiProvider);
    }

    protected static LoadingCache<CrawlerCredentialsDTO.CredentialsWrapper, Boolean> buildCache(long rateLimitWaitTime) {
        return CacheBuilder.newBuilder().concurrencyLevel(AgathaConfiguration.getCrawlerThreads()).maximumSize(50L).expireAfterWrite(rateLimitWaitTime, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<CrawlerCredentialsDTO.CredentialsWrapper, Boolean>(){

            public Boolean load(CrawlerCredentialsDTO.CredentialsWrapper key) throws Exception {
                return true;
            }
        });
    }

    protected void switchCredentials(List<CrawlerCredentialsDTO.CredentialsWrapper> credentialsList) {
        List availableCredentials = this.getAvailableCredentialsStream(credentialsList).collect(Collectors.toList());
        if (!availableCredentials.isEmpty()) {
            super.switchCredentials(availableCredentials);
        } else {
            super.switchCredentials(credentialsList);
        }
    }

    protected void executeSingleLoop() {
        if (this.shouldBlockAllThreads.get()) {
            logger.warn("Got sleep request from another thread, sleeping thread for {} ms..", (Object)180000L);
            try {
                Thread.sleep(180000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                logger.warn("Exception while trying to sleep: {}", (Throwable)ie);
            }
        }
        super.executeSingleLoop();
    }

    protected ObjectMapper createMapper() {
        ObjectMapper mapper = super.createMapper();
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    protected CrawlerJobResult crawlItem(CrawlerJobWrapper crawlerJob) {
        try {
            CrawlService crawl = this.crawlResolver.resolve((AbstractCrawler)this, crawlerJob);
            crawl.execute();
            return CrawlerJobResult.success();
        }
        catch (CrawlerWorkException e) {
            return this.handleCrawlerException(crawlerJob, e);
        }
    }

    protected ProbeResultMetadataVM probe(CrawlerJobWrapper crawlerJob) {
        Request request;
        ProbeResultMetadataVM result = new ProbeResultMetadataVM().setEndpoint(this.endpoint.toString()).setUsername(this.username);
        try {
            request = new Request.Builder().url(GithubUrlHelper.probeUrl(this.endpoint)).addHeader("Accept", "application/vnd.github.v3+json").build();
        }
        catch (CrawlerWorkException e) {
            logger.error(e.getMessage());
            return result.setSuccess(false).setReason("Unable to build probe url: " + e.getMessage());
        }
        ProbeUtils.BasicProbeResult basicProbeResult = ProbeUtils.basicProbe((Request)request, (OkHttpClient)((OkHttpClient)this.getClient()));
        result.setReason(basicProbeResult.getResult());
        if (basicProbeResult.isSuccess()) {
            logger.info("Probe success! user/org: {}", (Object)result.getUsername());
            result.setSuccess(true);
        } else {
            logger.warn("Github probe was not successful for user/org: {}", (Object)result.getUsername());
            result.setSuccess(false);
        }
        return result;
    }

    public <V extends BaseCrawlerMessage> V generateNewMessage(Class<V> cls, BaseCrawlerMessage oldMsg) throws IllegalAccessException, InstantiationException {
        GithubJobMessage old;
        GithubJobMessage newMsg;
        BaseCrawlerMessage v = super.generateNewMessage(cls, oldMsg);
        if (v instanceof GithubRepoJobMessage && oldMsg instanceof GithubRepoJobMessage) {
            newMsg = (GithubRepoJobMessage)v;
            old = (GithubRepoJobMessage)oldMsg;
            ((GithubRepoJobMessage)newMsg).setRepoId(((GithubRepoJobMessage)old).getRepoId()).setRepoName(((GithubRepoJobMessage)old).getRepoName()).setOrgId(((GithubRepoJobMessage)old).getOrgId()).setBaseUrl(old.getBaseUrl());
        }
        if (v instanceof GithubJobMessage && oldMsg instanceof GithubJobMessage) {
            newMsg = (GithubJobMessage)v;
            old = (GithubJobMessage)oldMsg;
            newMsg.setBaseUrl(old.getBaseUrl()).setOrgName(old.getOrgName());
        }
        return (V)v;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error(e.getMessage(), e));
        new CrawlerExecutor(GithubCrawler::new).execute();
    }

    public long waitDurationForRateLimit() {
        return 180000L;
    }

    public LoadingCache<CrawlerCredentialsDTO.CredentialsWrapper, Boolean> getBlockedCredentials() {
        return blockedCredentials;
    }
}

