/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.transform.converters;

import com.xebialabs.agatha.crawlers.github.GithubUtil;
import com.xebialabs.agatha.crawlers.github.models.PullRequest;
import com.xebialabs.agatha.crawlers.github.transform.models.PullRequestUM;
import com.xebialabs.agatha.crawlers.shared.PluginConstants;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.HashMap;

public class PullRequestConverter
implements UMConverter<PullRequestUM, PullRequest> {
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;
    private String organization;
    private String repo;

    public PullRequestConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
    }

    public String getOrganization() {
        return this.organization;
    }

    public PullRequestConverter setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public String getRepo() {
        return this.repo;
    }

    public PullRequestConverter setRepo(String repo) {
        this.repo = repo;
        return this;
    }

    public UMWrappedEntity<PullRequestUM> convert(PullRequest pullRequest) {
        PullRequestUM um = new PullRequestUM();
        this.populateTopLevelFields(pullRequest, um);
        this.populateUrlParts(pullRequest, um);
        this.populateOther(pullRequest, um);
        this.populateAdditionalFields(um);
        return this.wrappedEntity(pullRequest, um);
    }

    private void populateTopLevelFields(PullRequest pullRequest, PullRequestUM um) {
        um.setId(this.generateId(pullRequest.getNumber() + ""));
        um.setTitle(pullRequest.getTitle());
        um.setStartMs(pullRequest.getCreatedAt().getTime());
        um.setFinishMs(pullRequest.getUpdatedAt().getTime());
        um.setState(this.prStatus(pullRequest.getState().toUpperCase()));
    }

    private void populateOther(PullRequest pullRequest, PullRequestUM um) {
        PullRequestUM.Other other = new PullRequestUM.Other();
        other.setRaw((Object)pullRequest);
        other.setChangedFiles(pullRequest.getChangedFiles());
        other.setChangedLines(pullRequest.getAdditions() + pullRequest.getDeletions());
        other.setComments(pullRequest.getComments() + pullRequest.getReviewComments());
        other.setCommits(pullRequest.getCommits());
        other.setCreatedBy(pullRequest.getUser().getLogin());
        other.setDescription(pullRequest.getBody());
        if (pullRequest.getMergedBy() != null) {
            other.setMergedBy(pullRequest.getMergedBy().getLogin());
        }
        this.populateRelations(pullRequest, other);
        um.setOther(other);
    }

    private void populateRelations(PullRequest pullRequest, PullRequestUM.Other other) {
        PullRequestUM.Relations relations = new PullRequestUM.Relations();
        HashMap<String, Object> commitsMap = new HashMap<String, Object>();
        commitsMap.put("to", pullRequest.getCommitShas());
        relations.setCommits(commitsMap);
        relations.setLastCommitId(this.lastCommitId(pullRequest));
        if (pullRequest.isMerged()) {
            relations.setMergeCommitId(pullRequest.getMergeCommitSha());
        }
        other.setRelations(relations);
    }

    private String lastCommitId(PullRequest pullRequest) {
        if (pullRequest.getCommitShas().isEmpty()) {
            return null;
        }
        return pullRequest.getCommitShas().get(pullRequest.getCommitShas().size() - 1);
    }

    private void populateUrlParts(PullRequest pullRequest, PullRequestUM um) {
        HashMap<String, String> urlParts = new HashMap<String, String>();
        urlParts.put("repository", GithubUtil.generateDataId(this.organization, this.repo));
        urlParts.put("organization", this.organization);
        urlParts.put("repo", this.repo);
        urlParts.put("id", pullRequest.getNumber() + "");
        um.setUrlParts(urlParts);
    }

    private void populateAdditionalFields(PullRequestUM um) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("organization", this.organization);
        fields.put("repo", this.repo);
        um.setAdditionalFields(fields);
    }

    private String prStatus(String status) {
        if (PluginConstants.contains(PluginConstants.PullRequestState.class, (String)status)) {
            return status;
        }
        switch (status) {
            case "CLOSED": {
                return PluginConstants.PullRequestState.MERGED.name();
            }
        }
        return PluginConstants.PullRequestState.DECLINED.name();
    }

    private String generateId(String id) {
        return GithubUtil.generateDataId(this.organization, this.repo, id);
    }

    private UMWrappedEntity<PullRequestUM> wrappedEntity(PullRequest pullRequest, PullRequestUM um) {
        return new UMWrappedEntity(this.pluginId, this.pluginVersion, this.type, this.typeVersion, (Object)um, DataSourceTypeEnum.PULL_REQUEST).setId(um.getId()).setVersion(pullRequest.getUpdatedAt().getTime() + "").wrap();
    }
}

