/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseFetcher;
import com.xebialabs.agatha.crawlers.github.messages.GithubBranchJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubCommitsJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubPullRequestsJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubRepoJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubTagsJobMessage;
import com.xebialabs.agatha.crawlers.github.models.Repository;
import com.xebialabs.agatha.crawlers.github.models.dtos.CollectionResponse;
import com.xebialabs.agatha.crawlers.github.services.GithubBaseCrawl;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubJobCrawl
extends GithubBaseCrawl<GithubJobMessage, CollectionResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(GithubJobCrawl.class);
    protected final List<String> repoFilter = this.filters("GITHUB_REPOS");

    public GithubJobCrawl(GithubCrawler crawler, GithubJobMessage message) {
        super(crawler, message, null, new GithubResponseFetcher(crawler));
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            GithubJobMessage msg = ((GithubCrawler)this.crawler).generateNewMessage(GithubJobMessage.class, this.message).setLimit(((GithubJobMessage)this.message).getLimit()).setPage(((GithubJobMessage)this.message).nextPage());
            return this.createDataMessage(GithubJobMessage.class.getSimpleName(), msg);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<CollectionResponse> processGithubMessage() throws CrawlerWorkException {
        logger.debug("Process GithubJobMessage for Url {}.", (Object)((GithubJobMessage)this.message).getBaseUrl());
        CrawledDataWrappedResponse<CollectionResponse> crawledDataWrappedResponse = this.getResponseFetcher().fetchEntities(new TypeReference<List<Repository>>(){}, ((GithubJobMessage)this.message).url());
        this.handleResponse((CollectionResponse)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(CollectionResponse response) throws CrawlerWorkException {
        logger.debug("Found {} repos in account {}", (Object)response.getResults().size(), (Object)((GithubCrawler)this.crawler).getUsername());
        List results = response.getResults();
        List filteredResults = results.stream().filter(r -> this.filter(this.repoFilter, r.getName())).collect(Collectors.toList());
        for (Repository r2 : filteredResults) {
            this.sendAllMessages(r2);
        }
    }

    private void sendAllMessages(Repository r) throws CrawlerWorkException {
        this.sendMessage(r, GithubBranchJobMessage.class);
        this.sendMessage(r, GithubCommitsJobMessage.class);
        this.sendMessage(r, GithubTagsJobMessage.class);
        this.sendMessage(r, GithubPullRequestsJobMessage.class);
    }

    private <C extends GithubRepoJobMessage> void sendMessage(Repository r, Class<C> clazz) throws CrawlerWorkException {
        try {
            GithubRepoJobMessage msg = this.populateRepoProperties((GithubRepoJobMessage)((Object)((GithubCrawler)this.crawler).generateNewMessage(clazz, this.message)), r);
            ((GithubCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(clazz.getSimpleName(), msg));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private <C extends GithubRepoJobMessage> C populateRepoProperties(C m, Repository r) {
        m.setRepoId(r.getId()).setRepoName(r.getName()).setRepoId(r.getId()).setOrgName(r.getOwner().getName());
        return m;
    }
}

