/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.components;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.messages.GithubBranchJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubCommitJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubCommitsJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubPullRequestJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubPullRequestsJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubSimpleTagJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubTagJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubTagsJobMessage;
import com.xebialabs.agatha.crawlers.github.services.GithubBranchCrawl;
import com.xebialabs.agatha.crawlers.github.services.GithubCommitCrawl;
import com.xebialabs.agatha.crawlers.github.services.GithubCommitsCrawl;
import com.xebialabs.agatha.crawlers.github.services.GithubJobCrawl;
import com.xebialabs.agatha.crawlers.github.services.GithubPullRequestCrawl;
import com.xebialabs.agatha.crawlers.github.services.GithubPullRequestsCrawl;
import com.xebialabs.agatha.crawlers.github.services.GithubSimpleTagCrawl;
import com.xebialabs.agatha.crawlers.github.services.GithubTagCrawl;
import com.xebialabs.agatha.crawlers.github.services.GithubTagsCrawl;
import com.xebialabs.agatha.crawlers.shared.components.BaseCrawlFactory;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.io.IOException;

public class GithubCrawlFactory
extends BaseCrawlFactory<GithubCrawler> {
    private CrawlService jobCrawl(GithubCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new GithubJobCrawl(crawler, (GithubJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, GithubJobMessage.class)));
    }

    private CrawlService branchCrawl(GithubCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new GithubBranchCrawl(crawler, (GithubBranchJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, GithubBranchJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService commitsCrawl(GithubCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new GithubCommitsCrawl(crawler, (GithubCommitsJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, GithubCommitsJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService commitCrawl(GithubCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new GithubCommitCrawl(crawler, (GithubCommitJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, GithubCommitJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService tagsCrawl(GithubCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new GithubTagsCrawl(crawler, (GithubTagsJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, GithubTagsJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService tagCrawl(GithubCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new GithubTagCrawl(crawler, (GithubTagJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, GithubTagJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService pullRequestsCrawl(GithubCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new GithubPullRequestsCrawl(crawler, (GithubPullRequestsJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, GithubPullRequestsJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService pullRequestCrawl(GithubCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new GithubPullRequestCrawl(crawler, (GithubPullRequestJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, GithubPullRequestJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService simpleTagCrawl(GithubCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new GithubSimpleTagCrawl(crawler, (GithubSimpleTagJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, GithubSimpleTagJobMessage.class)), crawlerDataMessage);
    }

    public CrawlService getInstance(GithubCrawler crawler, BaseCrawlerMessage message) throws CrawlerWorkException {
        CrawlService crawlService;
        try {
            switch (message.getDataKey().toLowerCase()) {
                case "githubjobmessage": {
                    crawlService = this.jobCrawl(crawler, message);
                    break;
                }
                case "githubbranchjobmessage": {
                    crawlService = this.branchCrawl(crawler, message);
                    break;
                }
                case "githubcommitsjobmessage": {
                    crawlService = this.commitsCrawl(crawler, message);
                    break;
                }
                case "githubcommitjobmessage": {
                    crawlService = this.commitCrawl(crawler, message);
                    break;
                }
                case "githubtagsjobmessage": {
                    crawlService = this.tagsCrawl(crawler, message);
                    break;
                }
                case "githubtagjobmessage": {
                    crawlService = this.tagCrawl(crawler, message);
                    break;
                }
                case "githubpullrequestsjobmessage": {
                    crawlService = this.pullRequestsCrawl(crawler, message);
                    break;
                }
                case "githubpullrequestjobmessage": {
                    crawlService = this.pullRequestCrawl(crawler, message);
                    break;
                }
                case "githubsimpletagjobmessage": {
                    crawlService = this.simpleTagCrawl(crawler, message);
                    break;
                }
                default: {
                    throw new CrawlerWorkException("No Crawler implementation found.");
                }
            }
        }
        catch (IOException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
        return crawlService;
    }
}

