/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class CrawlerInputStream
extends InputStream {
    private final Reader reader;
    private boolean readerFinished;
    private byte[] prefix;
    private int prefixOffset;
    private byte[] suffix;
    private int suffixOffset;
    private char[] charBuffer = new char[4096];

    public CrawlerInputStream(String json, Reader reader) {
        this.reader = reader;
        int pos = json.indexOf("@~DATA_STREAM~@");
        if (pos == -1) {
            throw new IllegalArgumentException("Incorrect json, should contain [@~DATA_STREAM~@]");
        }
        if (pos != json.lastIndexOf("@~DATA_STREAM~@")) {
            throw new IllegalArgumentException("Incorrect json, should contain [@~DATA_STREAM~@] only one time");
        }
        this.prefix = json.substring(0, pos).getBytes();
        this.suffix = json.substring(pos + "@~DATA_STREAM~@".length()).getBytes();
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) == 0) {
            return -1;
        }
        return b[0];
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        if (this.prefixOffset < this.prefix.length) {
            int toCopy = Integer.min(len, this.prefix.length - this.prefixOffset);
            System.arraycopy(this.prefix, this.prefixOffset, b, off, toCopy);
            this.prefixOffset += toCopy;
            return toCopy;
        }
        if (!this.readerFinished) {
            int toRead = Integer.min(len / 6 - 1, this.charBuffer.length);
            int read = this.reader.read(this.charBuffer, 0, toRead);
            if (read == -1) {
                this.readerFinished = true;
            } else {
                String s = JSONObject.quote((String)new String(this.charBuffer, 0, read));
                byte[] bytes = s.substring(1, s.length() - 1).getBytes();
                System.arraycopy(bytes, 0, b, off, bytes.length);
                return bytes.length;
            }
        }
        if (this.suffixOffset < this.suffix.length) {
            int toCopy = Integer.min(len, this.suffix.length - this.suffixOffset);
            System.arraycopy(this.suffix, this.suffixOffset, b, off, toCopy);
            this.suffixOffset += toCopy;
            return toCopy;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        super.close();
    }
}

