/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.github.GithubCrawler;
import com.xebialabs.agatha.crawlers.github.GithubUrlHelper;
import com.xebialabs.agatha.crawlers.github.components.GithubResponseFetcher;
import com.xebialabs.agatha.crawlers.github.messages.GithubPullRequestJobMessage;
import com.xebialabs.agatha.crawlers.github.messages.GithubRepoJobMessage;
import com.xebialabs.agatha.crawlers.github.models.PullRequest;
import com.xebialabs.agatha.crawlers.github.models.Sha;
import com.xebialabs.agatha.crawlers.github.models.dtos.CollectionResponse;
import com.xebialabs.agatha.crawlers.github.repository.PullRequestRepository;
import com.xebialabs.agatha.crawlers.github.services.GithubBaseCrawl;
import com.xebialabs.agatha.crawlers.github.transform.converters.PullRequestConverter;
import com.xebialabs.agatha.crawlers.github.transform.models.PullRequestUM;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubPullRequestCrawl
extends GithubBaseCrawl<GithubPullRequestJobMessage, PullRequest> {
    private static final Logger logger = LoggerFactory.getLogger(GithubPullRequestCrawl.class);
    private final UMConverter<PullRequestUM, PullRequest> converter;
    private final KeyValueRepository<PullRequestUM> repository;

    public GithubPullRequestCrawl(GithubCrawler crawler, GithubPullRequestJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new GithubResponseFetcher(crawler));
        this.converter = new PullRequestConverter("GithubPlugin", "v1", "PULL_REQUEST", "v1").setOrganization(message.getOrgName()).setRepo(message.getRepoName());
        this.repository = new PullRequestRepository(crawler, dataMessage);
    }

    @Override
    protected CrawledDataWrappedResponse<PullRequest> processGithubMessage() throws CrawlerWorkException {
        logger.debug("Process GithubPullRequestJobMessage for endpoint {} - pull request - {}, org {}, repo - {}", new Object[]{((GithubPullRequestJobMessage)this.message).getBaseUrl(), ((GithubPullRequestJobMessage)this.message).getNumber(), ((GithubPullRequestJobMessage)this.message).getOrgName(), ((GithubPullRequestJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse crawledDataWrappedResponse = this.getResponseFetcher().fetchEntity(PullRequest.class, ((GithubPullRequestJobMessage)this.message).url());
        this.handleResponse((PullRequest)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(PullRequest pullRequest) throws CrawlerWorkException {
        this.enrichPR(pullRequest);
        this.savePR(pullRequest);
    }

    private void enrichPR(PullRequest pullRequest) throws CrawlerWorkException {
        CrawledDataWrappedResponse<CollectionResponse> response;
        boolean runLoop;
        int page = 1;
        ArrayList<String> allCommitIds = new ArrayList<String>();
        do {
            URL pullRequestCommitsURL = GithubUrlHelper.pullRequestCommitsURL(((GithubPullRequestJobMessage)this.message).getBaseUrl(), 50, page++, ((GithubPullRequestJobMessage)this.message).getOrgName(), ((GithubPullRequestJobMessage)this.message).getRepoName(), String.valueOf(((GithubPullRequestJobMessage)this.message).getNumber()));
            response = this.getResponseFetcher().fetchEntities(new TypeReference<List<Sha>>(){}, pullRequestCommitsURL);
            List shas = ((CollectionResponse)((Object)response.getEntity())).getResults();
            allCommitIds.addAll(shas.stream().map(Sha::getSha).collect(Collectors.toList()));
        } while (runLoop = ((CollectionResponse)((Object)response.getEntity())).hasNext());
        pullRequest.setCommitShas(allCommitIds);
    }

    private void savePR(PullRequest pullRequest) throws CrawlerWorkException {
        logger.debug("Saving pull request {} in project - {}, repo - {}", new Object[]{pullRequest.getNumber(), ((GithubPullRequestJobMessage)this.message).getOrgName(), ((GithubPullRequestJobMessage)this.message).getRepoName()});
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)pullRequest);
        boolean crawlCommits = this.repository.save(umWrappedEntity);
        if (crawlCommits) {
            this.sendCommitDepthJobMessages((GithubRepoJobMessage)this.message, new HashSet<String>(pullRequest.getCommitShas()));
        }
    }
}

