/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.github.transform.converters;

import com.xebialabs.agatha.crawlers.github.GithubUtil;
import com.xebialabs.agatha.crawlers.github.models.Commit;
import com.xebialabs.agatha.crawlers.github.models.User;
import com.xebialabs.agatha.crawlers.github.transform.models.CommitUM;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitConverter
implements UMConverter<CommitUM, Commit> {
    private static final Logger logger = LoggerFactory.getLogger(CommitConverter.class);
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;
    private String organization;
    private String repo;

    public CommitConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
    }

    public UMWrappedEntity<CommitUM> convert(Commit entity) {
        CommitUM um = new CommitUM();
        um.setId(this.generateId(entity.getSha()));
        um.setMessage(entity.getCommit().getMessage());
        this.populateAuthor(entity.getCommit().getAuthor(), um);
        this.populateStartMs(entity, um);
        this.populateUrlParts(entity, um);
        this.populateOther(entity, um);
        this.populateAdditionalFields(um);
        return this.wrappedEntity(entity, um);
    }

    private void populateAuthor(User user, CommitUM um) {
        um.setAuthorName(user.getName());
        um.setAuthorEmail(user.getEmail());
    }

    private void populateStartMs(Commit entity, CommitUM um) {
        um.setStartMs(entity.getCommit().getAuthor().getTimeStamp().getTime());
    }

    private void populateAdditionalFields(CommitUM um) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("organization", this.organization);
        fields.put("repo", this.repo);
        um.setAdditionalFields(fields);
    }

    private void populateOther(Commit entity, CommitUM um) {
        CommitUM.Other other = new CommitUM.Other();
        other.setChangedLines(entity.getStats().getTotal());
        other.setRaw((Object)entity);
        this.populateRelations(entity, other);
        um.setOther(other);
    }

    private void populateRelations(Commit entity, CommitUM.Other other) {
        HashMap<String, Object> relations = new HashMap<String, Object>();
        List parents = entity.getParents().stream().map(o -> this.generateId(o.getSha())).collect(Collectors.toList());
        relations.put("sha", entity.getSha());
        relations.put("parents", parents);
        other.setRelations(relations);
    }

    private void populateUrlParts(Commit entity, CommitUM um) {
        HashMap<String, String> urlParts = new HashMap<String, String>();
        urlParts.put("repository", GithubUtil.generateDataId(this.organization, this.repo));
        urlParts.put("sha", entity.getSha());
        urlParts.put("organization", this.organization);
        urlParts.put("repo", this.repo);
        um.setUrlParts(urlParts);
    }

    private String generateId(String id) {
        return GithubUtil.generateDataId(this.organization, this.repo, id);
    }

    private UMWrappedEntity<CommitUM> wrappedEntity(Commit entity, CommitUM um) {
        return new UMWrappedEntity(this.pluginId, this.pluginVersion, this.type, this.typeVersion, (Object)um, DataSourceTypeEnum.COMMIT).setId(um.getId()).setVersion(entity.getSha()).wrap();
    }

    public String getRepo() {
        return this.repo;
    }

    public CommitConverter setRepo(String repo) {
        this.repo = repo;
        return this;
    }

    public String getOrganization() {
        return this.organization;
    }

    public CommitConverter setOrganization(String organization) {
        this.organization = organization;
        return this;
    }
}

