/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf.builtin.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.io.IOException;
import java.text.ParseException;

public class TimestampDeserializer
extends StdDeserializer<Timestamp> {
    public TimestampDeserializer() {
        super(Timestamp.class);
    }

    public Timestamp deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentToken()) {
            case VALUE_STRING: {
                try {
                    return Timestamps.parse((String)parser.getText());
                }
                catch (ParseException e) {
                    throw context.weirdStringException(parser.getText(), Timestamp.class, e.getMessage());
                }
            }
        }
        throw context.wrongTokenException(parser, JsonToken.VALUE_STRING, TimestampDeserializer.wrongTokenMessage(context));
    }

    private static String wrongTokenMessage(DeserializationContext context) {
        return "Can not deserialize instance of com.google.protobuf.Timestamp out of " + context.getParser().getCurrentToken() + " token";
    }
}

