/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;

final class DnsNameResolver
extends NameResolver {
    private static final Logger logger = Logger.getLogger(DnsNameResolver.class.getName());
    private static final boolean isJndiAvailable = DnsNameResolver.jndiAvailable();
    @VisibleForTesting
    static boolean enableJndi = false;
    private DelegateResolver delegateResolver = this.pickDelegateResolver();
    private final String authority;
    private final String host;
    private final int port;
    private final SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource;
    private final SharedResourceHolder.Resource<ExecutorService> executorResource;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private ScheduledExecutorService timerService;
    @GuardedBy(value="this")
    private ExecutorService executor;
    @GuardedBy(value="this")
    private ScheduledFuture<?> resolutionTask;
    @GuardedBy(value="this")
    private boolean resolving;
    @GuardedBy(value="this")
    private NameResolver.Listener listener;
    private final Runnable resolutionRunnable = new Runnable(){

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };
    private final Runnable resolutionRunnableOnExecutor = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DnsNameResolver dnsNameResolver = DnsNameResolver.this;
            synchronized (dnsNameResolver) {
                if (!DnsNameResolver.this.shutdown) {
                    DnsNameResolver.this.executor.execute(DnsNameResolver.this.resolutionRunnable);
                }
            }
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DnsNameResolver(@Nullable String nsAuthority, String name, Attributes params, SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource, SharedResourceHolder.Resource<ExecutorService> executorResource) {
        this.timerServiceResource = timerServiceResource;
        this.executorResource = executorResource;
        URI nameUri = URI.create("//" + name);
        this.authority = (String)Preconditions.checkNotNull((Object)nameUri.getAuthority(), (String)"nameUri (%s) doesn't have an authority", (Object[])new Object[]{nameUri});
        this.host = (String)Preconditions.checkNotNull((Object)nameUri.getHost(), (Object)"host");
        if (nameUri.getPort() == -1) {
            Integer defaultPort = params.get(NameResolver.Factory.PARAMS_DEFAULT_PORT);
            if (defaultPort == null) throw new IllegalArgumentException("name '" + name + "' doesn't contain a port, and default port is not set in params");
            this.port = defaultPort;
            return;
        } else {
            this.port = nameUri.getPort();
        }
    }

    @Override
    public final String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public final synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.timerService = SharedResourceHolder.get(this.timerServiceResource);
        this.executor = SharedResourceHolder.get(this.executorResource);
        this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
    }

    @Override
    public final synchronized void refresh() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"not started");
        this.resolve();
    }

    @GuardedBy(value="this")
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(this.resolutionRunnable);
    }

    @Override
    public final synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.resolutionTask != null) {
            this.resolutionTask.cancel(false);
        }
        if (this.timerService != null) {
            this.timerService = SharedResourceHolder.release(this.timerServiceResource, this.timerService);
        }
        if (this.executor != null) {
            this.executor = SharedResourceHolder.release(this.executorResource, this.executor);
        }
    }

    final int getPort() {
        return this.port;
    }

    private DelegateResolver pickDelegateResolver() {
        JdkResolver jdkResolver = new JdkResolver();
        if (isJndiAvailable && enableJndi) {
            return new CompositeResolver(jdkResolver, new JndiResolver());
        }
        return jdkResolver;
    }

    @VisibleForTesting
    void setDelegateResolver(DelegateResolver delegateResolver) {
        this.delegateResolver = delegateResolver;
    }

    @VisibleForTesting
    static boolean jndiAvailable() {
        try {
            Class.forName("javax.naming.directory.InitialDirContext");
            Class.forName("com.sun.jndi.dns.DnsContextFactory");
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Unable to find JNDI DNS resolver, skipping", e);
            return false;
        }
        return true;
    }

    static /* synthetic */ ScheduledFuture access$000(DnsNameResolver x0) {
        return x0.resolutionTask;
    }

    static /* synthetic */ ScheduledFuture access$002(DnsNameResolver x0, ScheduledFuture x1) {
        x0.resolutionTask = x1;
        return x0.resolutionTask;
    }

    static /* synthetic */ NameResolver.Listener access$200(DnsNameResolver x0) {
        return x0.listener;
    }

    static /* synthetic */ boolean access$302(DnsNameResolver x0, boolean x1) {
        x0.resolving = x1;
        return x0.resolving;
    }

    static /* synthetic */ String access$400(DnsNameResolver x0) {
        return x0.host;
    }

    static /* synthetic */ int access$500(DnsNameResolver x0) {
        return x0.port;
    }

    static /* synthetic */ DelegateResolver access$600(DnsNameResolver x0) {
        return x0.delegateResolver;
    }

    static /* synthetic */ Runnable access$700(DnsNameResolver x0) {
        return x0.resolutionRunnableOnExecutor;
    }

    static /* synthetic */ ScheduledExecutorService access$800(DnsNameResolver x0) {
        return x0.timerService;
    }

    @VisibleForTesting
    static final class JndiResolver
    extends DelegateResolver {
        private static final String[] rrTypes = new String[]{"TXT"};

        JndiResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        ResolutionResults resolve(String host) throws NamingException {
            InitialDirContext dirContext = new InitialDirContext();
            javax.naming.directory.Attributes attrs = dirContext.getAttributes("dns:///" + host, rrTypes);
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            ArrayList<String> txtRecords = new ArrayList<String>();
            NamingEnumeration<? extends Attribute> rrGroups = attrs.getAll();
            try {
                while (rrGroups.hasMore()) {
                    Attribute rrEntry = rrGroups.next();
                    assert (Arrays.asList(rrTypes).contains(rrEntry.getID()));
                    NamingEnumeration<?> rrValues = rrEntry.getAll();
                    try {
                        while (rrValues.hasMore()) {
                            String rrValue = (String)rrValues.next();
                            txtRecords.add(rrValue);
                        }
                    }
                    finally {
                        rrValues.close();
                    }
                }
            }
            finally {
                rrGroups.close();
            }
            return new ResolutionResults(addresses, txtRecords);
        }
    }

    @VisibleForTesting
    static final class JdkResolver
    extends DelegateResolver {
        JdkResolver() {
        }

        @Override
        ResolutionResults resolve(String host) throws Exception {
            return new ResolutionResults(Arrays.asList(InetAddress.getAllByName(host)), Collections.<String>emptyList());
        }
    }

    @VisibleForTesting
    static final class CompositeResolver
    extends DelegateResolver {
        private final DelegateResolver jdkResovler;
        private final DelegateResolver jndiResovler;

        CompositeResolver(DelegateResolver jdkResovler, DelegateResolver jndiResovler) {
            this.jdkResovler = jdkResovler;
            this.jndiResovler = jndiResovler;
        }

        @Override
        ResolutionResults resolve(String host) throws Exception {
            ResolutionResults jdkResults = this.jdkResovler.resolve(host);
            List<InetAddress> addresses = jdkResults.addresses;
            List<String> txtRecords = Collections.emptyList();
            try {
                ResolutionResults jdniResults = this.jndiResovler.resolve(host);
                txtRecords = jdniResults.txtRecords;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to resolve TXT results", e);
            }
            return new ResolutionResults(addresses, txtRecords);
        }
    }

    @VisibleForTesting
    static final class ResolutionResults {
        final List<InetAddress> addresses;
        final List<String> txtRecords;

        ResolutionResults(List<InetAddress> addresses, List<String> txtRecords) {
            this.addresses = Collections.unmodifiableList((List)Preconditions.checkNotNull(addresses, (Object)"addresses"));
            this.txtRecords = Collections.unmodifiableList((List)Preconditions.checkNotNull(txtRecords, (Object)"txtRecords"));
        }
    }

    @VisibleForTesting
    static abstract class DelegateResolver {
        DelegateResolver() {
        }

        abstract ResolutionResults resolve(String var1) throws Exception;
    }
}

