/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.model;

import akka.annotation.InternalApi;
import akka.http.impl.util.StreamUtils$;
import akka.http.impl.util.StreamUtils$CaptureTerminationOp$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$Chunked$;
import akka.http.scaladsl.model.UniversalEntity;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;

public final class HttpEntity$ {
    public static HttpEntity$ MODULE$;
    private final HttpEntity.Strict Empty;

    static {
        new HttpEntity$();
    }

    public HttpEntity.Strict apply(String string) {
        return this.apply(ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029(), string);
    }

    public HttpEntity.Strict apply(byte[] bytes) {
        return this.apply((ContentType)ContentTypes$.MODULE$.application$divoctet$minusstream(), bytes);
    }

    public HttpEntity.Strict apply(ByteString data) {
        return this.apply((ContentType)ContentTypes$.MODULE$.application$divoctet$minusstream(), data);
    }

    public HttpEntity.Strict apply(ContentType.NonBinary contentType, String string) {
        return string.isEmpty() ? this.empty(contentType) : this.apply((ContentType)contentType, ByteString$.MODULE$.apply(string.getBytes(contentType.charset().nioCharset())));
    }

    public HttpEntity.Strict apply(ContentType contentType, byte[] bytes) {
        return bytes.length == 0 ? this.empty(contentType) : this.apply(contentType, ByteString$.MODULE$.apply(bytes));
    }

    public HttpEntity.Strict apply(ContentType contentType, ByteString data) {
        return data.isEmpty() ? this.empty(contentType) : new HttpEntity.Strict(contentType, data);
    }

    public UniversalEntity apply(ContentType contentType, long contentLength, Source<ByteString, Object> data) {
        return contentLength == 0L ? this.empty(contentType) : new HttpEntity.Default(contentType, contentLength, data);
    }

    public HttpEntity.Chunked apply(ContentType contentType, Source<ByteString, Object> data) {
        return HttpEntity$Chunked$.MODULE$.fromData(contentType, data);
    }

    public UniversalEntity fromFile(ContentType contentType, File file, int chunkSize) {
        return this.fromPath(contentType, file.toPath(), chunkSize);
    }

    public int fromFile$default$3() {
        return -1;
    }

    public UniversalEntity fromPath(ContentType contentType, Path file, int chunkSize) {
        long fileLength = Files.size(file);
        return fileLength > 0L ? new HttpEntity.Default(contentType, fileLength, chunkSize > 0 ? FileIO$.MODULE$.fromPath(file, chunkSize) : FileIO$.MODULE$.fromPath(file, FileIO$.MODULE$.fromPath$default$2())) : this.empty(contentType);
    }

    public int fromPath$default$3() {
        return -1;
    }

    public HttpEntity.Strict Empty() {
        return this.Empty;
    }

    public HttpEntity.Strict empty(ContentType contentType) {
        ContentType contentType2 = contentType;
        ContentType contentType3 = this.Empty().contentType();
        return !(contentType2 != null ? !contentType2.equals(contentType3) : contentType3 != null) ? this.Empty() : new HttpEntity.Strict(contentType, ByteString$.MODULE$.empty());
    }

    public <Mat> Source<ByteString, Mat> limitableByteSource(Source<ByteString, Mat> source) {
        return source;
    }

    public <Mat> Source<HttpEntity.ChunkStreamPart, Mat> limitableChunkSource(Source<HttpEntity.ChunkStreamPart, Mat> source) {
        return source;
    }

    @InternalApi
    public <T extends HttpEntity> Tuple2<T, Future<BoxedUnit>> captureTermination(T entity) {
        return StreamUtils$.MODULE$.transformEntityStream(entity, StreamUtils$CaptureTerminationOp$.MODULE$);
    }

    public HttpEntity HttpEntityScalaDSLSugar(HttpEntity httpEntity) {
        return httpEntity;
    }

    private HttpEntity$() {
        MODULE$ = this;
        this.Empty = new HttpEntity.Strict(ContentTypes$.MODULE$.NoContentType(), ByteString$.MODULE$.empty());
    }
}

