/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkins.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jenkins.models.JenkinsBuild;
import com.xebialabs.agatha.crawlers.jenkins.models.JenkinsBuildFlow;
import com.xebialabs.agatha.crawlers.jenkins.models.JenkinsFolder;
import com.xebialabs.agatha.crawlers.jenkinscommons.JenkinsURLHelper;
import com.xebialabs.agatha.crawlers.jenkinscommons.messages.JenkinsJobMessage;
import com.xebialabs.agatha.crawlers.shared.models.BaseEntity;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="_class", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=JenkinsFolder.class, name="com.cloudbees.hudson.plugins.folder.Folder"), @JsonSubTypes.Type(value=JenkinsBuildFlow.class, name="com.cloudbees.plugins.flow.BuildFlow"), @JsonSubTypes.Type(value=JenkinsBuild.class, name="com.cloudbees.plugins.flow.FlowRun"), @JsonSubTypes.Type(value=JenkinsBuildFlow.class, name="hudson.model.FreeStyleProject"), @JsonSubTypes.Type(value=JenkinsBuild.class, name="hudson.model.FreeStyleBuild"), @JsonSubTypes.Type(value=JenkinsFolder.class, name="org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject"), @JsonSubTypes.Type(value=JenkinsBuildFlow.class, name="org.jenkinsci.plugins.workflow.job.WorkflowJob"), @JsonSubTypes.Type(value=JenkinsBuild.class, name="org.jenkinsci.plugins.workflow.job.WorkflowRun"), @JsonSubTypes.Type(value=JenkinsBuildFlow.class, name="hudson.maven.MavenModuleSet"), @JsonSubTypes.Type(value=JenkinsBuild.class, name="hudson.maven.MavenModuleSetBuild"), @JsonSubTypes.Type(value=JenkinsBuildFlow.class, name="com.tikal.jenkins.plugins.multijob.MultiJobProject"), @JsonSubTypes.Type(value=JenkinsBuild.class, name="com.tikal.jenkins.plugins.multijob.MultiJobBuild")})
public class JenkinsBaseEntity<M extends JenkinsJobMessage>
extends BaseEntity {
    private String name;
    private String url;
    @JsonIgnore
    private String baseUrl;
    @JsonIgnore
    private String id;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public M generateJobMessage(JenkinsJobMessage oldMsg) throws IllegalAccessException, InstantiationException, CrawlerWorkException {
        JenkinsJobMessage newMsg = (JenkinsJobMessage)((Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0]).newInstance();
        newMsg.setTenantId(oldMsg.getTenantId());
        newMsg.setMetadata(oldMsg.getMetadata());
        newMsg.setPluginId(oldMsg.getPluginId());
        newMsg.setDataSourceDetails(oldMsg.getDataSourceDetails());
        newMsg.setName(this.name);
        newMsg.setUrl(JenkinsURLHelper.jobUrl((String)this.url, (String)oldMsg.getBaseUrl()));
        newMsg.setBaseUrl(oldMsg.getBaseUrl());
        return (M)newMsg;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public void validateUrl() throws CrawlerWorkException {
        if (this.url == null || this.baseUrl == null) {
            throw new CrawlerWorkException(String.format("Both job URL and server URL meta should be provided with Jenkins jobs! [%s]", new Object[]{this}));
        }
        try {
            URL serverUrl = new URL(this.getBaseUrl());
            URL jobUrl = new URL(this.getUrl());
            this.id = !serverUrl.getPath().equals("/") ? jobUrl.getPath().replace(serverUrl.getPath(), "").replaceAll("job/", "") : jobUrl.getPath().substring(1).replaceAll("job/", "");
            this.id = this.id.endsWith("/") ? URLDecoder.decode(this.id.substring(0, this.id.length() - 1), "UTF-8") : URLDecoder.decode(this.id, "UTF-8");
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

