/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkins.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jenkins.JenkinsCrawler;
import com.xebialabs.agatha.crawlers.jenkins.messages.JenkinsBuildFlowJobMessage;
import com.xebialabs.agatha.crawlers.jenkins.models.JenkinsBaseEntity;
import com.xebialabs.agatha.crawlers.jenkins.models.JenkinsBuild;
import com.xebialabs.agatha.crawlers.jenkins.models.dtos.BuildFlowResponse;
import com.xebialabs.agatha.crawlers.jenkins.services.JenkinsBaseCrawl;
import com.xebialabs.agatha.crawlers.jenkins.transform.converters.BuildConverter;
import com.xebialabs.agatha.crawlers.jenkinscommons.JenkinsURLHelper;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import com.xebialabs.impact.api.KnownArtefactRequestDescriptionVM;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsBuildFlowJobCrawl
extends JenkinsBaseCrawl<JenkinsBuildFlowJobMessage, BuildFlowResponse> {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsBuildFlowJobCrawl.class);

    public JenkinsBuildFlowJobCrawl(JenkinsCrawler crawler, JenkinsBuildFlowJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
    }

    protected CrawledDataWrappedResponse<BuildFlowResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process JenkinsBuildFlowJobMessage for endpoint {}", (Object)((JenkinsBuildFlowJobMessage)this.message).getUrl());
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(BuildFlowResponse.class, JenkinsURLHelper.apiUrl((String)((JenkinsBuildFlowJobMessage)this.message).getUrl(), (String)"api/json?tree=*,builds[name,url,timestamp,number]"));
        this.handleResponse((CrawledDataWrappedResponse<BuildFlowResponse>)response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<BuildFlowResponse> response) throws CrawlerWorkException {
        logger.debug("Got {} builds, under {}", (Object)((BuildFlowResponse)response.getEntity()).getBuilds().size(), (Object)((BuildFlowResponse)response.getEntity()).getName());
        List<JenkinsBuild> builds = this.filteredBuilds(((BuildFlowResponse)response.getEntity()).getBuilds());
        logger.debug("Filtered builds {} , under {}", (Object)builds.size(), (Object)((BuildFlowResponse)response.getEntity()).getName());
        for (JenkinsBuild build : builds) {
            this.sendNextMessage(build);
        }
    }

    private List<JenkinsBuild> filteredBuilds(List<JenkinsBuild> builds) throws CrawlerWorkException {
        if (((JenkinsBuildFlowJobMessage)this.message).getMetadata().isIncremental()) {
            builds = this.filterOnlyUnknownBuilds(builds);
            return builds;
        }
        return builds;
    }

    private List<JenkinsBuild> filterOnlyUnknownBuilds(List<JenkinsBuild> builds) throws CrawlerWorkException {
        for (JenkinsBuild build : builds) {
            build.setBaseUrl(((JenkinsBuildFlowJobMessage)this.message).getBaseUrl());
            build.validateUrl();
        }
        logger.debug("[Incremental Mode] Asking dedupe data for the following build IDs for filtering: {}", builds.stream().map(JenkinsBaseEntity::getId).collect(Collectors.toList()));
        Set knownBuilds = ((JenkinsCrawler)this.crawler).getKnownArtefacts(builds.stream().map(r -> new KnownArtefactRequestDescriptionVM().setArtefactId(BuildConverter.artifactId(r.getId(), r.getTimestamp())).setVersion("0")).collect(Collectors.toList()), ((JenkinsBuildFlowJobMessage)this.message).getDataSourceDetails().getDataSourceId(), DataSourceTypeEnum.BUILD).entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        logger.info("[Incremental Mode] Found {} known artifacts out of {} builds", (Object)knownBuilds.size(), (Object)builds.size());
        return builds.stream().filter(r -> !knownBuilds.contains(BuildConverter.artifactId(r.getId(), r.getTimestamp()))).collect(Collectors.toList());
    }
}

