/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.RateLimitApplicable;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.impact.api.CrawlerCredentialsDTO;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpCrawlerRateLimited
extends AbstractHttpCrawler
implements RateLimitApplicable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpCrawlerRateLimited.class);

    public AbstractHttpCrawlerRateLimited(String pluginId, AbstractHttpCrawler.AuthenticationTypes authenticationType) {
        super(pluginId, authenticationType);
    }

    public AbstractHttpCrawlerRateLimited(String pluginId, AbstractHttpCrawler.AuthenticationTypes authenticationType, Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        super(pluginId, authenticationType, ingestionApiProvider);
    }

    @Override
    protected CrawlerJobResult handleCrawlerException(CrawlerJobWrapper crawlerJob, CrawlerWorkException e) {
        return this.handleRateLimit(crawlerJob, e);
    }

    protected Stream<CrawlerCredentialsDTO.CredentialsWrapper> getAvailableCredentialsStream(List<CrawlerCredentialsDTO.CredentialsWrapper> credentialsList) {
        return credentialsList.stream().filter(c -> this.getBlockedCredentials().getIfPresent(c) == null);
    }

    private CrawlerJobResult handleRateLimit(CrawlerJobWrapper crawlerJob, CrawlerWorkException e) {
        try {
            logger.warn("{} rate limit reached, blocking current credentials [user - {}] until rate limit timeout ({} ms)..", this.getClass().getSimpleName(), this.username, this.waitDurationForRateLimit());
            this.getBlockedCredentials().put(new CrawlerCredentialsDTO.CredentialsWrapper().setUsername(this.username).setPassword(this.passwordOrToken), true);
            this.sendCrawlerTaskMessage(crawlerJob.getMessage());
            this.ackMessage(crawlerJob);
            if (this.getAvailableCredentialsStream(crawlerJob.getCredentialsPackage().getCredentials()).count() == 0L) {
                logger.warn("No credentials left to use, sleeping thread for {} ms..", (Object)this.waitDurationForRateLimit());
                this.shouldBlockAllThreads.set(true);
                Thread.sleep(this.waitDurationForRateLimit());
                this.shouldBlockAllThreads.set(false);
            }
            return null;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            logger.warn("Exception while trying to sleep: {}", ie);
        }
        catch (CrawlerWorkException we) {
            logger.error("Exception while sending task[{}] to queue: {}", (Object)crawlerJob.getMessage(), (Object)we);
        }
        return CrawlerJobResult.fail(e.getMessage());
    }
}

