@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  jira startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and JIRA_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\jira-8.2.27.jar;%APP_HOME%\lib\shared-lib-8.2.27.jar;%APP_HOME%\lib\xli-pluginsdk-java-8.2.27.jar;%APP_HOME%\lib\jackson-databind-2.9.2.jar;%APP_HOME%\lib\jackson-core-2.9.2.jar;%APP_HOME%\lib\akka-stream_2.12-2.5.12.jar;%APP_HOME%\lib\akka-actor_2.12-2.5.12.jar;%APP_HOME%\lib\scala-java8-compat_2.12-0.9.0.jar;%APP_HOME%\lib\akka-http_2.12-10.1.5.jar;%APP_HOME%\lib\guava-20.0.jar;%APP_HOME%\lib\api-models-8.2.20.jar;%APP_HOME%\lib\okhttp-3.6.0.jar;%APP_HOME%\lib\joda-time-2.9.9.jar;%APP_HOME%\lib\json-20170516.jar;%APP_HOME%\lib\commons-lang3-3.7.jar;%APP_HOME%\lib\jul-to-slf4j-1.7.21.jar;%APP_HOME%\lib\jcl-over-slf4j-1.7.21.jar;%APP_HOME%\lib\slf4j-api-1.7.21.jar;%APP_HOME%\lib\logback-classic-1.2.3.jar;%APP_HOME%\lib\janino-3.0.6.jar;%APP_HOME%\lib\akka-http-core_2.12-10.1.5.jar;%APP_HOME%\lib\akka-protobuf_2.12-2.5.12.jar;%APP_HOME%\lib\ssl-config-core_2.12-0.2.3.jar;%APP_HOME%\lib\akka-parsing_2.12-10.1.5.jar;%APP_HOME%\lib\scala-parser-combinators_2.12-1.1.0.jar;%APP_HOME%\lib\scala-library-2.12.6.jar;%APP_HOME%\lib\reactive-streams-1.0.2.jar;%APP_HOME%\lib\okio-1.11.0.jar;%APP_HOME%\lib\logback-core-1.2.3.jar;%APP_HOME%\lib\commons-compiler-3.0.6.jar;%APP_HOME%\lib\config-1.3.2.jar;%APP_HOME%\lib\jackson-annotations-2.9.0.jar

@rem Execute jira
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %JIRA_OPTS%  -classpath "%CLASSPATH%" com.xebialabs.agatha.crawlers.jira.JiraCrawler %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable JIRA_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%JIRA_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
