/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.um.converters;

import com.xebialabs.agatha.crawlers.jira.models.Issue;
import com.xebialabs.agatha.crawlers.jira.um.aggregators.AdditionalFieldsAggregator;
import com.xebialabs.agatha.crawlers.jira.um.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.jira.um.aggregators.CustomFieldsAggregator;
import com.xebialabs.agatha.crawlers.jira.um.aggregators.SystemFieldsAggregator;
import com.xebialabs.agatha.crawlers.jira.um.converters.JiraUMConverter;
import com.xebialabs.agatha.crawlers.jira.um.models.Ticket;
import com.xebialabs.agatha.crawlers.jira.utils.JiraUtils;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IssueConverter
extends JiraUMConverter<Ticket, Issue> {
    private final List<Aggregator> fieldAggregators;

    public IssueConverter(String pluginId, String pluginVersion, String type, String typeVersion, String storyPointsField) {
        super(type, typeVersion, pluginId, pluginVersion, DataSourceTypeEnum.TICKET);
        this.fieldAggregators = Stream.of(new SystemFieldsAggregator(storyPointsField), new AdditionalFieldsAggregator(), new CustomFieldsAggregator()).collect(Collectors.toList());
    }

    @Override
    protected Ticket transform(Issue entity) {
        Ticket ticket = new Ticket();
        this.fieldAggregators.forEach(aggregator -> aggregator.populate(ticket, entity));
        return ticket;
    }

    @Override
    protected String version(Issue entity) {
        return JiraUtils.value(entity, "updated_1");
    }

    @Override
    protected String id(Issue entity) {
        return entity.getId();
    }
}

