/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.repository;

import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.JiraCrawler;
import com.xebialabs.agatha.crawlers.jira.um.models.Ticket;
import com.xebialabs.agatha.crawlers.shared.repository.BaseRepository;
import com.xebialabs.agatha.crawlers.shared.transform.KeyValueCoordinatesGenerator;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketRepository
extends BaseRepository<JiraCrawler, List<Ticket>> {
    private static final Logger logger = LoggerFactory.getLogger(TicketRepository.class);

    public TicketRepository(JiraCrawler crawler, BaseCrawlerMessage dataMessage) {
        super((AbstractCrawler)crawler, dataMessage);
    }

    public boolean save(UMWrappedEntity<List<Ticket>> umData) throws CrawlerWorkException {
        TicketKeyValueCoordinatesGenerator<List<Ticket>> generator = new TicketKeyValueCoordinatesGenerator<List<Ticket>>(umData);
        boolean isKnown = this.save(umData, generator);
        logger.debug("Saved Jira Issue [version: {}]. IsKnown: {}", (Object)generator.version(), (Object)isKnown);
        return isKnown;
    }

    static class TicketKeyValueCoordinatesGenerator<E>
    implements KeyValueCoordinatesGenerator {
        private final UMWrappedEntity<E> umData;
        private static final String TYPE = "ticket";

        TicketKeyValueCoordinatesGenerator(UMWrappedEntity<E> umData) {
            this.umData = umData;
        }

        public String artifactId() {
            return String.format("%s-%s", TYPE, this.umData.getId());
        }

        public String version() {
            return this.umData.getVersion();
        }
    }
}

