/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.components.factories;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.JiraCrawler;
import com.xebialabs.agatha.crawlers.jira.messages.JiraFieldsCrawlMessage;
import com.xebialabs.agatha.crawlers.jira.messages.JiraIssueCrawlMessage;
import com.xebialabs.agatha.crawlers.jira.messages.JiraIssuesCrawlMessage;
import com.xebialabs.agatha.crawlers.jira.services.crawl.JiraFieldsCrawl;
import com.xebialabs.agatha.crawlers.jira.services.crawl.JiraIssueCrawl;
import com.xebialabs.agatha.crawlers.jira.services.crawl.JiraIssuesCrawl;
import com.xebialabs.agatha.crawlers.shared.components.BaseCrawlFactory;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.io.IOException;

public class JiraCrawlFactory
extends BaseCrawlFactory<JiraCrawler> {
    public CrawlService getInstance(JiraCrawler crawler, BaseCrawlerMessage message) throws CrawlerWorkException {
        CrawlService jiraCrawl = null;
        try {
            switch (message.getDataKey().toLowerCase()) {
                case "jirafieldscrawlmessage": {
                    jiraCrawl = this.fieldCrawl(crawler, message);
                    break;
                }
                case "jiraissuescrawlmessage": {
                    jiraCrawl = this.issuesCrawl(crawler, message);
                    break;
                }
                case "jiraissuecrawlmessage": {
                    jiraCrawl = this.issueCrawl(crawler, message);
                }
            }
        }
        catch (IOException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
        return jiraCrawl;
    }

    private CrawlService issueCrawl(JiraCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new JiraIssueCrawl(crawler, (JiraIssueCrawlMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, JiraIssueCrawlMessage.class)), crawlerDataMessage, crawler.getMapper());
    }

    private CrawlService issuesCrawl(JiraCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new JiraIssuesCrawl(crawler, (JiraIssuesCrawlMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, JiraIssuesCrawlMessage.class)), crawlerDataMessage);
    }

    private CrawlService fieldCrawl(JiraCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new JiraFieldsCrawl(crawler, (JiraFieldsCrawlMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, JiraFieldsCrawlMessage.class)), crawlerDataMessage);
    }
}

