/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.utils;

import com.xebialabs.agatha.crawlers.jira.models.Issue;
import java.util.Map;
import org.joda.time.DateTime;

public class JiraUtils {
    public static Long dateAsLong(String date) {
        return new DateTime((Object)date).toDate().getTime();
    }

    public static Object valueForKey(Map<String, Object> fields, String key, int index, String delimiter) {
        if (fields == null || fields.isEmpty() || fields.get(key.split(delimiter)[index]) == null) {
            return null;
        }
        if (JiraUtils.isLastKeyInPath(key, index, delimiter)) {
            return fields.getOrDefault(key.split(delimiter)[index], null);
        }
        if (fields.get(key.split(delimiter)[index]) instanceof Map) {
            return JiraUtils.valueForKey((Map)fields.get(key.split(delimiter)[index]), key, index + 1, delimiter);
        }
        return null;
    }

    private static boolean isLastKeyInPath(String key, int index, String delimiter) {
        return key.split(delimiter).length - 1 == index;
    }

    public static String value(Issue entity, String key) {
        if (entity.getVersionedRepresentations() == null || entity.getVersionedRepresentations().getProperties() == null) {
            return null;
        }
        Object value = JiraUtils.valueForKey(entity.getVersionedRepresentations().getProperties(), key, 0, "_");
        return value == null ? null : value.toString();
    }

    public static Long valueAsLong(Issue.VersionedRepresentations versionedRepresentations, String key) {
        Object updatedDate = JiraUtils.valueForKey(versionedRepresentations.getProperties(), key, 0, "_");
        return updatedDate != null ? JiraUtils.dateAsLong(updatedDate.toString()) : null;
    }
}

