/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.http.impl.engine.ws.FrameEvent$;
import akka.http.impl.engine.ws.FrameStart;
import akka.http.impl.engine.ws.Protocol;
import akka.http.impl.engine.ws.Protocol$Opcode$Binary$;
import akka.http.impl.engine.ws.Protocol$Opcode$Continuation$;
import akka.http.impl.engine.ws.Protocol$Opcode$Text$;
import akka.http.impl.engine.ws.Utf8Encoder$;
import akka.http.impl.util.StreamUtils$;
import akka.http.scaladsl.model.ws.BinaryMessage;
import akka.http.scaladsl.model.ws.Message;
import akka.http.scaladsl.model.ws.TextMessage;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.runtime.BooleanRef;

@InternalApi
public final class MessageToFrameRenderer$ {
    public static MessageToFrameRenderer$ MODULE$;

    static {
        new MessageToFrameRenderer$();
    }

    public Flow<Message, FrameStart, NotUsed> create(boolean serverSide) {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Source source;
            Message message = x0$1;
            if (message instanceof BinaryMessage.Strict) {
                BinaryMessage.Strict strict = (BinaryMessage.Strict)message;
                ByteString data = strict.data();
                source = MessageToFrameRenderer$.strictFrames$1(Protocol$Opcode$Binary$.MODULE$, data);
            } else if (message instanceof BinaryMessage) {
                BinaryMessage binaryMessage = (BinaryMessage)message;
                source = MessageToFrameRenderer$.streamedFrames$1(Protocol$Opcode$Binary$.MODULE$, binaryMessage.dataStream());
            } else if (message instanceof TextMessage.Strict) {
                TextMessage.Strict strict = (TextMessage.Strict)message;
                String text = strict.text();
                source = MessageToFrameRenderer$.strictFrames$1(Protocol$Opcode$Text$.MODULE$, ByteString$.MODULE$.apply(text, "UTF-8"));
            } else if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                source = MessageToFrameRenderer$.streamedFrames$1(Protocol$Opcode$Text$.MODULE$, textMessage.textStream().via((Graph)Utf8Encoder$.MODULE$));
            } else {
                throw new MatchError((Object)message);
            }
            return source;
        });
    }

    private static final Source strictFrames$1(Protocol.Opcode opcode, ByteString data) {
        return Source$.MODULE$.single((Object)FrameEvent$.MODULE$.fullFrame(opcode, (Option<Object>)None$.MODULE$, data, true, FrameEvent$.MODULE$.fullFrame$default$5(), FrameEvent$.MODULE$.fullFrame$default$6(), FrameEvent$.MODULE$.fullFrame$default$7()));
    }

    private static final Source streamedFrames$1(Protocol.Opcode opcode, Source data) {
        return (Source)data.via(StreamUtils$.MODULE$.statefulMap((Function0 & Serializable & scala.Serializable)() -> {
            BooleanRef isFirst = BooleanRef.create((boolean)true);
            return (Function1 & Serializable & scala.Serializable)data -> {
                Protocol.Opcode opcode;
                if (isFirst$1.elem) {
                    isFirst$1.elem = false;
                    opcode = opcode;
                } else {
                    opcode = Protocol$Opcode$Continuation$.MODULE$;
                }
                Protocol$Opcode$Continuation$ frameOpcode = opcode;
                return FrameEvent$.MODULE$.fullFrame(frameOpcode, (Option<Object>)None$.MODULE$, (ByteString)data, false, FrameEvent$.MODULE$.fullFrame$default$5(), FrameEvent$.MODULE$.fullFrame$default$6(), FrameEvent$.MODULE$.fullFrame$default$7());
            };
        })).$plus$plus((Graph)Source$.MODULE$.single((Object)FrameEvent$.MODULE$.emptyLastContinuationFrame()));
    }

    private MessageToFrameRenderer$() {
        MODULE$ = this;
    }
}

