/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.models;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xebialabs.agatha.crawlers.jira.extractor.ValueHolder;
import com.xebialabs.agatha.crawlers.jira.models.Changelog;
import com.xebialabs.agatha.crawlers.shared.models.BaseEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Issue
extends BaseEntity {
    private String id;
    private String self;
    private String key;
    private Fields fields;
    private Changelog changelog;
    @JsonIgnore
    private Map<String, ValueHolder> cleanedVersionRepresentation = new HashMap<String, ValueHolder>();
    private VersionedRepresentations versionedRepresentations;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public VersionedRepresentations getVersionedRepresentations() {
        return this.versionedRepresentations;
    }

    public String getStringValue(String key) {
        return Optional.ofNullable(this.cleanedVersionRepresentation.get(key)).flatMap(v -> {
            Object value;
            Map map;
            if (v.getValue() instanceof String) {
                return Optional.of((String)v.getValue());
            }
            if (v.getValue() instanceof Map && (map = (Map)v.getValue()).containsKey("value") && (value = map.get("value")) instanceof String) {
                return Optional.of((String)value);
            }
            return Optional.empty();
        }).orElse("");
    }

    public long getLongDateValue(String key) {
        String stringValue = this.getStringValue(key);
        if (stringValue == null || stringValue.equals("")) {
            return 0L;
        }
        return new DateTime((Object)stringValue).toInstant().getMillis();
    }

    public long getLongDueDateValue() {
        String stringValue = this.getStringValue("duedate");
        if (stringValue == null || stringValue.equals("")) {
            return 0L;
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(stringValue).getTime();
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<String> getListValue(String key) {
        return Optional.ofNullable(this.getCleanedVersionRepresentation().get(key)).map(v -> v.castToList()).orElse(Collections.emptyList());
    }

    public void setVersionedRepresentations(VersionedRepresentations versionedRepresentations) {
        this.versionedRepresentations = versionedRepresentations;
    }

    public Map<String, ValueHolder> getCleanedVersionRepresentation() {
        return this.cleanedVersionRepresentation;
    }

    public void setCleanedVersionRepresentation(Map<String, ValueHolder> cleanedVersionRepresentation) {
        this.cleanedVersionRepresentation = cleanedVersionRepresentation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Fields getFields() {
        return this.fields;
    }

    public void setFields(Fields fields) {
        this.fields = fields;
    }

    public Changelog getChangelog() {
        return this.changelog;
    }

    public Issue setChangelog(Changelog changelog) {
        this.changelog = changelog;
        return this;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class VersionedRepresentations {
        private Map<String, Object> properties = new HashMap<String, Object>();

        @JsonAnySetter
        public void add(String key, Object value) {
            this.properties.put(key, value);
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Fields {
        private Map<String, Object> fields = new HashMap<String, Object>();

        public Map<String, Object> getFields() {
            return this.fields;
        }

        @JsonAnySetter
        public void add(String key, Object value) {
            this.fields.put(key, value);
        }
    }
}

