/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.api;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.xebialabs.impact.api.CrawlerConfig;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CrawlerCredentialsDTO
implements Serializable {
    private URL endpoint;
    private URL baseUiUrl;
    private List<CredentialsWrapper> credentials = new ArrayList<CredentialsWrapper>();
    @JsonUnwrapped
    private CredentialFilters filters = new CredentialFilters();
    private double throttleFactor = 1.0;
    private CrawlerConfig crawlerConfig;

    public CredentialFilters getFilters() {
        return this.filters;
    }

    public CrawlerCredentialsDTO setFilters(CredentialFilters filters) {
        this.filters = filters;
        return this;
    }

    public double getThrottleFactor() {
        return this.throttleFactor;
    }

    public CrawlerCredentialsDTO setThrottleFactor(double throttleFactor) {
        this.throttleFactor = throttleFactor;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint != null ? this.endpoint.toString() : null;
    }

    public CrawlerCredentialsDTO setEndpoint(URL endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getBaseUiUrl() {
        return this.baseUiUrl != null ? this.baseUiUrl.toString() : null;
    }

    public CrawlerCredentialsDTO setBaseUiUrl(URL baseUiUrl) {
        this.baseUiUrl = baseUiUrl;
        return this;
    }

    public List<CredentialsWrapper> getCredentials() {
        return this.credentials;
    }

    public CrawlerCredentialsDTO addCredential(CredentialsWrapper credential) {
        this.credentials.add(credential);
        return this;
    }

    public CrawlerCredentialsDTO setCredentials(List<CredentialsWrapper> credentials) {
        this.credentials = credentials;
        return this;
    }

    public CrawlerConfig getCrawlerConfig() {
        return this.crawlerConfig;
    }

    public CrawlerCredentialsDTO setCrawlerConfig(CrawlerConfig crawlerConfig) {
        this.crawlerConfig = crawlerConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrawlerCredentialsDTO that = (CrawlerCredentialsDTO)o;
        return Double.compare(that.throttleFactor, this.throttleFactor) == 0 && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.baseUiUrl, that.baseUiUrl) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.baseUiUrl, this.credentials, this.filters, this.throttleFactor);
    }

    public String toString() {
        return "CrawlerCredentialsDTO{endpoint=" + this.endpoint + ", baseUiUrl=" + this.baseUiUrl + ", credentials=" + this.credentials + ", filters=" + this.filters + ", throttleFactor=" + this.throttleFactor + '}';
    }

    public static class CredentialsWrapper
    implements Serializable {
        private String username;
        private String password;

        public String getUsername() {
            return this.username;
        }

        public CredentialsWrapper setUsername(String username) {
            this.username = username;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public CredentialsWrapper setPassword(String password) {
            this.password = password;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CredentialsWrapper that = (CredentialsWrapper)o;
            return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.password);
        }

        public String toString() {
            return "CredentialsWrapper{username='" + this.username + '\'' + ", password='" + this.password + '\'' + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CredentialFilters
    implements Serializable {
        private Map<String, Map<String, List<String>>> filters = new HashMap<String, Map<String, List<String>>>();

        public Map<String, Map<String, List<String>>> getFilters() {
            return this.filters;
        }

        public CredentialFilters setFilters(Map<String, Map<String, List<String>>> filters) {
            this.filters = filters;
            return this;
        }

        @JsonAnySetter
        public void add(String key, Map<String, List<String>> value) {
            this.filters.put(key, value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CredentialFilters that = (CredentialFilters)o;
            return Objects.equals(this.filters, that.filters);
        }

        public int hashCode() {
            return Objects.hash(this.filters);
        }

        public String toString() {
            return "CredentialFilters{filters=" + this.filters + '}';
        }
    }
}

