/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Token;
import org.codehaus.janino.TokenStream;
import org.codehaus.janino.TokenType;

public class TokenStreamImpl
implements TokenStream {
    private final Scanner scanner;
    @Nullable
    private String optionalDocComment;
    @Nullable
    private Token pushback;
    @Nullable
    private Token nextToken;
    @Nullable
    private Token nextButOneToken;
    @Nullable
    private WarningHandler optionalWarningHandler;

    public TokenStreamImpl(Scanner scanner) {
        this.scanner = scanner;
        this.scanner.setIgnoreWhiteSpace(true);
    }

    private Token produceToken() throws CompileException, IOException {
        Token token;
        if (this.pushback != null) {
            Token result = this.pushback;
            this.pushback = null;
            return result;
        }
        block4: while (true) {
            token = this.scanner.produce();
            switch (token.type) {
                case WHITE_SPACE: 
                case C_PLUS_PLUS_STYLE_COMMENT: {
                    continue block4;
                }
                case C_STYLE_COMMENT: {
                    if (!token.value.startsWith("/**") || this.optionalDocComment == null) continue block4;
                    this.warning("MDC", "Misplaced doc comment", this.scanner.location());
                    this.optionalDocComment = null;
                    continue block4;
                }
            }
            break;
        }
        return token;
    }

    @Nullable
    public String doc() {
        String s2 = this.optionalDocComment;
        this.optionalDocComment = null;
        return s2;
    }

    @Override
    public Token peek() throws CompileException, IOException {
        if (this.nextToken == null) {
            this.nextToken = this.produceToken();
        }
        assert (this.nextToken != null);
        return this.nextToken;
    }

    @Override
    public Token peekNextButOne() throws CompileException, IOException {
        if (this.nextToken == null) {
            this.nextToken = this.produceToken();
        }
        if (this.nextButOneToken == null) {
            this.nextButOneToken = this.produceToken();
        }
        assert (this.nextButOneToken != null);
        return this.nextButOneToken;
    }

    @Override
    public Token read() throws CompileException, IOException {
        if (this.nextToken == null) {
            return this.produceToken();
        }
        Token result = this.nextToken;
        assert (result != null);
        this.nextToken = this.nextButOneToken;
        this.nextButOneToken = null;
        return result;
    }

    @Override
    public boolean peek(String suspected) throws CompileException, IOException {
        return this.peek().value.equals(suspected);
    }

    @Override
    public int peek(String[] suspected) throws CompileException, IOException {
        return TokenStreamImpl.indexOf(suspected, this.peek().value);
    }

    @Override
    public int peek(TokenType[] suspected) throws CompileException, IOException {
        return TokenStreamImpl.indexOf(suspected, this.peek().type);
    }

    @Override
    public boolean peekNextButOne(String suspected) throws CompileException, IOException {
        return this.peekNextButOne().value.equals(suspected);
    }

    @Override
    public void read(String expected) throws CompileException, IOException {
        String s2 = this.read().value;
        if (!s2.equals(expected)) {
            throw this.compileException("'" + expected + "' expected instead of '" + s2 + "'");
        }
    }

    @Override
    public int read(String[] expected) throws CompileException, IOException {
        int result;
        Token t = this.read();
        String value = t.value;
        int idx = TokenStreamImpl.indexOf(expected, value);
        if (idx != -1) {
            return idx;
        }
        if (value.startsWith(">") && (result = TokenStreamImpl.indexOf(expected, ">")) != -1) {
            Location loc = t.getLocation();
            this.nextToken = new Token(loc.getFileName(), loc.getLineNumber(), loc.getColumnNumber() + 1, TokenType.OPERATOR, value.substring(1));
            return result;
        }
        throw this.compileException("One of '" + TokenStreamImpl.join(expected, " ") + "' expected instead of '" + value + "'");
    }

    @Override
    public boolean peekRead(String suspected) throws CompileException, IOException {
        if (this.nextToken != null) {
            if (!this.nextToken.value.equals(suspected)) {
                return false;
            }
            this.nextToken = this.nextButOneToken;
            this.nextButOneToken = null;
            return true;
        }
        Token t = this.produceToken();
        if (t.value.equals(suspected)) {
            return true;
        }
        this.nextToken = t;
        return false;
    }

    @Override
    public int peekRead(String[] suspected) throws CompileException, IOException {
        if (this.nextToken != null) {
            int idx = TokenStreamImpl.indexOf(suspected, this.nextToken.value);
            if (idx == -1) {
                return -1;
            }
            this.nextToken = this.nextButOneToken;
            this.nextButOneToken = null;
            return idx;
        }
        Token t = this.produceToken();
        int idx = TokenStreamImpl.indexOf(suspected, t.value);
        if (idx != -1) {
            return idx;
        }
        this.nextToken = t;
        return -1;
    }

    @Override
    public boolean peekEof() throws CompileException, IOException {
        return this.peek().type == TokenType.END_OF_INPUT;
    }

    @Override
    @Nullable
    public String peekIdentifier() throws CompileException, IOException {
        Token t = this.peek();
        return t.type == TokenType.IDENTIFIER ? t.value : null;
    }

    @Override
    public boolean peekLiteral() throws CompileException, IOException {
        return this.peek(new TokenType[]{TokenType.INTEGER_LITERAL, TokenType.FLOATING_POINT_LITERAL, TokenType.BOOLEAN_LITERAL, TokenType.CHARACTER_LITERAL, TokenType.STRING_LITERAL, TokenType.NULL_LITERAL}) != -1;
    }

    @Override
    public String readIdentifier() throws CompileException, IOException {
        Token t = this.read();
        if (t.type != TokenType.IDENTIFIER) {
            throw this.compileException("Identifier expected instead of '" + t.value + "'");
        }
        return t.value;
    }

    @Override
    public String readOperator() throws CompileException, IOException {
        Token t = this.read();
        if (t.type != TokenType.OPERATOR) {
            throw this.compileException("Operator expected instead of '" + t.value + "'");
        }
        return t.value;
    }

    private static int indexOf(String[] strings, String subject) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(subject)) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(TokenType[] tta, TokenType subject) {
        for (int i = 0; i < tta.length; ++i) {
            if (!tta[i].equals((Object)subject)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setWarningHandler(@Nullable WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    private void warning(String handle2, String message, @Nullable Location optionalLocation) throws CompileException {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle2, message, optionalLocation);
        }
    }

    protected final CompileException compileException(String message) {
        return new CompileException(message, this.scanner.location());
    }

    private static String join(@Nullable String[] sa, String separator) {
        if (sa == null) {
            return "(null)";
        }
        if (sa.length == 0) {
            return "(zero length array)";
        }
        StringBuilder sb = new StringBuilder(sa[0]);
        for (int i = 1; i < sa.length; ++i) {
            sb.append(separator).append(sa[i]);
        }
        return sb.toString();
    }
}

