/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.parsing;

import akka.annotation.InternalApi;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.parsing.HttpMessageParser;
import akka.http.impl.engine.parsing.HttpMessageParser$;
import akka.http.impl.engine.parsing.HttpRequestParser$;
import akka.http.impl.engine.parsing.NotEnoughDataException$;
import akka.http.impl.engine.parsing.ParserOutput;
import akka.http.impl.engine.parsing.ParserOutput$NeedMoreData$;
import akka.http.impl.engine.parsing.ParserOutput$StreamEnd$;
import akka.http.impl.engine.parsing.ParsingException;
import akka.http.impl.engine.parsing.ParsingException$;
import akka.http.impl.engine.parsing.package$;
import akka.http.impl.engine.ws.Handshake$Server$;
import akka.http.impl.model.parser.CharacterClasses$;
import akka.http.impl.util.ByteStringParserInput;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.ErrorInfo$;
import akka.http.scaladsl.model.HttpCharsets$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.IllegalUriException;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.UniversalEntity;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Connection;
import akka.http.scaladsl.model.headers.Content$minusLength;
import akka.http.scaladsl.model.headers.Content$minusType;
import akka.http.scaladsl.model.headers.Raw$minusRequest$minusURI;
import akka.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import akka.http.scaladsl.model.headers.Transfer$minusEncoding;
import akka.http.scaladsl.model.ws.UpgradeToWebSocket;
import akka.http.scaladsl.settings.ParserSettings;
import akka.parboiled2.ParserInput;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.FlowShape;
import akka.stream.FlowShape$;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.TLSProtocol;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.nio.charset.Charset;
import javax.net.ssl.SSLSession;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!B\u0001\u0003\u0005!a!!\u0005%uiB\u0014V-];fgR\u0004\u0016M]:fe*\u00111\u0001B\u0001\ba\u0006\u00148/\u001b8h\u0015\t)a!\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u000f!\tA![7qY*\u0011\u0011BC\u0001\u0005QR$\bOC\u0001\f\u0003\u0011\t7n[1\u0014\u0005\u0001i\u0001c\u0001\b\u0014+5\tqB\u0003\u0002\u0011#\u0005)1\u000f^1hK*\u0011!CC\u0001\u0007gR\u0014X-Y7\n\u0005Qy!AC$sCBD7\u000b^1hKB!acF\r)\u001b\u0005\t\u0012B\u0001\r\u0012\u0005%1En\\<TQ\u0006\u0004X\r\u0005\u0002\u001bK9\u00111d\t\b\u00039\tr!!H\u0011\u000e\u0003yQ!a\b\u0011\u0002\rq\u0012xn\u001c;?\u0007\u0001I\u0011aC\u0005\u0003%)I!\u0001J\t\u0002\u0017Qc5\u000b\u0015:pi>\u001cw\u000e\\\u0005\u0003M\u001d\u0012AbU3tg&|gNQ=uKNT!\u0001J\t\u0011\u0005%jcB\u0001\u0016,\u001b\u0005\u0011\u0011B\u0001\u0017\u0003\u00031\u0001\u0016M]:fe>+H\u000f];u\u0013\tqsFA\u0007SKF,Xm\u001d;PkR\u0004X\u000f\u001e\u0006\u0003Y\tA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAM\u0001\tg\u0016$H/\u001b8hgB\u00111gN\u0007\u0002i)\u0011\u0011'\u000e\u0006\u0003m!\t\u0001b]2bY\u0006$7\u000f\\\u0005\u0003qQ\u0012a\u0002U1sg\u0016\u00148+\u001a;uS:<7\u000f\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0003M\u0011\u0018m\u001e*fcV,7\u000f^+sS\"+\u0017\rZ3s!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u001d\u0011un\u001c7fC:D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\rQ\u0016\fG-\u001a:QCJ\u001cXM\u001d\t\u0003U\u0011K!!\u0012\u0002\u0003!!#H\u000f\u001d%fC\u0012,'\u000fU1sg\u0016\u0014\b\"B$\u0001\t\u0003A\u0015A\u0002\u001fj]&$h\b\u0006\u0003J\u0015.c\u0005C\u0001\u0016\u0001\u0011\u0015\td\t1\u00013\u0011\u0015Qd\t1\u0001<\u0011\u0015\u0011e\t1\u0001D\u0011\u001dq\u0005A1A\u0005\u0002=\u000b!!\u001b8\u0016\u0003A\u00032AF)\u001a\u0013\t\u0011\u0016CA\u0003J]2,G\u000f\u0003\u0004U\u0001\u0001\u0006I\u0001U\u0001\u0004S:\u0004\u0003b\u0002,\u0001\u0005\u0004%\taV\u0001\u0004_V$X#\u0001-\u0011\u0007YI\u0006&\u0003\u0002[#\t1q*\u001e;mKRDa\u0001\u0018\u0001!\u0002\u0013A\u0016\u0001B8vi\u0002BqA\u0018\u0001C\u0002\u0013\u0005q,A\u0003tQ\u0006\u0004X-F\u0001\u0016\u0011\u0019\t\u0007\u0001)A\u0005+\u000511\u000f[1qK\u0002BQa\u0019\u0001\u0005R\u0011\f\u0011#\u001b8ji&\fG.\u0011;ue&\u0014W\u000f^3t+\u0005)\u0007C\u0001\fg\u0013\t9\u0017C\u0001\u0006BiR\u0014\u0018NY;uKNDQ!\u001b\u0001\u0005B)\f1b\u0019:fCR,Gj\\4jGR\u00111N\u001c\t\u0003\u001d1L!!\\\b\u0003\u001f\u001d\u0013\u0018\r\u001d5Ti\u0006<W\rT8hS\u000eDQa\u001c5A\u0002\u0015\f1#\u001b8iKJLG/\u001a3BiR\u0014\u0018NY;uKNDQ!\u001d\u0001\u0005BI\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002gB\u0011A\u000f\u001f\b\u0003kZ\u0004\"!H\u001f\n\u0005]l\u0014A\u0002)sK\u0012,g-\u0003\u0002zu\n11\u000b\u001e:j]\u001eT!a^\u001f)\u0005\u0001a\bcA?\u0002\u00025\taP\u0003\u0002\u0000\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\raPA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public final class HttpRequestParser
extends GraphStage<FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput>> {
    public final ParserSettings akka$http$impl$engine$parsing$HttpRequestParser$$settings;
    public final boolean akka$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader;
    public final HttpHeaderParser akka$http$impl$engine$parsing$HttpRequestParser$$headerParser;
    private final Inlet<TLSProtocol.SessionBytes> in;
    private final Outlet<ParserOutput.RequestOutput> out;
    private final FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput> shape;

    public Inlet<TLSProtocol.SessionBytes> in() {
        return this.in;
    }

    public Outlet<ParserOutput.RequestOutput> out() {
        return this.out;
    }

    public FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput> shape() {
        return this.shape;
    }

    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("HttpRequestParser");
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new HttpMessageParser<ParserOutput.RequestOutput>(this){
            private final ParserSettings settings;
            private final HttpHeaderParser headerParser;
            private HttpMethod method;
            private Uri uri;
            private ByteString uriBytes;
            private final ListBuffer<ParserOutput.RequestOutput> result;
            private Function1<ByteString, HttpMessageParser.StateResult> akka$http$impl$engine$parsing$HttpMessageParser$$state;
            private HttpProtocol akka$http$impl$engine$parsing$HttpMessageParser$$protocol;
            private Function0<Option<ParserOutput.ErrorOutput>> completionHandling;
            private boolean terminated;
            private SSLSession akka$http$impl$engine$parsing$HttpMessageParser$$lastSession;
            private Tls$minusSession$minusInfo akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
            private final /* synthetic */ HttpRequestParser $outer;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            public final ListBuffer<HttpHeader> initialHeaderBuffer() {
                return HttpMessageParser.initialHeaderBuffer$(this);
            }

            public final ParserOutput parseSessionBytes(TLSProtocol.SessionBytes input) {
                return HttpMessageParser.parseSessionBytes$(this, input);
            }

            public final ParserOutput parseBytes(ByteString input) {
                return HttpMessageParser.parseBytes$(this, input);
            }

            public final ParserOutput doPull() {
                return HttpMessageParser.doPull$(this);
            }

            public final boolean shouldComplete() {
                return HttpMessageParser.shouldComplete$(this);
            }

            public final HttpMessageParser.StateResult startNewMessage(ByteString input, int offset) {
                return HttpMessageParser.startNewMessage$(this, input, offset);
            }

            public final int parseProtocol(ByteString input, int cursor) {
                return HttpMessageParser.parseProtocol$(this, input, cursor);
            }

            public final HttpMessageParser.StateResult parseHeaderLines(ByteString input, int lineStart, ListBuffer<HttpHeader> headers2, int headerCount, Option<Connection> ch, Option<Content$minusLength> clh, Option<Content$minusType> cth, Option<Transfer$minusEncoding> teh, boolean e100c, boolean hh) {
                return HttpMessageParser.parseHeaderLines$(this, input, lineStart, headers2, headerCount, ch, clh, cth, teh, e100c, hh);
            }

            public final HttpMessageParser.StateResult parseFixedLengthBody(long remainingBodyBytes, boolean isLastMessage, ByteString input, int bodyStart) {
                return HttpMessageParser.parseFixedLengthBody$(this, remainingBodyBytes, isLastMessage, input, bodyStart);
            }

            public final HttpMessageParser.StateResult parseChunk(ByteString input, int offset, boolean isLastMessage, long totalBytesRead) {
                return HttpMessageParser.parseChunk$(this, input, offset, isLastMessage, totalBytesRead);
            }

            public void emit(ParserOutput output) {
                HttpMessageParser.emit$(this, output);
            }

            public final HttpMessageParser.StateResult continue(ByteString input, int offset, Function2<ByteString, Object, HttpMessageParser.StateResult> next) {
                return HttpMessageParser.continue$(this, input, offset, next);
            }

            public final HttpMessageParser.StateResult continue(Function2<ByteString, Object, HttpMessageParser.StateResult> next) {
                return HttpMessageParser.continue$(this, next);
            }

            public final HttpMessageParser.StateResult failMessageStart(String summary) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, summary);
            }

            public final HttpMessageParser.StateResult failMessageStart(String summary, String detail) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, summary, detail);
            }

            public final HttpMessageParser.StateResult failMessageStart(StatusCode status) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, status);
            }

            public final HttpMessageParser.StateResult failMessageStart(StatusCode status, String summary, String detail) {
                return HttpMessageParser.failMessageStart$(this, status, summary, detail);
            }

            public final HttpMessageParser.StateResult failMessageStart(StatusCode status, ErrorInfo info) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, status, info);
            }

            public final HttpMessageParser.StateResult failEntityStream(String summary) {
                return HttpMessageParser.failEntityStream$((HttpMessageParser)this, summary);
            }

            public final HttpMessageParser.StateResult failEntityStream(String summary, String detail) {
                return HttpMessageParser.failEntityStream$(this, summary, detail);
            }

            public final HttpMessageParser.StateResult failEntityStream(ErrorInfo info) {
                return HttpMessageParser.failEntityStream$((HttpMessageParser)this, info);
            }

            public final HttpMessageParser.StateResult terminate() {
                return HttpMessageParser.terminate$(this);
            }

            public final ContentType contentType(Option<Content$minusType> cth) {
                return HttpMessageParser.contentType$(this, cth);
            }

            public final ParserOutput.StrictEntityCreator<ParserOutput.RequestOutput, UniversalEntity> emptyEntity(Option<Content$minusType> cth) {
                return HttpMessageParser.emptyEntity$(this, cth);
            }

            public final ParserOutput.StrictEntityCreator<ParserOutput.RequestOutput, UniversalEntity> strictEntity(Option<Content$minusType> cth, ByteString input, int bodyStart, int contentLength) {
                return HttpMessageParser.strictEntity$(this, cth, input, bodyStart, contentLength);
            }

            public final <A extends ParserOutput> ParserOutput.StreamedEntityCreator<A, UniversalEntity> defaultEntity(Option<Content$minusType> cth, long contentLength) {
                return HttpMessageParser.defaultEntity$(this, cth, contentLength);
            }

            public final <A extends ParserOutput> ParserOutput.StreamedEntityCreator<A, RequestEntity> chunkedEntity(Option<Content$minusType> cth) {
                return HttpMessageParser.chunkedEntity$(this, cth);
            }

            public final List<HttpHeader> addTransferEncodingWithChunkedPeeled(List<HttpHeader> headers2, Transfer$minusEncoding teh) {
                return HttpMessageParser.addTransferEncodingWithChunkedPeeled$(this, headers2, teh);
            }

            public final void setCompletionHandling(Function0<Option<ParserOutput.ErrorOutput>> completionHandling) {
                HttpMessageParser.setCompletionHandling$(this, completionHandling);
            }

            public final String failMessageStart$default$3() {
                return HttpMessageParser.failMessageStart$default$3$(this);
            }

            public final ListBuffer<HttpHeader> parseHeaderLines$default$3() {
                return HttpMessageParser.parseHeaderLines$default$3$(this);
            }

            public final int parseHeaderLines$default$4() {
                return HttpMessageParser.parseHeaderLines$default$4$(this);
            }

            public final Option<Connection> parseHeaderLines$default$5() {
                return HttpMessageParser.parseHeaderLines$default$5$(this);
            }

            public final Option<Content$minusLength> parseHeaderLines$default$6() {
                return HttpMessageParser.parseHeaderLines$default$6$(this);
            }

            public final Option<Content$minusType> parseHeaderLines$default$7() {
                return HttpMessageParser.parseHeaderLines$default$7$(this);
            }

            public final Option<Transfer$minusEncoding> parseHeaderLines$default$8() {
                return HttpMessageParser.parseHeaderLines$default$8$(this);
            }

            public final boolean parseHeaderLines$default$9() {
                return HttpMessageParser.parseHeaderLines$default$9$(this);
            }

            public final boolean parseHeaderLines$default$10() {
                return HttpMessageParser.parseHeaderLines$default$10$(this);
            }

            public final ListBuffer<ParserOutput.RequestOutput> result() {
                return this.result;
            }

            public Function1<ByteString, HttpMessageParser.StateResult> akka$http$impl$engine$parsing$HttpMessageParser$$state() {
                return this.akka$http$impl$engine$parsing$HttpMessageParser$$state;
            }

            public void akka$http$impl$engine$parsing$HttpMessageParser$$state_$eq(Function1<ByteString, HttpMessageParser.StateResult> x$1) {
                this.akka$http$impl$engine$parsing$HttpMessageParser$$state = x$1;
            }

            public HttpProtocol akka$http$impl$engine$parsing$HttpMessageParser$$protocol() {
                return this.akka$http$impl$engine$parsing$HttpMessageParser$$protocol;
            }

            public void akka$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(HttpProtocol x$1) {
                this.akka$http$impl$engine$parsing$HttpMessageParser$$protocol = x$1;
            }

            public Function0<Option<ParserOutput.ErrorOutput>> completionHandling() {
                return this.completionHandling;
            }

            public void completionHandling_$eq(Function0<Option<ParserOutput.ErrorOutput>> x$1) {
                this.completionHandling = x$1;
            }

            public boolean terminated() {
                return this.terminated;
            }

            public void terminated_$eq(boolean x$1) {
                this.terminated = x$1;
            }

            public SSLSession akka$http$impl$engine$parsing$HttpMessageParser$$lastSession() {
                return this.akka$http$impl$engine$parsing$HttpMessageParser$$lastSession;
            }

            public void akka$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(SSLSession x$1) {
                this.akka$http$impl$engine$parsing$HttpMessageParser$$lastSession = x$1;
            }

            public Tls$minusSession$minusInfo akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader() {
                return this.akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
            }

            public void akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(Tls$minusSession$minusInfo x$1) {
                this.akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader = x$1;
            }

            public final void akka$http$impl$engine$parsing$HttpMessageParser$_setter_$result_$eq(ListBuffer<ParserOutput.RequestOutput> x$1) {
                this.result = x$1;
            }

            public ParserSettings settings() {
                return this.settings;
            }

            public HttpHeaderParser headerParser() {
                return this.headerParser;
            }

            public void onPush() {
                this.handleParserOutput((ParserOutput.RequestOutput)this.parseSessionBytes((TLSProtocol.SessionBytes)this.grab(this.$outer.in())));
            }

            public void onPull() {
                this.handleParserOutput((ParserOutput.RequestOutput)this.doPull());
            }

            public void onUpstreamFinish() {
                block1: {
                    block0: {
                        if (!HttpMessageParser.shouldComplete$(this)) break block0;
                        this.completeStage();
                        break block1;
                    }
                    if (!this.isAvailable(this.$outer.out())) break block1;
                    this.handleParserOutput((ParserOutput.RequestOutput)this.doPull());
                }
            }

            private void handleParserOutput(ParserOutput.RequestOutput output) {
                ParserOutput.RequestOutput requestOutput = output;
                if (ParserOutput$StreamEnd$.MODULE$.equals(requestOutput)) {
                    this.completeStage();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (ParserOutput$NeedMoreData$.MODULE$.equals(requestOutput)) {
                    this.pull(this.$outer.in());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.push(this.$outer.out(), requestOutput);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public HttpMessageParser.StateResult parseMessage(ByteString input, int offset) {
                HttpMessageParser.StateResult stateResult;
                int cursor = this.parseMethod(input, offset);
                cursor = this.parseRequestTarget(input, cursor);
                if (package$.MODULE$.byteChar(input, cursor = this.parseProtocol(input, cursor)) == '\r' && package$.MODULE$.byteChar(input, cursor + 1) == '\n') {
                    stateResult = this.parseHeaderLines(input, cursor + 2, this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5(), this.parseHeaderLines$default$6(), this.parseHeaderLines$default$7(), this.parseHeaderLines$default$8(), this.parseHeaderLines$default$9(), this.parseHeaderLines$default$10());
                } else if (package$.MODULE$.byteChar(input, cursor) == '\n') {
                    stateResult = this.parseHeaderLines(input, cursor + 1, this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5(), this.parseHeaderLines$default$6(), this.parseHeaderLines$default$7(), this.parseHeaderLines$default$8(), this.parseHeaderLines$default$9(), this.parseHeaderLines$default$10());
                } else {
                    throw this.onBadProtocol();
                }
                return stateResult;
            }

            private int parseMethod(ByteString input, int cursor) {
                int n;
                char c = package$.MODULE$.byteChar(input, cursor);
                block0 : switch (c) {
                    case 'G': {
                        n = this.parseMethod$1(HttpMethods$.MODULE$.GET(), $anon$1.parseMethod$default$2$1(), input, cursor);
                        break;
                    }
                    case 'P': {
                        char c2 = package$.MODULE$.byteChar(input, cursor + 1);
                        switch (c2) {
                            case 'O': {
                                n = this.parseMethod$1(HttpMethods$.MODULE$.POST(), 2, input, cursor);
                                break block0;
                            }
                            case 'U': {
                                n = this.parseMethod$1(HttpMethods$.MODULE$.PUT(), 2, input, cursor);
                                break block0;
                            }
                            case 'A': {
                                n = this.parseMethod$1(HttpMethods$.MODULE$.PATCH(), 2, input, cursor);
                                break block0;
                            }
                        }
                        n = this.parseCustomMethod$1($anon$1.parseCustomMethod$default$1$1(), $anon$1.parseCustomMethod$default$2$1(), input, cursor);
                        break;
                    }
                    case 'D': {
                        n = this.parseMethod$1(HttpMethods$.MODULE$.DELETE(), $anon$1.parseMethod$default$2$1(), input, cursor);
                        break;
                    }
                    case 'H': {
                        n = this.parseMethod$1(HttpMethods$.MODULE$.HEAD(), $anon$1.parseMethod$default$2$1(), input, cursor);
                        break;
                    }
                    case 'O': {
                        n = this.parseMethod$1(HttpMethods$.MODULE$.OPTIONS(), $anon$1.parseMethod$default$2$1(), input, cursor);
                        break;
                    }
                    case 'T': {
                        n = this.parseMethod$1(HttpMethods$.MODULE$.TRACE(), $anon$1.parseMethod$default$2$1(), input, cursor);
                        break;
                    }
                    case 'C': {
                        n = this.parseMethod$1(HttpMethods$.MODULE$.CONNECT(), $anon$1.parseMethod$default$2$1(), input, cursor);
                        break;
                    }
                    default: {
                        n = this.parseCustomMethod$1($anon$1.parseCustomMethod$default$1$1(), $anon$1.parseCustomMethod$default$2$1(), input, cursor);
                        break;
                    }
                }
                return n;
            }

            private int parseRequestTarget(ByteString input, int cursor) {
                int uriStart = cursor;
                int uriEndLimit = cursor + this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings.maxUriLength();
                int uriEnd = this.findUriEnd$1($anon$1.findUriEnd$default$1$1(cursor), input, uriEndLimit);
                try {
                    this.uriBytes = input.slice(uriStart, uriEnd);
                    ByteStringParserInput x$3 = new ByteStringParserInput(this.uriBytes);
                    Uri.ParsingMode x$4 = this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings.uriParsingMode();
                    Charset x$5 = Uri$.MODULE$.parseHttpRequestTarget$default$2();
                    this.uri = Uri$.MODULE$.parseHttpRequestTarget((ParserInput)x$3, x$5, x$4);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof IllegalUriException) {
                        IllegalUriException illegalUriException = (IllegalUriException)throwable2;
                        ErrorInfo info = illegalUriException.info();
                        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), info);
                    }
                    throw throwable;
                }
                return uriEnd + 1;
            }

            public Nothing$ onBadProtocol() {
                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.HTTPVersionNotSupported(), ParsingException$.MODULE$.$lessinit$greater$default$2());
            }

            public HttpMessageParser.StateResult parseEntity(List<HttpHeader> headers2, HttpProtocol protocol, ByteString input, int bodyStart, Option<Content$minusLength> clh, Option<Content$minusType> cth, Option<Transfer$minusEncoding> teh, boolean expect100continue, boolean hostHeaderPresent, boolean closeAfterResponseCompletion) {
                HttpMessageParser.StateResult stateResult;
                block20: {
                    block17: {
                        HttpMessageParser.StateResult stateResult2;
                        block18: {
                            None$ none$;
                            block19: {
                                HttpMessageParser.StateResult stateResult3;
                                while (true) {
                                    if (!hostHeaderPresent) {
                                        HttpProtocol httpProtocol = protocol;
                                        HttpProtocol httpProtocol2 = HttpProtocols$.MODULE$.HTTP$div1$u002E0();
                                        if (httpProtocol != null ? !((Object)httpProtocol).equals(httpProtocol2) : httpProtocol2 != null) break block17;
                                    }
                                    boolean bl = false;
                                    Some some = null;
                                    none$ = teh;
                                    if (None$.MODULE$.equals(none$)) {
                                        HttpMessageParser.StateResult stateResult4;
                                        long l;
                                        Some some2;
                                        Content$minusLength content$minusLength;
                                        Option<Content$minusLength> option = clh;
                                        if (option instanceof Some && (content$minusLength = (Content$minusLength)(some2 = (Some)option).value()) != null) {
                                            long len;
                                            l = len = content$minusLength.length();
                                        } else if (None$.MODULE$.equals(option)) {
                                            l = 0L;
                                        } else {
                                            throw new MatchError(option);
                                        }
                                        long contentLength = l;
                                        if (contentLength == 0L) {
                                            this.emitRequestStart$1(this.emptyEntity(cth), $anon$1.emitRequestStart$default$2$1(headers2), protocol, expect100continue, hostHeaderPresent, closeAfterResponseCompletion);
                                            this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
                                            stateResult4 = this.startNewMessage(input, bodyStart);
                                        } else if (!this.method.isEntityAccepted()) {
                                            stateResult4 = this.failMessageStart(StatusCodes$.MODULE$.UnprocessableEntity(), new StringBuilder(33).append(this.method.name()).append(" requests must not have an entity").toString(), this.failMessageStart$default$3());
                                        } else if (contentLength <= (long)(input.size() - bodyStart)) {
                                            int cl = (int)contentLength;
                                            this.emitRequestStart$1(this.strictEntity(cth, input, bodyStart, cl), $anon$1.emitRequestStart$default$2$1(headers2), protocol, expect100continue, hostHeaderPresent, closeAfterResponseCompletion);
                                            this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
                                            stateResult4 = this.startNewMessage(input, bodyStart + cl);
                                        } else {
                                            this.emitRequestStart$1(this.defaultEntity(cth, contentLength), $anon$1.emitRequestStart$default$2$1(headers2), protocol, expect100continue, hostHeaderPresent, closeAfterResponseCompletion);
                                            stateResult4 = this.parseFixedLengthBody(contentLength, closeAfterResponseCompletion, input, bodyStart);
                                        }
                                        stateResult2 = stateResult4;
                                        break block18;
                                    }
                                    if (none$ instanceof Some) {
                                        bl = true;
                                        some = (Some)none$;
                                        if (!this.method.isEntityAccepted()) {
                                            stateResult2 = this.failMessageStart(StatusCodes$.MODULE$.UnprocessableEntity(), new StringBuilder(33).append(this.method.name()).append(" requests must not have an entity").toString(), this.failMessageStart$default$3());
                                            break block18;
                                        }
                                    }
                                    if (!bl) break block19;
                                    Transfer$minusEncoding te = (Transfer$minusEncoding)some.value();
                                    List<HttpHeader> completedHeaders = this.addTransferEncodingWithChunkedPeeled(headers2, te);
                                    if (te.isChunked()) {
                                        if (clh.isEmpty()) {
                                            this.emitRequestStart$1(this.chunkedEntity(cth), completedHeaders, protocol, expect100continue, hostHeaderPresent, closeAfterResponseCompletion);
                                            stateResult3 = this.parseChunk(input, bodyStart, closeAfterResponseCompletion, 0L);
                                            break;
                                        }
                                        stateResult3 = this.failMessageStart("A chunked request must not contain a Content-Length header.");
                                        break;
                                    }
                                    teh = None$.MODULE$;
                                    headers2 = completedHeaders;
                                }
                                stateResult2 = stateResult3;
                                break block18;
                            }
                            throw new MatchError(none$);
                        }
                        stateResult = stateResult2;
                        break block20;
                    }
                    stateResult = this.failMessageStart("Request is missing required `Host` header");
                }
                return stateResult;
            }

            private final int parseCustomMethod$1(int ix, StringBuilder sb, ByteString input$1, int cursor$1) {
                int n;
                block7: {
                    block3: while (ix < this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings.maxMethodLength()) {
                        char c = package$.MODULE$.byteChar(input$1, cursor$1 + ix);
                        switch (c) {
                            case ' ': {
                                Option option = (Option)this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings.customMethods().apply((Object)sb.toString());
                                if (option instanceof Some) {
                                    HttpMethod m;
                                    Some some = (Some)option;
                                    this.method = m = (HttpMethod)some.value();
                                    n = cursor$1 + ix + 1;
                                    break;
                                }
                                if (None$.MODULE$.equals(option)) {
                                    throw new ParsingException((StatusCode)StatusCodes$.MODULE$.NotImplemented(), ErrorInfo$.MODULE$.apply("Unsupported HTTP method", sb.toString()));
                                }
                                throw new MatchError((Object)option);
                            }
                            default: {
                                sb = sb.append(c);
                                ++ix;
                                continue block3;
                            }
                        }
                        break block7;
                    }
                    if (sb.length() > 0 && sb.charAt(0) == '\u0016') {
                        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), ErrorInfo$.MODULE$.apply("Unsupported HTTP method", new StringBuilder(128).append("The HTTP method started with 0x16 rather than any known HTTP method. ").append("Perhaps this was an HTTPS request sent to an HTTP endpoint?").toString()));
                    }
                    throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), ErrorInfo$.MODULE$.apply("Unsupported HTTP method", new StringBuilder(139).append("HTTP method too long (started with '").append(sb.toString()).append("'). ").append("Increase `akka.http.server.parsing.max-method-length` to support HTTP methods with more characters.").toString()));
                }
                return n;
            }

            private static final int parseCustomMethod$default$1$1() {
                return 0;
            }

            private static final StringBuilder parseCustomMethod$default$2$1() {
                return new StringBuilder(16);
            }

            private final int parseMethod$1(HttpMethod meth, int ix, ByteString input$1, int cursor$1) {
                int n;
                block4: {
                    while (true) {
                        if (ix == meth.value().length()) {
                            if (package$.MODULE$.byteChar(input$1, cursor$1 + ix) == ' ') {
                                this.method = meth;
                                n = cursor$1 + ix + 1;
                            } else {
                                n = this.parseCustomMethod$1($anon$1.parseCustomMethod$default$1$1(), $anon$1.parseCustomMethod$default$2$1(), input$1, cursor$1);
                            }
                            break block4;
                        }
                        if (package$.MODULE$.byteChar(input$1, cursor$1 + ix) != meth.value().charAt(ix)) break;
                        ++ix;
                    }
                    n = this.parseCustomMethod$1($anon$1.parseCustomMethod$default$1$1(), $anon$1.parseCustomMethod$default$2$1(), input$1, cursor$1);
                }
                return n;
            }

            private static final int parseMethod$default$2$1() {
                return 1;
            }

            private final int findUriEnd$1(int ix, ByteString input$2, int uriEndLimit$1) {
                block2: {
                    while (true) {
                        if (ix == input$2.length()) {
                            throw NotEnoughDataException$.MODULE$;
                        }
                        if (BoxesRunTime.unboxToBoolean((Object)CharacterClasses$.MODULE$.WSPCRLF().apply((Object)BoxesRunTime.boxToCharacter((char)((char)input$2.apply(ix)))))) break block2;
                        if (ix >= uriEndLimit$1) break;
                        ++ix;
                    }
                    throw new ParsingException((StatusCode)StatusCodes$.MODULE$.RequestUriTooLong(), new StringBuilder(54).append("URI length exceeds the configured limit of ").append(this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings.maxUriLength()).append(" characters").toString());
                }
                return ix;
            }

            private static final int findUriEnd$default$1$1(int cursor$2) {
                return cursor$2;
            }

            private final void emitRequestStart$1(ParserOutput.EntityCreator createEntity, List headers2, HttpProtocol protocol$1, boolean expect100continue$1, boolean hostHeaderPresent$1, boolean closeAfterResponseCompletion$1) {
                List list;
                List list2;
                if (this.$outer.akka$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader) {
                    Raw$minusRequest$minusURI raw$minusRequest$minusURI = new Raw$minusRequest$minusURI(this.uriBytes.decodeString(HttpCharsets$.MODULE$.US$minusASCII().nioCharset()));
                    list2 = headers2.$colon$colon((Object)raw$minusRequest$minusURI);
                } else {
                    list2 = headers2;
                }
                List allHeaders0 = list2;
                HttpMethod httpMethod = this.method;
                HttpMethod httpMethod2 = HttpMethods$.MODULE$.GET();
                if (!(httpMethod != null ? !((Object)httpMethod).equals(httpMethod2) : httpMethod2 != null)) {
                    List list3;
                    UpgradeToWebSocket upgradeToWebSocket = Handshake$Server$.MODULE$.websocketUpgrade((List<HttpHeader>)headers2, hostHeaderPresent$1);
                    UpgradeToWebSocket upgradeToWebSocket2 = (UpgradeToWebSocket)OptionVal.Some$.MODULE$.unapply((Object)upgradeToWebSocket);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)upgradeToWebSocket2)) {
                        UpgradeToWebSocket upgrade;
                        UpgradeToWebSocket upgradeToWebSocket3 = upgrade = (UpgradeToWebSocket)OptionVal$.MODULE$.get$extension((Object)upgradeToWebSocket2);
                        list3 = allHeaders0.$colon$colon((Object)upgradeToWebSocket3);
                    } else {
                        OptionVal$.MODULE$.None();
                        UpgradeToWebSocket upgradeToWebSocket4 = upgradeToWebSocket;
                        if (!(null != null ? !((Object)null).equals(upgradeToWebSocket4) : upgradeToWebSocket4 != null)) {
                            list3 = allHeaders0;
                        } else {
                            throw new MatchError((Object)new OptionVal((Object)upgradeToWebSocket));
                        }
                    }
                    list = list3;
                } else {
                    list = allHeaders0;
                }
                List allHeaders = list;
                this.emit(new ParserOutput.RequestStart(this.method, this.uri, protocol$1, (List<HttpHeader>)allHeaders, createEntity, expect100continue$1, closeAfterResponseCompletion$1));
            }

            private static final List emitRequestStart$default$2$1(List headers$1) {
                return headers$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                HttpMessageParser.$init$(this);
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                this.settings = $outer.akka$http$impl$engine$parsing$HttpRequestParser$$settings;
                this.headerParser = $outer.akka$http$impl$engine$parsing$HttpRequestParser$$headerParser.createShallowCopy();
                this.setHandlers($outer.in(), $outer.out(), this);
            }
        };
    }

    public String toString() {
        return "HttpRequestParser";
    }

    public HttpRequestParser(ParserSettings settings, boolean rawRequestUriHeader, HttpHeaderParser headerParser) {
        this.akka$http$impl$engine$parsing$HttpRequestParser$$settings = settings;
        this.akka$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader = rawRequestUriHeader;
        this.akka$http$impl$engine$parsing$HttpRequestParser$$headerParser = headerParser;
        this.in = Inlet$.MODULE$.apply("HttpRequestParser.in");
        this.out = Outlet$.MODULE$.apply("HttpRequestParser.out");
        this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
    }
}

