/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis.services;

import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.components.ResponseFetcher;
import com.xebialabs.agatha.crawlers.shared.services.BaseCrawlService;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.agatha.crawlers.travis.TravisCrawler;
import com.xebialabs.agatha.crawlers.travis.components.TravisResponseFetcher;
import com.xebialabs.agatha.crawlers.travis.messages.TravisJobMessage;
import com.xebialabs.agatha.crawlers.travis.models.BaseBuild;
import com.xebialabs.agatha.crawlers.travis.models.dtos.CollectionResponse;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import com.xebialabs.impact.api.KnownArtefactRequestDescriptionVM;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TravisBaseCrawl<T extends TravisJobMessage, R>
extends BaseCrawlService<TravisCrawler, T, R> {
    private static final Logger logger = LoggerFactory.getLogger(TravisBaseCrawl.class);
    protected String nextURL = null;

    public TravisBaseCrawl(TravisCrawler crawler, T message, BaseCrawlerMessage dataMessage, ResponseFetcher<TravisCrawler> responseFetcher) {
        super((AbstractHttpCrawler)crawler, message, dataMessage, responseFetcher);
    }

    protected CrawledDataWrappedResponse<R> processMessage() throws CrawlerWorkException {
        CollectionResponse collectionResponse;
        CrawledDataWrappedResponse<R> response = this.processTravisMessage();
        if (this instanceof Paginated && response.getEntity() instanceof CollectionResponse && (collectionResponse = (CollectionResponse)((Object)response.getEntity())).hasNext()) {
            this.nextURL = collectionResponse.getPagination().getNext().getHref();
        }
        return response;
    }

    <B extends BaseBuild> List<B> filterBuilds(List<B> builds) {
        List filteredBuilds = builds.stream().filter(b -> b.isNotBuilding()).collect(Collectors.toList());
        if (((TravisJobMessage)this.message).getMetadata().isIncremental()) {
            filteredBuilds = this.filterOnlyUnknownBuilds(filteredBuilds);
        }
        return filteredBuilds;
    }

    private <B extends BaseBuild> List<B> filterOnlyUnknownBuilds(List<B> builds) {
        logger.debug("[Incremental Mode] Asking dedupe data for the following build IDs for filtering: {}", builds.stream().map(b -> b.getId()).collect(Collectors.toList()));
        Set knownBuilds = ((TravisCrawler)this.crawler).getKnownArtefacts(builds.stream().map(r -> new KnownArtefactRequestDescriptionVM().setArtefactId(r.getId() + "").setVersion(r.getUpdatedAt())).collect(Collectors.toList()), ((TravisJobMessage)this.message).getDataSourceDetails().getDataSourceId(), DataSourceTypeEnum.BUILD).entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        logger.info("[Incremental Mode] Found {} known artifacts out of {} builds", (Object)knownBuilds.size(), (Object)builds.size());
        return builds.stream().filter(r -> !knownBuilds.contains(r.getId() + "")).collect(Collectors.toList());
    }

    protected abstract CrawledDataWrappedResponse<R> processTravisMessage() throws CrawlerWorkException;

    protected TravisResponseFetcher getResponseFetcher() {
        return (TravisResponseFetcher)this.responseFetcher;
    }
}

