/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.coding;

import akka.annotation.InternalApi;
import akka.http.scaladsl.coding.DeflateCompressor;
import akka.http.scaladsl.coding.GzipDecompressor$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import scala.Predef$;
import scala.math.Numeric$IntIsIntegral$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001I4Q!\u0001\u0002\u0001\u0005)\u0011ab\u0012>ja\u000e{W\u000e\u001d:fgN|'O\u0003\u0002\u0004\t\u000511m\u001c3j]\u001eT!!\u0002\u0004\u0002\u0011M\u001c\u0017\r\\1eg2T!a\u0002\u0005\u0002\t!$H\u000f\u001d\u0006\u0002\u0013\u0005!\u0011m[6b'\t\u00011\u0002\u0005\u0002\r\u001b5\t!!\u0003\u0002\u000f\u0005\t\tB)\u001a4mCR,7i\\7qe\u0016\u001c8o\u001c:\t\u000bA\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?\u0007\u0001!\u0012a\u0005\t\u0003\u0019\u0001A\u0001\"\u0006\u0001\t\u0006\u0004%\tFF\u0001\tI\u00164G.\u0019;feV\tq\u0003\u0005\u0002\u0019?5\t\u0011D\u0003\u0002\u001b7\u0005\u0019!0\u001b9\u000b\u0005qi\u0012\u0001B;uS2T\u0011AH\u0001\u0005U\u00064\u0018-\u0003\u0002!3\tAA)\u001a4mCR,'\u000fC\u0004#\u0001\t\u0007I\u0011B\u0012\u0002\u0011\rDWmY6Tk6,\u0012\u0001\n\t\u00031\u0015J!AJ\r\u0003\u000b\r\u00136i\r\u001a\t\r!\u0002\u0001\u0015!\u0003%\u0003%\u0019\u0007.Z2l'Vl\u0007\u0005C\u0004+\u0001\u0001\u0007I\u0011B\u0016\u0002\u0015!,\u0017\rZ3s'\u0016tG/F\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u001d\u0011un\u001c7fC:Dqa\r\u0001A\u0002\u0013%A'\u0001\biK\u0006$WM]*f]R|F%Z9\u0015\u0005UB\u0004CA\u00177\u0013\t9dF\u0001\u0003V]&$\bbB\u001d3\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\n\u0004BB\u001e\u0001A\u0003&A&A\u0006iK\u0006$WM]*f]R\u0004\u0003bB\u001f\u0001\u0001\u0004%IAP\u0001\nEf$Xm\u001d*fC\u0012,\u0012a\u0010\t\u0003[\u0001K!!\u0011\u0018\u0003\t1{gn\u001a\u0005\b\u0007\u0002\u0001\r\u0011\"\u0003E\u00035\u0011\u0017\u0010^3t%\u0016\fGm\u0018\u0013fcR\u0011Q'\u0012\u0005\bs\t\u000b\t\u00111\u0001@\u0011\u00199\u0005\u0001)Q\u0005\u007f\u0005Q!-\u001f;fgJ+\u0017\r\u001a\u0011\t\u000b%\u0003A\u0011\u000b&\u0002%\r|W\u000e\u001d:fgN<\u0016\u000e\u001e5Ck\u001a4WM\u001d\u000b\u0004\u0017B\u0013\u0006C\u0001'O\u001b\u0005i%B\u0001\u000f\t\u0013\tyUJ\u0001\u0006CsR,7\u000b\u001e:j]\u001eDQ!\u0015%A\u0002-\u000bQ!\u001b8qkRDQa\u0015%A\u0002Q\u000baAY;gM\u0016\u0014\bcA\u0017V/&\u0011aK\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003[aK!!\u0017\u0018\u0003\t\tKH/\u001a\u0005\u00067\u0002!\t\u0006X\u0001\u0010M2,8\u000f[,ji\"\u0014UO\u001a4feR\u00111*\u0018\u0005\u0006'j\u0003\r\u0001\u0016\u0005\u0006?\u0002!\t\u0006Y\u0001\u0011M&t\u0017n\u001d5XSRD')\u001e4gKJ$\"aS1\t\u000bMs\u0006\u0019\u0001+\t\u000b\r\u0004A\u0011\u00023\u0002\u0013U\u0004H-\u0019;f\u0007J\u001cGCA\u001bf\u0011\u0015\t&\r1\u0001L\u0011\u00159\u0007\u0001\"\u0003i\u0003\u0019AW-\u00193feR\t1\nC\u0003k\u0001\u0011%\u0001.A\u0004ue\u0006LG.\u001a:)\u0005\u0001a\u0007CA7q\u001b\u0005q'BA8\t\u0003)\tgN\\8uCRLwN\\\u0005\u0003c:\u00141\"\u00138uKJt\u0017\r\\!qS\u0002")
@InternalApi
public class GzipCompressor
extends DeflateCompressor {
    private Deflater deflater;
    private final CRC32 checkSum = new CRC32();
    private boolean headerSent = false;
    private long bytesRead = 0L;
    private volatile boolean bitmap$0;

    private Deflater deflater$lzycompute() {
        GzipCompressor gzipCompressor = this;
        synchronized (gzipCompressor) {
            if (!this.bitmap$0) {
                this.deflater = new Deflater(9, true);
                this.bitmap$0 = true;
            }
        }
        return this.deflater;
    }

    @Override
    public Deflater deflater() {
        return !this.bitmap$0 ? this.deflater$lzycompute() : this.deflater;
    }

    private CRC32 checkSum() {
        return this.checkSum;
    }

    private boolean headerSent() {
        return this.headerSent;
    }

    private void headerSent_$eq(boolean x$1) {
        this.headerSent = x$1;
    }

    private long bytesRead() {
        return this.bytesRead;
    }

    private void bytesRead_$eq(long x$1) {
        this.bytesRead = x$1;
    }

    @Override
    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        this.updateCrc(input);
        return this.header().$plus$plus(super.compressWithBuffer(input, buffer));
    }

    @Override
    public ByteString flushWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.flushWithBuffer(buffer));
    }

    @Override
    public ByteString finishWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.finishWithBuffer(buffer)).$plus$plus(this.trailer());
    }

    private void updateCrc(ByteString input) {
        this.checkSum().update((byte[])input.toArray(ClassTag$.MODULE$.Byte()));
        this.bytesRead_$eq(this.bytesRead() + (long)input.length());
    }

    private ByteString header() {
        ByteString byteString;
        if (!this.headerSent()) {
            this.headerSent_$eq(true);
            byteString = GzipDecompressor$.MODULE$.Header();
        } else {
            byteString = ByteString$.MODULE$.empty();
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    private ByteString trailer() {
        void var3_3;
        int crc = (int)this.checkSum().getValue();
        int tot = (int)this.bytesRead();
        ByteString trailer = GzipCompressor.int32$1(crc).$plus$plus(GzipCompressor.int32$1(tot));
        return var3_3;
    }

    private static final ByteString int32$1(int i) {
        return ByteString$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{i, i >> 8, i >> 16, i >> 24}), Numeric$IntIsIntegral$.MODULE$);
    }
}

