/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.stream.impl.io.OutputStreamSourceStage;
import akka.stream.impl.io.OutputStreamSourceStage$Canceled$;
import akka.stream.impl.io.OutputStreamSourceStage$Close$;
import akka.stream.impl.io.OutputStreamSourceStage$Flush$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\re!B\u0001\u0003\u0001!Q!aE(viB,Ho\u0015;sK\u0006l\u0017\tZ1qi\u0016\u0014(BA\u0002\u0005\u0003\tIwN\u0003\u0002\u0006\r\u0005!\u0011.\u001c9m\u0015\t9\u0001\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002\u0013\u0005!\u0011m[6b'\t\u00011\u0002\u0005\u0002\r!5\tQB\u0003\u0002\u0004\u001d)\tq\"\u0001\u0003kCZ\f\u0017BA\t\u000e\u00051yU\u000f\u001e9viN#(/Z1n\u0011!\u0019\u0002A!A!\u0002\u0013)\u0012!\u00033bi\u0006\fV/Z;f\u0007\u0001\u00012AF\u000e\u001e\u001b\u00059\"B\u0001\r\u001a\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u000359\tA!\u001e;jY&\u0011Ad\u0006\u0002\u000e\u00052|7m[5oOF+X-^3\u0011\u0005y\u0001S\"A\u0010\u000b\u0005iA\u0011BA\u0011 \u0005)\u0011\u0015\u0010^3TiJLgn\u001a\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005\u0001Bm\\<ogR\u0014X-Y7Ti\u0006$Xo\u001d\t\u0004K!RS\"\u0001\u0014\u000b\u0005\u001d:\u0012AB1u_6L7-\u0003\u0002*M\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002,s9\u0011Af\u000e\b\u0003[Yr!AL\u001b\u000f\u0005=\"dB\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0015\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!\u0001\u000f\u0002\u0002/=+H\u000f];u'R\u0014X-Y7T_V\u00148-Z*uC\u001e,\u0017B\u0001\u001e<\u0005A!un\u001e8tiJ,\u0017-\\*uCR,8O\u0003\u00029\u0005!AQ\b\u0001B\u0001B\u0003%a(A\u0006tK:$Gk\\*uC\u001e,\u0007\u0003B C\t\u001ek\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\n\rVt7\r^5p]F\u0002\"aK#\n\u0005\u0019[$!F!eCB$XM\u001d+p'R\fw-Z'fgN\fw-\u001a\t\u0004\u0011*cU\"A%\u000b\u0005a\u0001\u0015BA&J\u0005\u00191U\u000f^;sKB\u0011q(T\u0005\u0003\u001d\u0002\u0013A!\u00168ji\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011+\u0001\u0007xe&$X\rV5nK>,H\u000f\u0005\u0002S+6\t1K\u0003\u0002U\u0013\u0006AA-\u001e:bi&|g.\u0003\u0002W'\nqa)\u001b8ji\u0016$UO]1uS>t\u0007\"\u0002-\u0001\t\u0003I\u0016A\u0002\u001fj]&$h\bF\u0003[9vsv\f\u0005\u0002\\\u00015\t!\u0001C\u0003\u0014/\u0002\u0007Q\u0003C\u0003$/\u0002\u0007A\u0005C\u0003>/\u0002\u0007a\bC\u0003Q/\u0002\u0007\u0011\u000bC\u0004b\u0001\u0001\u0007I\u0011\u00012\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\u0012a\u0019\t\u0003\u007f\u0011L!!\u001a!\u0003\u000f\t{w\u000e\\3b]\"9q\r\u0001a\u0001\n\u0003A\u0017\u0001D5t\u0003\u000e$\u0018N^3`I\u0015\fHC\u0001'j\u0011\u001dQg-!AA\u0002\r\f1\u0001\u001f\u00132\u0011\u0019a\u0007\u0001)Q\u0005G\u0006I\u0011n]!di&4X\r\t\u0005\b]\u0002\u0001\r\u0011\"\u0001c\u0003AI7\u000fU;cY&\u001c\b.\u001a:BY&4X\rC\u0004q\u0001\u0001\u0007I\u0011A9\u0002)%\u001c\b+\u001e2mSNDWM]!mSZ,w\fJ3r)\ta%\u000fC\u0004k_\u0006\u0005\t\u0019A2\t\rQ\u0004\u0001\u0015)\u0003d\u0003EI7\u000fU;cY&\u001c\b.\u001a:BY&4X\r\t\u0005\u0006m\u0002!\ta^\u0001\u0019aV\u0014G.[:iKJ\u001cEn\\:fI\u0016C8-\u001a9uS>tW#\u0001=\u0011\u00051I\u0018B\u0001>\u000e\u0005-Iu*\u0012=dKB$\u0018n\u001c8\t\rq\u0004\u0001\u0015\"\u0003~\u0003\u0011\u0019XM\u001c3\u0015\u00051s\bBB@|\u0001\u0004\t\t!\u0001\u0006tK:$\u0017i\u0019;j_:\u0004BaPA\u0002\u0019&\u0019\u0011Q\u0001!\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004&B>\u0002\n\u0005=\u0001\u0003B \u0002\faL1!!\u0004A\u0005\u0019!\bN]8xg\u000e\n\u0001\u0010\u0003\u0005\u0002\u0014\u0001\u0001K\u0011BA\u000b\u0003!\u0019XM\u001c3ECR\fGc\u0001'\u0002\u0018!9\u0011\u0011DA\t\u0001\u0004i\u0012\u0001\u00023bi\u0006Dc!!\u0005\u0002\n\u0005=\u0001\u0002CA\u0010\u0001\u0001&I!!\t\u0002\u0017M,g\u000eZ'fgN\fw-\u001a\u000b\u0006\u0019\u0006\r\u0012q\u0005\u0005\b\u0003K\ti\u00021\u0001E\u0003\u001diWm]:bO\u0016D\u0011\"!\u000b\u0002\u001eA\u0005\t\u0019A2\u0002\u001f!\fg\u000e\u001a7f\u0007\u0006t7-\u001a7mK\u0012Dc!!\b\u0002\n\u0005=\u0001bBA\u0018\u0001\u0011\u0005\u0013\u0011G\u0001\u0006oJLG/\u001a\u000b\u0004\u0019\u0006M\u0002\u0002CA\u001b\u0003[\u0001\r!a\u000e\u0002\u0003\t\u00042aPA\u001d\u0013\r\tY\u0004\u0011\u0002\u0004\u0013:$\bFBA\u0017\u0003\u0013\ty\u0001C\u0004\u00020\u0001!\t%!\u0011\u0015\u000f1\u000b\u0019%!\u0015\u0002V!A\u0011QGA \u0001\u0004\t)\u0005E\u0003@\u0003\u000f\nY%C\u0002\u0002J\u0001\u0013Q!\u0011:sCf\u00042aPA'\u0013\r\ty\u0005\u0011\u0002\u0005\u0005f$X\r\u0003\u0005\u0002T\u0005}\u0002\u0019AA\u001c\u0003\rygM\u001a\u0005\t\u0003/\ny\u00041\u0001\u00028\u0005\u0019A.\u001a8)\r\u0005}\u0012\u0011BA\b\u0011\u001d\ti\u0006\u0001C!\u0003?\nQA\u001a7vg\"$\u0012\u0001\u0014\u0015\u0007\u00037\nI!a\u0004\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002`\u0005)1\r\\8tK\"2\u00111MA\u0005\u0003\u001fA\u0011\"a\u001b\u0001#\u0003%I!!\u001c\u0002+M,g\u000eZ'fgN\fw-\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u000e\u0016\u0004G\u0006E4FAA:!\u0011\t)(a \u000e\u0005\u0005]$\u0002BA=\u0003w\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u\u0004)\u0001\u0006b]:|G/\u0019;j_:LA!!!\u0002x\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class OutputStreamAdapter
extends OutputStream {
    private final BlockingQueue<ByteString> dataQueue;
    private final AtomicReference<OutputStreamSourceStage.DownstreamStatus> downstreamStatus;
    private final Function1<OutputStreamSourceStage.AdapterToStageMessage, Future<BoxedUnit>> sendToStage;
    private final FiniteDuration writeTimeout;
    private boolean isActive;
    private boolean isPublisherAlive;

    public boolean isActive() {
        return this.isActive;
    }

    public void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    public boolean isPublisherAlive() {
        return this.isPublisherAlive;
    }

    public void isPublisherAlive_$eq(boolean x$1) {
        this.isPublisherAlive = x$1;
    }

    public IOException publisherClosedException() {
        return new IOException("Reactive stream is terminated, no writes are possible");
    }

    private void send(Function0<BoxedUnit> sendAction) throws IOException {
        if (this.isActive()) {
            if (!this.isPublisherAlive()) {
                throw this.publisherClosedException();
            }
        } else {
            throw new IOException("OutputStream is closed");
        }
        sendAction.apply$mcV$sp();
    }

    private void sendData(ByteString data) throws IOException {
        this.send((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                $this.dataQueue.put(data);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    throw new IOException(ex);
                }
                throw throwable;
            }
            OutputStreamSourceStage.DownstreamStatus downstreamStatus = $this.downstreamStatus.get();
            OutputStreamSourceStage$Canceled$ outputStreamSourceStage$Canceled$ = OutputStreamSourceStage$Canceled$.MODULE$;
            if (!(downstreamStatus != null ? !downstreamStatus.equals(outputStreamSourceStage$Canceled$) : outputStreamSourceStage$Canceled$ != null)) {
                this.isPublisherAlive_$eq(false);
                throw this.publisherClosedException();
            }
        });
    }

    private void sendMessage(OutputStreamSourceStage.AdapterToStageMessage message, boolean handleCancelled) throws IOException {
        this.send((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Await$.MODULE$.ready((Awaitable)$this.sendToStage.apply((Object)message), (Duration)$this.writeTimeout);
                OutputStreamSourceStage.DownstreamStatus downstreamStatus = $this.downstreamStatus.get();
                OutputStreamSourceStage$Canceled$ outputStreamSourceStage$Canceled$ = OutputStreamSourceStage$Canceled$.MODULE$;
                if (!(downstreamStatus != null ? !downstreamStatus.equals(outputStreamSourceStage$Canceled$) : outputStreamSourceStage$Canceled$ != null) && handleCancelled) {
                    this.isPublisherAlive_$eq(false);
                    throw this.publisherClosedException();
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException) {
                    IOException iOException = (IOException)throwable2;
                    throw iOException;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new IOException(e);
                }
                throw throwable;
            }
        });
    }

    private boolean sendMessage$default$2() {
        return true;
    }

    @Override
    public void write(int b) throws IOException {
        this.sendData(ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{b}), (Integral)Numeric.IntIsIntegral$.MODULE$));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.sendData(ByteString$.MODULE$.fromArray(b, off, len));
    }

    @Override
    public void flush() throws IOException {
        this.sendMessage(OutputStreamSourceStage$Flush$.MODULE$, this.sendMessage$default$2());
    }

    @Override
    public void close() throws IOException {
        this.sendMessage(OutputStreamSourceStage$Close$.MODULE$, false);
        this.isActive_$eq(false);
    }

    public OutputStreamAdapter(BlockingQueue<ByteString> dataQueue, AtomicReference<OutputStreamSourceStage.DownstreamStatus> downstreamStatus, Function1<OutputStreamSourceStage.AdapterToStageMessage, Future<BoxedUnit>> sendToStage, FiniteDuration writeTimeout) {
        this.dataQueue = dataQueue;
        this.downstreamStatus = downstreamStatus;
        this.sendToStage = sendToStage;
        this.writeTimeout = writeTimeout;
        this.isActive = true;
        this.isPublisherAlive = true;
    }
}

