/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis.transform.converters;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.travis.TravisUtil;
import com.xebialabs.agatha.crawlers.travis.models.Job;
import com.xebialabs.agatha.crawlers.travis.transform.converters.BaseBuildConverter;
import com.xebialabs.agatha.crawlers.travis.transform.models.BuildUM;
import java.util.HashMap;

public class JobConverter
extends BaseBuildConverter<Job> {
    public JobConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        super(pluginId, pluginVersion, type, typeVersion, "jobs");
    }

    @Override
    protected void populateOther(BuildUM build, Job entity) throws CrawlerWorkException {
        BuildUM.Other other = new BuildUM.Other();
        build.setOther(other);
        this.populateRaw(build, entity);
        this.populateRelations(build, entity);
        this.populateStartMs(build, entity);
    }

    private void populateStartMs(BuildUM build, Job entity) throws CrawlerWorkException {
        if (null == build.getStartMs()) {
            build.setStartMs(TravisUtil.dateAsLong(entity.getBuild().getStartTime()));
        }
    }

    private void populateRelations(BuildUM build, Job entity) {
        BuildUM.Other other = build.getOther();
        HashMap<String, String> relations = new HashMap<String, String>();
        relations.put("jobId", entity.getBuild().getId() + "");
        relations.put("buildId", entity.getId() + "");
        other.setRelations(relations);
    }

    private void populateRaw(BuildUM build, Job entity) {
        BuildUM.Other other = build.getOther();
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("consoleOutput", entity.getLog().getContent());
        raw.put("buildData", entity);
        other.setRaw(raw);
    }
}

