/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.NoSerializationVerificationNeeded;
import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.JavaSerializer;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.SerializationSetup;
import akka.serialization.Serializer;
import akka.serialization.SerializerDetails;
import akka.serialization.SerializerDetails$;
import akka.serialization.SerializerWithStringManifest;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0011Us!B\u0001\u0003\u0011\u00039\u0011!D*fe&\fG.\u001b>bi&|gN\u0003\u0002\u0004\t\u0005i1/\u001a:jC2L'0\u0019;j_:T\u0011!B\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001bM+'/[1mSj\fG/[8o'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d)AAF\u0005\u0001/\ty1\t\\1tgN+'/[1mSj,'\u000f\u0005\u0003\u000e1i\t\u0014BA\r\u000f\u0005\u0019!V\u000f\u001d7feA\u00121\u0004\u000b\t\u00049\r2cBA\u000f\"!\tqb\"D\u0001 \u0015\t\u0001c!\u0001\u0004=e>|GOP\u0005\u0003E9\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0013&\u0005\u0015\u0019E.Y:t\u0015\t\u0011c\u0002\u0005\u0002(Q1\u0001A!C\u0015\u0016\u0003\u0003\u0005\tQ!\u0001+\u0005\ryF%M\t\u0003W9\u0002\"!\u0004\u0017\n\u00055r!a\u0002(pi\"Lgn\u001a\t\u0003\u001b=J!\u0001\r\b\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\te%\u00111G\u0001\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002C\u001b\n\u0005\u0004%\t\u0001\u0002\u001c\u00027\r,(O]3oiR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8o+\u00059\u0004c\u0001\u001d<{5\t\u0011H\u0003\u0002;\u001d\u0005!Q\u000f^5m\u0013\ta\u0014HA\bEs:\fW.[2WCJL\u0017M\u00197f!\tqt(D\u0001\n\r\u0015\u0001\u0015B\u0011\u0003B\u0005-IeNZ8s[\u0006$\u0018n\u001c8\u0014\t}b!)\u0012\t\u0003\u001b\rK!\u0001\u0012\b\u0003\u000fA\u0013x\u000eZ;diB\u0011QBR\u0005\u0003\u000f:\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"S \u0003\u0016\u0004%\tAS\u0001\bC\u0012$'/Z:t+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(\u0005\u0003\u0015\t7\r^8s\u0013\t\u0001VJA\u0004BI\u0012\u0014Xm]:\t\u0011I{$\u0011#Q\u0001\n-\u000b\u0001\"\u00193ee\u0016\u001c8\u000f\t\u0005\t)~\u0012)\u001a!C\u0001+\u000611/_:uK6,\u0012A\u0016\t\u0003\u0019^K!\u0001W'\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\t5~\u0012\t\u0012)A\u0005-\u000691/_:uK6\u0004\u0003\"B\n@\t\u0003aFcA\u001f^=\")\u0011j\u0017a\u0001\u0017\")Ak\u0017a\u0001-\"9\u0001mPA\u0001\n\u0003\t\u0017\u0001B2paf$2!\u00102d\u0011\u001dIu\f%AA\u0002-Cq\u0001V0\u0011\u0002\u0003\u0007a\u000bC\u0004f\u007fE\u0005I\u0011\u00014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tqM\u000b\u0002LQ.\n\u0011\u000e\u0005\u0002k_6\t1N\u0003\u0002m[\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003]:\t!\"\u00198o_R\fG/[8o\u0013\t\u00018NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DqA] \u0012\u0002\u0013\u00051/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003QT#A\u00165\t\u000fY|\u0014\u0011!C!o\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012\u0001\u001f\t\u0003szl\u0011A\u001f\u0006\u0003wr\fA\u0001\\1oO*\tQ0\u0001\u0003kCZ\f\u0017BA@{\u0005\u0019\u0019FO]5oO\"I\u00111A \u0002\u0002\u0013\u0005\u0011QA\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000f\u00012!DA\u0005\u0013\r\tYA\u0004\u0002\u0004\u0013:$\b\"CA\b\u007f\u0005\u0005I\u0011AA\t\u00039\u0001(o\u001c3vGR,E.Z7f]R$2ALA\n\u0011)\t)\"!\u0004\u0002\u0002\u0003\u0007\u0011qA\u0001\u0004q\u0012\n\u0004\"CA\r\u007f\u0005\u0005I\u0011IA\u000e\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u000f!\u0015\ty\"!\n/\u001b\t\t\tCC\u0002\u0002$9\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9#!\t\u0003\u0011%#XM]1u_JD\u0011\"a\u000b@\u0003\u0003%\t!!\f\u0002\u0011\r\fg.R9vC2$B!a\f\u00026A\u0019Q\"!\r\n\u0007\u0005MbBA\u0004C_>dW-\u00198\t\u0013\u0005U\u0011\u0011FA\u0001\u0002\u0004q\u0003\"CA\u001d\u007f\u0005\u0005I\u0011IA\u001e\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0004\u0011%\tydPA\u0001\n\u0003\n\t%\u0001\u0005u_N#(/\u001b8h)\u0005A\b\"CA#\u007f\u0005\u0005I\u0011IA$\u0003\u0019)\u0017/^1mgR!\u0011qFA%\u0011%\t)\"a\u0011\u0002\u0002\u0003\u0007a\u0006C\u0004\u0002N%\u0001\u000b\u0011B\u001c\u00029\r,(O]3oiR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8oA\u00191\u0011\u0011K\u0005\u0001\u0003'\u0012\u0001bU3ui&twm]\n\u0004\u0003\u001fb\u0001bCA,\u0003\u001f\u0012)\u0019!C\u0001\u00033\naaY8oM&<WCAA.!\u0011\ti&!\u001b\u000e\u0005\u0005}#\u0002BA,\u0003CRA!a\u0019\u0002f\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002h\u0005\u00191m\\7\n\t\u0005-\u0014q\f\u0002\u0007\u0007>tg-[4\t\u0017\u0005=\u0014q\nB\u0001B\u0003%\u00111L\u0001\bG>tg-[4!\u0011\u001d\u0019\u0012q\nC\u0001\u0003g\"B!!\u001e\u0002xA\u0019a(a\u0014\t\u0011\u0005]\u0013\u0011\u000fa\u0001\u00037B!\"a\u001f\u0002P\t\u0007I\u0011AA?\u0003-\u0019VM]5bY&TXM]:\u0016\u0005\u0005}\u0004c\u0002\u000f\u0002\u0002\u0006\u0015\u0015QQ\u0005\u0004\u0003\u0007+#aA'baB\u0019A$a\"\n\u0005},\u0003\"CAF\u0003\u001f\u0002\u000b\u0011BA@\u00031\u0019VM]5bY&TXM]:!\u0011)\ty)a\u0014C\u0002\u0013\u0005\u0011QP\u0001\u0016'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8CS:$\u0017N\\4t\u0011%\t\u0019*a\u0014!\u0002\u0013\ty(\u0001\fTKJL\u0017\r\\5{CRLwN\u001c\"j]\u0012LgnZ:!\u0011!\t9*a\u0014\u0005\u000e\u0005e\u0015aC2p]\u001aLw\rV8NCB$B!a \u0002\u001c\"A\u0011QTAK\u0001\u0004\tY&A\u0002dM\u001e<!\"!)\n\u0003\u0003E\t\u0001BAR\u0003-IeNZ8s[\u0006$\u0018n\u001c8\u0011\u0007y\n)KB\u0005A\u0013\u0005\u0005\t\u0012\u0001\u0003\u0002(N)\u0011QUAU\u000bB9\u00111VAY\u0017ZkTBAAW\u0015\r\tyKD\u0001\beVtG/[7f\u0013\u0011\t\u0019,!,\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004\u0014\u0003K#\t!a.\u0015\u0005\u0005\r\u0006BCA \u0003K\u000b\t\u0011\"\u0012\u0002B!Q\u0011QXAS\u0003\u0003%\t)a0\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bu\n\t-a1\t\r%\u000bY\f1\u0001L\u0011\u0019!\u00161\u0018a\u0001-\"Q\u0011qYAS\u0003\u0003%\t)!3\u0002\u000fUt\u0017\r\u001d9msR!\u00111ZAj!\u0015i\u0011QZAi\u0013\r\tyM\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t5A2J\u0016\u0005\n\u0003+\f)-!AA\u0002u\n1\u0001\u001f\u00131\u0011)\tI.!*\u0002\u0002\u0013%\u00111\\\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002^B\u0019\u00110a8\n\u0007\u0005\u0005(P\u0001\u0004PE*,7\r\u001e\u0005\b\u0003KLA\u0011AAt\u0003M\u0019XM]5bY&TX\rZ!di>\u0014\b+\u0019;i)\u0011\t))!;\t\u0011\u0005-\u00181\u001da\u0001\u0003[\f\u0001\"Y2u_J\u0014VM\u001a\t\u0004\u0019\u0006=\u0018bAAy\u001b\nA\u0011i\u0019;peJ+g\rC\u0004\u0002v&!\t!a>\u00021]LG\u000f\u001b+sC:\u001c\bo\u001c:u\u0013:4wN]7bi&|g.\u0006\u0003\u0002z\u0006}H\u0003BA~\u0005\u001b!B!!@\u0003\u0004A\u0019q%a@\u0005\u000f\t\u0005\u00111\u001fb\u0001U\t\tA\u000b\u0003\u0005\u0003\u0006\u0005M\b\u0019\u0001B\u0004\u0003\u00051\u0007#B\u0007\u0003\n\u0005u\u0018b\u0001B\u0006\u001d\tIa)\u001e8di&|g\u000e\r\u0005\b)\u0006M\b\u0019\u0001B\b!\ra%\u0011C\u0005\u0004\u0005'i%aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016lg!\u0002\u0006\u0003\u0001\t]1#\u0002B\u000b\u0019\te\u0001c\u0001'\u0003\u001c%\u0019!QD'\u0003\u0013\u0015CH/\u001a8tS>t\u0007B\u0003+\u0003\u0016\t\u0015\r\u0011\"\u0001\u0003\"U\u0011!q\u0002\u0005\u000b5\nU!\u0011!Q\u0001\n\t=\u0001bB\n\u0003\u0016\u0011\u0005!q\u0005\u000b\u0005\u0005S\u0011Y\u0003E\u0002\t\u0005+Aq\u0001\u0016B\u0013\u0001\u0004\u0011y\u0001\u0003\u0006\u00030\tU!\u0019!C\u0001\u0005c\t\u0001b]3ui&twm]\u000b\u0003\u0005g\u0001BA!\u000e\u0002P9\u0011\u0001\u0002\u0001\u0005\n\u0005s\u0011)\u0002)A\u0005\u0005g\t\u0011b]3ui&twm\u001d\u0011\t\u0015\tu\"Q\u0003b\u0001\n\u0003\u0011y$\u0001\fBY2|wOS1wCN+'/[1mSj\fG/[8o+\t\ty\u0003C\u0005\u0003D\tU\u0001\u0015!\u0003\u00020\u00059\u0012\t\u001c7po*\u000bg/Y*fe&\fG.\u001b>bi&|g\u000e\t\u0005\n\u0005\u000f\u0012)\u0002)A\u0005\u0005\u0013\nAa\u00187pOB!!1\nB)\u001b\t\u0011iEC\u0002\u0003P\u0011\tQ!\u001a<f]RLAAa\u0015\u0003N\t!R*\u0019:lKJdunZ4j]\u001e\fE-\u00199uKJD!Ba\u0016\u0003\u0016\t\u0007I\u0011\u0001B-\u0003\rawnZ\u000b\u0003\u00057\u0002BAa\u0013\u0003^%!!q\fB'\u00059aunZ4j]\u001e\fE-\u00199uKJD\u0011Ba\u0019\u0003\u0016\u0001\u0006IAa\u0017\u0002\t1|w\r\t\u0005\u000b\u0005O\u0012)B1A\u0005\n\t%\u0014!D7b]&4Wm\u001d;DC\u000eDW-\u0006\u0002\u0003lA1!Q\u000eB=\u0005{j!Aa\u001c\u000b\t\tE$1O\u0001\u0007CR|W.[2\u000b\t\tU$qO\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001e}\u0013\u0011\u0011YHa\u001c\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\u0002Ba \u0003\u0006\u0006\u0015%qQ\u0007\u0003\u0005\u0003SAAa!\u0002\"\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003\u0007\u0013\t\tE\u0003\u000e\u0003\u001b\u0014I\t\r\u0003\u0003\f\nE\u0005#B=\u0003\u000e\n=\u0015B\u0001\u0013{!\r9#\u0011\u0013\u0003\f\u0005'\u0013)*!A\u0001\u0002\u000b\u0005!FA\u0002`IIB\u0011Ba&\u0003\u0016\u0001\u0006IAa\u001b\u0002\u001d5\fg.\u001b4fgR\u001c\u0015m\u00195fA!A!1\u0014B\u000b\t\u0003\u0011i*A\u0005tKJL\u0017\r\\5{KR!!q\u0014BY!\u0015A$\u0011\u0015BS\u0013\r\u0011\u0019+\u000f\u0002\u0004)JL\b#B\u0007\u0003(\n-\u0016b\u0001BU\u001d\t)\u0011I\u001d:bsB\u0019QB!,\n\u0007\t=fB\u0001\u0003CsR,\u0007b\u0002BZ\u00053\u0003\r\u0001D\u0001\u0002_\"A!q\u0017B\u000b\t\u0003\u0011I,A\u0006eKN,'/[1mSj,W\u0003\u0002B^\u0005\u0003$\u0002B!0\u0003D\n\u001d'1\u001a\t\u0006q\t\u0005&q\u0018\t\u0004O\t\u0005Ga\u0002B\u0001\u0005k\u0013\rA\u000b\u0005\t\u0005\u000b\u0014)\f1\u0001\u0003&\u0006)!-\u001f;fg\"A!\u0011\u001aB[\u0001\u0004\t9!\u0001\u0007tKJL\u0017\r\\5{KJLE\r\u0003\u0005\u0003N\nU\u0006\u0019\u0001Bh\u0003\u0015\u0019G.\u0019>{!\u0015i\u0011Q\u001aBia\u0011\u0011\u0019Na6\u0011\tq\u0019#Q\u001b\t\u0004O\t]G\u0001\u0004Bm\u00057\f\t\u0011!A\u0003\u0002\t-(aA0%i!A!Q\u001aB[\u0001\u0004\u0011i\u000eE\u0003\u000e\u0003\u001b\u0014y\u000e\r\u0003\u0003b\n\u0015\b\u0003\u0002\u000f$\u0005G\u00042a\nBs\t1\u0011INa7\u0002\u0002\u0003\u0005)\u0011\u0001Bt#\rY#\u0011\u001e\t\u0004O\t\u0005\u0017cA\u0016\u0003@\"A!q\u0017B\u000b\t\u0003\u0011y\u000f\u0006\u0005\u0003r\nM(Q\u001fB|!\u0011A$\u0011\u0015\u0007\t\u0011\t\u0015'Q\u001ea\u0001\u0005KC\u0001B!3\u0003n\u0002\u0007\u0011q\u0001\u0005\t\u0005s\u0014i\u000f1\u0001\u0002\u0006\u0006AQ.\u00198jM\u0016\u001cH\u000f\u0003\u0005\u0003~\nUA\u0011\u0002B\u0000\u0003Q!Wm]3sS\u0006d\u0017N_3CsR,\u0017I\u001d:bsR9Ab!\u0001\u0004\u0004\r\u001d\u0001\u0002\u0003Bc\u0005w\u0004\rA!*\t\u000f\r\u0015!1 a\u0001c\u0005Q1/\u001a:jC2L'0\u001a:\t\u0011\te(1 a\u0001\u0003\u000bC\u0001ba\u0003\u0003\u0016\u0011\u00051QB\u0001\u0016I\u0016\u001cXM]5bY&TXMQ=uK\n+hMZ3s)\u001da1qBB\u0010\u0007CA\u0001b!\u0005\u0004\n\u0001\u000711C\u0001\u0004EV4\u0007\u0003BB\u000b\u00077i!aa\u0006\u000b\u0007\reA0A\u0002oS>LAa!\b\u0004\u0018\tQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\t%7\u0011\u0002a\u0001\u0003\u000fA\u0001B!?\u0004\n\u0001\u0007\u0011Q\u0011\u0015\u0007\u0007\u0013\u0019)ca\u000e\u0011\u000b5\u00199ca\u000b\n\u0007\r%bB\u0001\u0004uQJ|wo\u001d\t\u0005\u0007[\u0019\u0019$\u0004\u0002\u00040)\u00191\u0011\u0007?\u0002\u0005%|\u0017\u0002BB\u001b\u0007_\u0011\u0001DT8u'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z#yG\u0016\u0004H/[8oG\t\u0019Y\u0003\u0003\u0005\u00038\nUA\u0011AB\u001e+\u0011\u0019ida\u0011\u0015\r\r}2QIB$!\u0015A$\u0011UB!!\r931\t\u0003\b\u0005\u0003\u0019ID1\u0001+\u0011!\u0011)m!\u000fA\u0002\t\u0015\u0006\u0002\u0003Bg\u0007s\u0001\ra!\u0013\u0011\tq\u00193\u0011\t\u0005\t\u0007\u001b\u0012)\u0002\"\u0001\u0004P\u0005\tb-\u001b8e'\u0016\u0014\u0018.\u00197ju\u0016\u0014hi\u001c:\u0015\u0007E\u001a\t\u0006C\u0004\u00034\u000e-\u0003\u0019\u0001\u0007\t\u0011\rU#Q\u0003C\u0001\u0007/\nQb]3sS\u0006d\u0017N_3s\r>\u0014HcA\u0019\u0004Z!A!QZB*\u0001\u0004\u0019Y\u0006\r\u0003\u0004^\r\u0005\u0004\u0003\u0002\u000f$\u0007?\u00022aJB1\t-\u0019\u0019g!\u0017\u0002\u0002\u0003\u0005)\u0011\u0001\u0016\u0003\u0007}#\u0003\b\u000b\u0004\u0004T\r\u00152q\u0007\u0005\t\u0007S\u0012)\u0002\"\u0001\u0004l\u0005a1/\u001a:jC2L'0\u001a:PMR!1QNB8!\u0011A$\u0011U\u0019\t\u0011\rE4q\ra\u0001\u0003\u000b\u000bQb]3sS\u0006d\u0017N_3s\rFs\u0005BCB;\u0005+\u0011\r\u0011\"\u0003\u0004x\u0005\t2/\u001a:jC2L'0\u001a:EKR\f\u0017\u000e\\:\u0016\u0005\re\u0004C\u0002B@\u0007w\u001ay(\u0003\u0003\u0004~\t\u0005%aA*fcB\u0019\u0001b!!\n\u0007\r\r%AA\tTKJL\u0017\r\\5{KJ$U\r^1jYND\u0011ba\"\u0003\u0016\u0001\u0006Ia!\u001f\u0002%M,'/[1mSj,'\u000fR3uC&d7\u000f\t\u0005\u000b\u0007\u0017\u0013)B1A\u0005\n\r5\u0015aC:fe&\fG.\u001b>feN,\"aa$\u0011\rq\t\t)!\"2\u0011%\u0019\u0019J!\u0006!\u0002\u0013\u0019y)\u0001\u0007tKJL\u0017\r\\5{KJ\u001c\b\u0005C\u0006\u0004\u0018\nU!\u0019!C\u0001\t\re\u0015\u0001\u00032j]\u0012LgnZ:\u0016\u0005\rm\u0005C\u0002B@\u0007w\u001ai\nE\u0002\u00036UA\u0011b!)\u0003\u0016\u0001\u0006Iaa'\u0002\u0013\tLg\u000eZ5oON\u0004\u0003\u0002CBS\u0005+!Iaa*\u00029\u0015t7/\u001e:f\u001f:d\u00170\u00117m_^,GmU3sS\u0006d\u0017N_3sgR!1\u0011VBX!\ri11V\u0005\u0004\u0007[s!\u0001B+oSRD\u0001b!-\u0004$\u0002\u000711W\u0001\u0005SR,'\u000fE\u0003\u00046\u000e}\u0016G\u0004\u0003\u00048\u000emfb\u0001\u0010\u0004:&\tq\"C\u0002\u0004>:\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002(\r\u0005'bAB_\u001d!A1Q\u0019B\u000b\t\u0013\u00199-A\ndQ\u0016\u001c7nR8pO2,\u0007K]8u_\n,h\r\u0006\u0003\u00020\r%\u0007\u0002CBf\u0007\u0007\u0004\r!!\"\u0002\u0013\rd\u0017m]:OC6,\u0007\u0002CBh\u0005+!Ia!5\u0002\tM|'\u000f\u001e\u000b\u0005\u00077\u001b\u0019\u000e\u0003\u0005\u0004V\u000e5\u0007\u0019ABl\u0003\tIg\u000e\u0005\u0004\u00046\u000ee7QT\u0005\u0005\u00077\u001c\tM\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011)\u0019yN!\u0006C\u0002\u0013%1\u0011]\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00199\u0016\u0005\r\r\bcBBs\u0007O\u001cY/M\u0007\u0003\u0005gJAa!;\u0003t\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u001991\t\r58\u0011\u001f\t\u00059\r\u001ay\u000fE\u0002(\u0007c$1ba=\u0004v\u0006\u0005\t\u0011!B\u0001U\t!q\fJ\u00191\u0011%\u00199P!\u0006!\u0002\u0013\u0019\u0019/\u0001\btKJL\u0017\r\\5{KJl\u0015\r\u001d\u0011\t\u0015\rm(Q\u0003b\u0001\n\u0003\u0019i0\u0001\u000btKJL\u0017\r\\5{KJ\u0014\u00150\u00133f]RLG/_\u000b\u0003\u0007\u007f\u0004b\u0001HAA\u0003\u000f\t\u0004\"\u0003C\u0002\u0005+\u0001\u000b\u0011BB\u0000\u0003U\u0019XM]5bY&TXM\u001d\"z\u0013\u0012,g\u000e^5us\u0002B!\u0002b\u0002\u0003\u0016\t\u0007I\u0011\u0002C\u0005\u0003e\tX/[2l'\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%eK:$\u0018\u000e^=\u0016\u0005\u0011-\u0001\u0003B\u0007\u0003(FB\u0011\u0002b\u0004\u0003\u0016\u0001\u0006I\u0001b\u0003\u00025E,\u0018nY6TKJL\u0017\r\\5{KJ\u0014\u00150\u00133f]RLG/\u001f\u0011\t\u0011\u0011M!Q\u0003C\u0005\t+\t\u0011cZ3u'\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%e)\r\tDq\u0003\u0005\t\t3!\t\u00021\u0001\u0002\b\u0005\u0011\u0011\u000e\u001a\u0005\u000b\t;\u0011)B1A\u0005\n\t}\u0012!I5t\u0015\u00064\u0018mU3sS\u0006d\u0017N_1uS>tw+\u0019:oS:<WI\\1cY\u0016$\u0007\"\u0003C\u0011\u0005+\u0001\u000b\u0011BA\u0018\u0003\tJ7OS1wCN+'/[1mSj\fG/[8o/\u0006\u0014h.\u001b8h\u000b:\f'\r\\3eA!QAQ\u0005B\u000b\u0005\u0004%IAa\u0010\u0002A%\u001cx+\u0019:oS:<wJ\u001c(p-\u0016\u0014\u0018NZ5dCRLwN\\#oC\ndW\r\u001a\u0005\n\tS\u0011)\u0002)A\u0005\u0003_\t\u0011%[:XCJt\u0017N\\4P]:{g+\u001a:jM&\u001c\u0017\r^5p]\u0016s\u0017M\u00197fI\u0002B\u0001\u0002\"\f\u0003\u0016\u0011%AqF\u0001\u001bSN$\u0015n]1mY><X\r\u001a&bm\u0006\u001cVM]5bY&TXM\u001d\u000b\u0005\u0003_!\t\u0004C\u0004\u0004\u0006\u0011-\u0002\u0019A\u0019\t\u0013\u0011U\"Q\u0003C\u0001\t\u0011]\u0012!H:i_VdGmV1s]\u0006\u0013w.\u001e;KCZ\f7+\u001a:jC2L'0\u001a:\u0015\r\u0005=B\u0011\bC$\u0011!!Y\u0004b\rA\u0002\u0011u\u0012aD:fe&\fG.\u001b>fI\u000ec\u0017m]:1\t\u0011}B1\t\t\u00059\r\"\t\u0005E\u0002(\t\u0007\"1\u0002\"\u0012\u0005:\u0005\u0005\t\u0011!B\u0001U\t!q\fJ\u00193\u0011\u001d\u0019)\u0001b\rA\u0002EBC\u0001b\r\u0005LA!AQ\nC)\u001b\t!yE\u0003\u0002o\t%!A1\u000bC(\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final scala.collection.immutable.Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> serializers;
    private final scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static <T> T withTransportInformation(ExtendedActorSystem extendedActorSystem, Function0<T> function0) {
        return Serialization$.MODULE$.withTransportInformation(extendedActorSystem, function0);
    }

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    public Try<byte[]> serialize(Object o) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.findSerializerFor(o).toBinary(o));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]. The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in synch between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return serializer2.fromBinary(bytes, clazz);
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]. The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in synch between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        Object object;
        Serializer serializer2 = serializer;
        if (serializer2 instanceof SerializerWithStringManifest) {
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer2;
            object = serializerWithStringManifest.fromBinary(bytes, manifest);
        } else {
            Object object2;
            String string = manifest;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object2 = serializer2.fromBinary(bytes, (Option<Class<?>>)None$.MODULE$);
            } else {
                Object object3;
                Map<String, Option<Class<?>>> cache = this.manifestCache().get();
                Option option = cache.get((Object)manifest);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Option cachedClassManifest = (Option)some.value();
                    object3 = serializer2.fromBinary(bytes, cachedClassManifest);
                } else if (None$.MODULE$.equals(option)) {
                    Try try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
                    if (!(try_ instanceof Success)) {
                        if (try_ instanceof Failure) {
                            throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest).append("] for serializer with id [").append(serializer.identifier()).append("].").toString());
                        }
                        throw new MatchError(try_);
                    }
                    Success success = (Success)try_;
                    Class classManifest = (Class)success.value();
                    Some classManifestOption = new Some((Object)classManifest);
                    this.updateCache$1(cache, manifest, (Option)classManifestOption);
                    Object object4 = serializer2.fromBinary(bytes, (Option<Class<?>>)classManifestOption);
                    object3 = object4;
                } else {
                    throw new MatchError((Object)option);
                }
                object2 = object3;
            }
            object = object2;
        }
        return object;
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        Serializer serializer2;
        try {
            serializer2 = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]. The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer3 = serializer = serializer2;
        if (serializer3 instanceof ByteBufferSerializer) {
            Serializer serializer4 = serializer3;
            object = ((ByteBufferSerializer)((Object)serializer4)).fromBinary(buf, manifest);
        } else {
            byte[] bytes = new byte[buf.remaining()];
            buf.get(bytes);
            object = this.deserializeByteArray(bytes, serializer, manifest);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.serializerFor(clazz).fromBinary(bytes, (Option<Class<?>>)new Some((Object)clazz)));
    }

    public Serializer findSerializerFor(Object o) {
        return o == null ? NullSerializer$.MODULE$ : this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            Serializer serializer4;
            Serializer serializer5;
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.bindings().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$3(clazz, x0$2)));
            Some some = Seq$.MODULE$.unapplySeq((Seq)seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            if (Serialization.unique$1(seq)) {
                serializer5 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                scala.collection.immutable.Seq possibilitiesWithoutJavaSerializer = (scala.collection.immutable.Seq)seq.filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$4(x0$3)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((TraversableOnce)possibilitiesWithoutJavaSerializer.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Serializer s = (Serializer)tuple2._2();
                        String string = s.getClass().getName();
                        return string;
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", "));
                }
                serializer5 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer4 = serializer5;
            Serializer serializer6 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer6 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the default Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'akka.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                serializer3 = ser;
            } else {
                serializer3 = serializer6;
            }
            serializer = serializer3;
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    /*
     * Unable to fully structure code
     */
    public Try<Serializer> serializerOf(String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var3_2 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var3_2) == false : var3_2 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system())})), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new scala.Serializable(this, fqn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final String fqn$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Try<T> try_ = A1 instanceof NoSuchMethodException ? this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)) : function1.apply(x1);
                return (B1)try_;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NoSuchMethodException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
            }
        });
    }

    private scala.collection.immutable.Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        block0: {
            if (this.system().settings().AllowJavaSerialization()) break block0;
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$ensureOnlyAllowedSerializers$2(this, x$6))), (Function0 & Serializable & scala.Serializable)() -> "Disallowed JavaSerializer binding.");
        }
    }

    private boolean checkGoogleProtobuf(String className) {
        return !className.startsWith("com.google.protobuf") || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        ArrayBuffer arrayBuffer = new ArrayBuffer(in.size());
        return (scala.collection.immutable.Seq)((TraversableLike)in.$div$colon((Object)arrayBuffer, (Function2 & Serializable & scala.Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$sort$2(ca, x$8)));
            switch (n) {
                case -1: {
                    buf.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
                default: {
                    buf.insert(n, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
            }
            return buf;
        })).to(Predef$.MODULE$.fallbackStringCanBuildFrom());
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        Serializer serializer;
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer2;
            Serializer serializer3 = this.quickSerializerByIdentity()[id];
            if (serializer3 == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            serializer = serializer2 = serializer3;
        } else {
            serializer = (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
        }
        return serializer;
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean akka$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("akka.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(scala.collection.immutable.Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(0))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(scala.collection.immutable.Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)possibilities$1.apply(0))._2());
    }

    private static final boolean unique$1(scala.collection.immutable.Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Class c = (Class)tuple2._1();
        boolean bl = c.isAssignableFrom(clazz$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        boolean bl = tuple2 != null && tuple2._2() instanceof JavaSerializer ? false : tuple2 == null || !(tuple2._2() instanceof DisabledJavaSerializer);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 == null) return false;
        String className = (String)tuple2._1();
        String alias = (String)tuple2._2();
        if (className == null) return false;
        if (alias == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        String string;
        String string2;
        String alias;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$4;
                if (tuple2 == null) break block2;
                String className = (String)tuple2._1();
                alias = (String)tuple2._2();
                if (className == null) break block2;
                string2 = className;
                if (alias != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String string3 = string = alias;
        String string4 = "none";
        boolean bl = (string3 == null ? string4 != null : !string3.equals(string4)) && $this.checkGoogleProtobuf(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$2(Serialization $this, Serializer x$6) {
        return !$this.akka$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$8) {
        return ((Class)x$8._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$9) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$9;
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            Serializer ser = (Serializer)tuple2._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public Serialization(ExtendedActorSystem system) {
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SerializationSetup setting = (SerializationSetup)some.value();
            vector = (scala.collection.immutable.Seq)setting.createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = (scala.collection.immutable.Seq)vector.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x2;
                if (A12 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((A1 = A12).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
                    object = SerializerDetails$.MODULE$.apply(A1.alias(), new DisabledJavaSerializer(this.$outer.system()), A1.useFor());
                } else {
                    object = A12;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SerializerDetails x2) {
                SerializerDetails serializerDetails;
                SerializerDetails serializerDetails2 = x2;
                boolean bl = serializerDetails2 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((serializerDetails = serializerDetails2).serializer()) ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map fromConfig = (Map)this.settings().Serializers().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            String string;
            String v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$3;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = (String)tuple2._2();
                    if (k == null) break block2;
                    string = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = v;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)string), this.serializerOf(string2).get());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Map result = fromConfig.$plus$plus((GenTraversableOnce)this.serializerDetails().map((Function1 & Serializable & scala.Serializable)d -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer()), Seq$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)((Iterator)result.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }, scala.collection.package$.MODULE$.breakOut((CanBuildFrom)Iterator$.MODULE$.IteratorCanBuildFrom()))));
        this.serializers = result;
        scala.collection.immutable.Iterable fromConfig2 = (scala.collection.immutable.Iterable)this.settings().SerializationBindings().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$2(this, x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            String string;
            String alias;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$5;
                    if (tuple2 == null) break block2;
                    String className = (String)tuple2._1();
                    alias = (String)tuple2._2();
                    if (className == null) break block2;
                    string = className;
                    if (alias != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = alias;
            Tuple2 tuple2 = new Tuple2(this.system().dynamicAccess().getClassFor(string, ClassTag$.MODULE$.Any()).get(), this.serializers().apply((Object)string2));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq fromSettings = (scala.collection.immutable.Seq)this.serializerDetails().flatMap((Function1 & Serializable & scala.Serializable)detail -> (scala.collection.immutable.Seq)detail.useFor().map((Function1 & Serializable & scala.Serializable)clazz -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)detail.serializer()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig2.$plus$plus((GenTraversableOnce)fromSettings, Iterable$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)((Iterator)result2.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }, scala.collection.package$.MODULE$.breakOut((CanBuildFrom)Iterator$.MODULE$.IteratorCanBuildFrom()))));
        this.bindings = result2;
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        this.serializerMap = (ConcurrentHashMap)this.bindings().$div$colon(concurrentHashMap, (Function2 & Serializable & scala.Serializable)(x0$7, x1$1) -> {
            Tuple2 tuple2;
            ConcurrentHashMap map;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$7, x1$1);
                    if (tuple22 == null) break block2;
                    map = (ConcurrentHashMap)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Class c = (Class)tuple2._1();
            Serializer s = (Serializer)tuple2._2();
            map.put(c, s);
            ConcurrentHashMap concurrentHashMap = map;
            return concurrentHashMap;
        });
        this.serializerByIdentity = (Map)((TraversableLike)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}))).$plus$plus(this.serializers(), Map$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer v = (Serializer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)v.identifier()), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$9);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("akka.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("akka.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    scala.Serializable {
        private final Address address;
        private final ActorSystem system;

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.address();
                    break;
                }
                case 1: {
                    object = this.system();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$((Product)this);
        }
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            Config config2;
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            Config defaultBindings = config.getConfig("akka.actor.serialization-bindings");
            if (config.getBoolean("akka.actor.enable-additional-serialization-bindings") || !config.getBoolean("akka.actor.allow-java-serialization") || config.hasPath("akka.remote.artery.enabled") && config.getBoolean("akka.remote.artery.enabled")) {
                Config bs = defaultBindings.withFallback((ConfigMergeable)config.getConfig("akka.actor.additional-serialization-bindings"));
                String additionalWhenJavaOffKey = "akka.actor.java-serialization-disabled-additional-serialization-bindings";
                config2 = !config.getBoolean("akka.actor.allow-java-serialization") ? bs.withFallback((ConfigMergeable)config.getConfig(additionalWhenJavaOffKey)) : bs;
            } else {
                config2 = defaultBindings;
            }
            Config bindings = config2;
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

