/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.logging;

import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.impact.api.CrawlerConfig;
import com.xebialabs.impact.api.ReportCrawlerLogMessageRequestVM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class AgathaLogger {
    private static final int MAX_LOG_CONTENT = 0x100000;
    private AbstractCrawler crawler;
    private Logger logger;
    private String pluginId = "N/A";
    private String networkId = "";
    private String dataSourceId = "N/A";
    private boolean isLogReportingEnabled = false;
    private CrawlerConfig.LogReportLevel currentLogReportLevel = CrawlerConfig.LogReportLevel.ERROR;

    private AgathaLogger(AbstractCrawler crawler, Class<?> loggerName) {
        this.crawler = crawler;
        this.logger = LoggerFactory.getLogger(loggerName);
    }

    private AgathaLogger(AbstractCrawler crawler, String loggerName) {
        this.crawler = crawler;
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public static AgathaLogger getLogger(AbstractCrawler crawler, Class<?> loggerName) {
        return new AgathaLogger(crawler, loggerName);
    }

    public static AgathaLogger getLogger(AbstractCrawler crawler, String loggerName) {
        return new AgathaLogger(crawler, loggerName);
    }

    private void reportLogToApi(CrawlerConfig.LogReportLevel level, String content) {
        if (this.isLogReportingEnabled && this.crawler.getIngestionApi() != null && level.getNumber() <= this.currentLogReportLevel.getNumber()) {
            this.crawler.getIngestionApi().reportCrawlerLog(new ReportCrawlerLogMessageRequestVM().setTenantId(this.crawler.getTenantId()).setPluginId(this.pluginId).setNetworkId(this.networkId).setDataSourceId(this.dataSourceId).setLogLevel(level).setLogContent(content.length() > 0x100000 ? content.substring(0, 0x100000) : content));
        }
    }

    public void setDataSourceDetails(String pluginId, String networkId, String dataSourceId) {
        this.pluginId = pluginId;
        this.networkId = networkId;
        this.dataSourceId = dataSourceId;
    }

    public void debug(String message) {
        this.logger.debug(message);
        this.reportLogToApi(CrawlerConfig.LogReportLevel.DEBUG, message);
    }

    public void debug(String format, Object ... arguments) {
        this.logger.debug(format, arguments);
        this.reportLogToApi(CrawlerConfig.LogReportLevel.DEBUG, MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
    }

    public void info(String message) {
        this.logger.info(message);
        this.reportLogToApi(CrawlerConfig.LogReportLevel.INFO, message);
    }

    public void info(String format, Object ... arguments) {
        this.logger.info(format, arguments);
        this.reportLogToApi(CrawlerConfig.LogReportLevel.INFO, MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
    }

    public void warn(String message) {
        this.logger.warn(message);
        this.reportLogToApi(CrawlerConfig.LogReportLevel.WARNING, message);
    }

    public void warn(String format, Object ... arguments) {
        this.logger.warn(format, arguments);
        this.reportLogToApi(CrawlerConfig.LogReportLevel.WARNING, MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
    }

    public void error(String message) {
        this.logger.error(message);
        this.reportLogToApi(CrawlerConfig.LogReportLevel.ERROR, message);
    }

    public void error(String format, Object ... arguments) {
        this.logger.error(format, arguments);
        this.reportLogToApi(CrawlerConfig.LogReportLevel.ERROR, MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
    }

    public boolean isLogReportingEnabled() {
        return this.isLogReportingEnabled;
    }

    public AgathaLogger setLogReportingEnabled(boolean logReportingEnabled) {
        this.isLogReportingEnabled = logReportingEnabled;
        return this;
    }

    public CrawlerConfig.LogReportLevel getCurrentLogReportLevel() {
        return this.currentLogReportLevel;
    }

    public AgathaLogger setCurrentLogReportLevel(CrawlerConfig.LogReportLevel currentLogReportLevel) {
        this.currentLogReportLevel = currentLogReportLevel;
        return this;
    }
}

