/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.CrawlerExecutor;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.crawlers.travis.components.TravisCrawlResolver;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisJobMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisRepoMessage;
import com.xebialabs.agatha.crawlers.travis.services.probe.ProbeService;
import com.xebialabs.agatha.crawlers.travis.services.probe.ProbeServiceImpl;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TravisCrawler
extends AbstractHttpCrawler {
    private static final Logger logger = LoggerFactory.getLogger(TravisCrawler.class);
    private final CrawlResolver<TravisCrawler> crawlResolver = new TravisCrawlResolver();

    public TravisCrawler() {
        super("TravisPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_TOKEN);
    }

    public TravisCrawler(Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        super("TravisPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_TOKEN, ingestionApiProvider);
    }

    protected ObjectMapper createMapper() {
        ObjectMapper mapper = super.createMapper();
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    protected CrawlerJobResult crawlItem(CrawlerJobWrapper crawlerJob) {
        try {
            CrawlService crawl = this.crawlResolver.resolve((AbstractCrawler)this, crawlerJob);
            crawl.execute();
            return CrawlerJobResult.success();
        }
        catch (CrawlerWorkException e) {
            return CrawlerJobResult.fail((String)e.getMessage());
        }
    }

    protected ProbeResultMetadataVM probe(CrawlerJobWrapper crawlerJobWrapper) {
        return this.probeService().probe();
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error(e.getMessage(), e));
        new CrawlerExecutor(TravisCrawler::new).execute();
    }

    private ProbeService probeService() {
        return new ProbeServiceImpl(this.endpoint, (OkHttpClient)this.getClient(), this.username);
    }

    public <V extends BaseCrawlerMessage> V generateNewMessage(Class<V> cls, BaseCrawlerMessage oldMsg) throws IllegalAccessException, InstantiationException {
        TravisJobMessage old;
        TravisJobMessage newMsg;
        BaseCrawlerMessage v = super.generateNewMessage(cls, oldMsg);
        if (v instanceof TravisBuildMessage && oldMsg instanceof TravisBuildMessage) {
            newMsg = (TravisBuildMessage)v;
            old = (TravisBuildMessage)oldMsg;
            ((TravisBuildMessage)newMsg).setBuildId(((TravisBuildMessage)old).getBuildId());
        }
        if (v instanceof TravisRepoMessage && oldMsg instanceof TravisRepoMessage) {
            newMsg = (TravisRepoMessage)v;
            old = (TravisRepoMessage)oldMsg;
            ((TravisRepoMessage)newMsg).setRepoName(((TravisRepoMessage)old).getRepoName()).setRepoId(((TravisRepoMessage)old).getRepoId());
        }
        if (v instanceof TravisJobMessage && oldMsg instanceof TravisJobMessage) {
            newMsg = (TravisJobMessage)v;
            old = (TravisJobMessage)oldMsg;
            newMsg.setBaseUrl(old.getBaseUrl()).setSelfUrl(old.getSelfUrl()).setUserName(old.getUserName());
        }
        return (V)v;
    }
}

