/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.match.model;

import io.vavr.match.model.MethodModel;
import io.vavr.match.model.TypeParameterModel;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class ClassModel {
    private final Elements elementUtils;
    private final DeclaredType declaredType;

    public static ClassModel of(Elements elementUtils, TypeElement typeElement) {
        return new ClassModel(elementUtils, (DeclaredType)typeElement.asType());
    }

    public ClassModel(Elements elementUtils, DeclaredType declaredType) {
        this.elementUtils = elementUtils;
        this.declaredType = declaredType;
    }

    public TypeElement typeElement() {
        return (TypeElement)this.declaredType.asElement();
    }

    public String getClassName() {
        String fqn = this.getFullQualifiedName();
        return this.hasDefaultPackage() ? fqn : fqn.substring(this.getPackageName().length() + 1);
    }

    public String getFullQualifiedName() {
        return this.typeElement().getQualifiedName().toString();
    }

    public List<MethodModel> getMethods() {
        return this.typeElement().getEnclosedElements().stream().filter(element -> {
            String name = element.getSimpleName().toString();
            return element instanceof ExecutableElement && !name.isEmpty() && !"<init>".equals(name) && !"<clinit>".equals(name);
        }).map(element -> new MethodModel(this.elementUtils, (ExecutableElement)element)).collect(Collectors.toList());
    }

    public String getPackageName() {
        return this.elementUtils.getPackageOf(this.typeElement()).getQualifiedName().toString();
    }

    public List<TypeParameterModel> getTypeParameters() {
        return this.declaredType.getTypeArguments().stream().map(typeMirror -> new TypeParameterModel(this.elementUtils, (TypeMirror)typeMirror)).collect(Collectors.toList());
    }

    public boolean hasDefaultPackage() {
        return this.elementUtils.getPackageOf(this.typeElement()).isUnnamed();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ClassModel && this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.declaredType.toString();
    }
}

