/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.zendesk.transform.converters;

import com.xebialabs.agatha.crawlers.shared.PluginConstants;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.zendesk.models.CustomField;
import com.xebialabs.agatha.crawlers.zendesk.models.dtos.CustomFieldResponse;
import com.xebialabs.agatha.crawlers.zendesk.transform.models.CustomFieldUM;
import com.xebialabs.impact.api.DataSourceTypeEnum;

public class CustomFieldConverter
implements UMConverter<CustomFieldUM, CustomFieldResponse> {
    private static final String MULTISELECT = "multiselect";
    private static final String INTEGER = "integer";
    private static final String DECIMAL = "decimal";
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;

    public CustomFieldConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
    }

    public UMWrappedEntity<CustomFieldUM> convert(CustomFieldResponse entity) {
        CustomFieldUM customFieldUM = new CustomFieldUM();
        this.populateFields(entity, customFieldUM);
        return this.wrappedEntity(customFieldUM);
    }

    private void populateFields(CustomFieldResponse entity, CustomFieldUM customFieldUM) {
        entity.getCustomFields().stream().filter(CustomField::isRemovable).forEach(cf -> customFieldUM.getFields().put(cf.getId(), CustomFieldUM.FieldDetails.newInstance(this.convertToUDMFieldType(cf.getType()), cf.getTitle())));
    }

    private UMWrappedEntity<CustomFieldUM> wrappedEntity(CustomFieldUM um) {
        return new UMWrappedEntity(this.pluginId, this.pluginVersion, this.type, this.typeVersion, (Object)um, DataSourceTypeEnum.FIELDS).wrap();
    }

    private String convertToUDMFieldType(String type) {
        switch (type) {
            case "integer": {
                return PluginConstants.FieldType.LONG.getName();
            }
            case "decimal": {
                return PluginConstants.FieldType.DOUBLE.getName();
            }
            case "multiselect": {
                return PluginConstants.FieldType.MULTI_SELECT.getName();
            }
        }
        return PluginConstants.FieldType.STRING_NOT_ANALYZED.getName();
    }
}

