/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.zendesk;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;

public class ZendeskUrlHelper {
    private static final String API_VERSION = "v2";
    private static final String contentType = "json";
    private static final String API = "api";
    private static final String TICKETS_QUERY_1 = "&query=type:ticket+updated>%s";
    private static final String TICKETS_QUERY_2 = "&query=type:ticket+updated>%s+updated<%s";

    public static URL probeUrl(URL endPoint) throws MalformedURLException {
        return new URL(endPoint, String.format("/api/%s/users/me.%s", API_VERSION, contentType));
    }

    private static URL getURL(String endPoint) throws CrawlerWorkException {
        try {
            return new URL(endPoint);
        }
        catch (MalformedURLException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private static HttpUrl.Builder baseUrlBuilder(String endPoint) throws CrawlerWorkException {
        if (endPoint != null && !endPoint.isEmpty()) {
            URL baseURL = ZendeskUrlHelper.getURL(endPoint);
            HttpUrl.Builder builder = new HttpUrl.Builder().scheme(baseURL.getProtocol()).host(baseURL.getHost()).addPathSegment(API).addPathSegment(API_VERSION);
            if (baseURL.getPort() != -1) {
                builder.port(baseURL.getPort());
            }
            return builder;
        }
        throw new CrawlerWorkException("Base URL can not be empty or null.");
    }

    private static URL baseEntitiesURL(String endPoint, int pageNumber, int limit) throws CrawlerWorkException {
        return ZendeskUrlHelper.baseUrlBuilder(endPoint).addPathSegment("search.json").addQueryParameter("sort_by", "updated_at").addQueryParameter("sort_order", "desc").addQueryParameter("page", Integer.toString(pageNumber)).addQueryParameter("per_page", Integer.toString(limit)).build().url();
    }

    public static URL ticketFieldsUrl(String endPoint) throws CrawlerWorkException {
        return ZendeskUrlHelper.baseUrlBuilder(endPoint).addPathSegment("ticket_fields.json").build().url();
    }

    public static URL ticketsUrl(String endPoint, int pageNumber, int limit, String crawlDateFrom, String lastUpdatedDate) throws CrawlerWorkException {
        return ZendeskUrlHelper.ticketsURLWithQueries(endPoint, pageNumber, limit, crawlDateFrom, lastUpdatedDate, TICKETS_QUERY_1, TICKETS_QUERY_2);
    }

    private static URL ticketsURLWithQueries(String endPoint, int pageNumber, int limit, String dateFrom, String lastUpdatedDate, String queryParam1, String queryParam2) throws CrawlerWorkException {
        URL baseUrl = ZendeskUrlHelper.baseEntitiesURL(endPoint, pageNumber, limit);
        String suffix = StringUtils.isEmpty((CharSequence)lastUpdatedDate) ? String.format(queryParam1, dateFrom) : String.format(queryParam2, dateFrom, lastUpdatedDate);
        return HttpUrl.parse((String)(baseUrl.toString() + suffix)).url();
    }

    public static URL ticketUrl(String endPoint, String ticketId) throws CrawlerWorkException {
        return ZendeskUrlHelper.baseUrlBuilder(endPoint).addPathSegment("tickets").addPathSegment(ticketId + ".json").addQueryParameter("include", "users,groups,organizations").build().url();
    }
}

