/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.zendesk;

import com.google.common.base.Joiner;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;

public class ZendeskUtil {
    private ZendeskUtil() {
    }

    public static String generateDataId(String ... args) {
        Joiner joiner = Joiner.on((String)"/").useForNull("null");
        LinkedList<String> paths = new LinkedList<String>(Arrays.asList(args));
        return joiner.join(paths);
    }

    public static String crawlDateFrom(Date validDate) {
        return new SimpleDateFormat("yyyy-MM-dd").format(validDate);
    }

    public static Long dateAsLong(String date) throws CrawlerWorkException {
        try {
            if (date != null && !date.isEmpty()) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                return simpleDateFormat.parse(date).getTime();
            }
            return null;
        }
        catch (ParseException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

