/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.zendesk.transform.converters;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.zendesk.ZendeskUtil;
import com.xebialabs.agatha.crawlers.zendesk.models.CustomField;
import com.xebialabs.agatha.crawlers.zendesk.models.Group;
import com.xebialabs.agatha.crawlers.zendesk.models.Organization;
import com.xebialabs.agatha.crawlers.zendesk.models.ZendeskBaseEntity;
import com.xebialabs.agatha.crawlers.zendesk.models.ZendeskTicket;
import com.xebialabs.agatha.crawlers.zendesk.models.dtos.TicketResponse;
import com.xebialabs.agatha.crawlers.zendesk.transform.models.Ticket;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class TicketConverter
implements UMConverter<Ticket, TicketResponse> {
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;

    public TicketConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
    }

    public UMWrappedEntity<Ticket> convert(TicketResponse ticketResponse) throws CrawlerWorkException {
        Ticket ticket = new Ticket();
        this.populateSystemFields(ticket, ticketResponse);
        this.populateCustomFields(ticket, ticketResponse);
        this.populateAdditionalFields(ticket, ticketResponse);
        this.parentRelations(ticket, ticketResponse);
        return this.wrappedEntity(ticket);
    }

    private void populateAdditionalFields(Ticket ticket, TicketResponse ticketResponse) throws CrawlerWorkException {
        ZendeskTicket entity = ticketResponse.getTicket();
        ticket.setId(entity.getId()).setVersion(ZendeskUtil.dateAsLong(entity.getUpdatedAt())).setStartMs(ZendeskUtil.dateAsLong(entity.getCreatedAt())).setTitle(entity.getSubject()).setLabels(entity.getTags()).setTicketType(entity.getType()).setStatus(entity.getStatus()).setAssignee(entity.getAssigneeId()).setPriority(entity.getPriority());
    }

    private <T extends ZendeskBaseEntity> Optional<T> getDisplayValue(List<T> propertyList, String propertyId) {
        return propertyList.stream().filter(property -> property.getId().equalsIgnoreCase(propertyId)).findAny();
    }

    private void populateCustomFields(Ticket ticket, TicketResponse ticketResponse) {
        HashMap<String, Object> customFields = new HashMap<String, Object>();
        for (CustomField customField : ticketResponse.getTicket().getCustomFields()) {
            customFields.put(customField.getId(), customField.getValue());
        }
        ticket.setCustomFields(customFields);
    }

    private void populateSystemFields(Ticket ticket, TicketResponse ticketResponse) throws CrawlerWorkException {
        ZendeskTicket crawledTicket = ticketResponse.getTicket();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("requester", crawledTicket.getRequesterId());
        fields.put("dueDate", ZendeskUtil.dateAsLong(crawledTicket.getDueAt()));
        fields.put("description", crawledTicket.getDescription());
        fields.put("isPublic", String.valueOf(crawledTicket.isPublic()));
        fields.put("submitter", crawledTicket.getSubmitterId());
        fields.put("organization", this.getOrgName(this.getDisplayValue(ticketResponse.getOrganizations(), crawledTicket.getOrganizationId())));
        fields.put("group", this.getGroupName(this.getDisplayValue(ticketResponse.getGroups(), crawledTicket.getGroupId())));
        ticket.setAdditionalFields(fields);
    }

    private void parentRelations(Ticket ticket, TicketResponse ticketResponse) {
        HashMap<String, String> relations = new HashMap<String, String>();
        relations.put("issueKey", ticketResponse.getTicket().getId());
        Ticket.Other other = new Ticket.Other(relations);
        ticket.setOther(other);
    }

    private String getOrgName(Optional<Organization> displayValue) {
        return displayValue.map(Organization::getName).orElse(null);
    }

    private String getGroupName(Optional<Group> displayValue) {
        return displayValue.map(Group::getName).orElse(null);
    }

    private UMWrappedEntity<Ticket> wrappedEntity(Ticket um) {
        return new UMWrappedEntity(this.pluginId, this.pluginVersion, this.type, this.typeVersion, (Object)um, DataSourceTypeEnum.TICKET).setId(TicketConverter.artifactId(um.getId())).setVersion(um.getVersion() + "").wrap();
    }

    public static String artifactId(String id) {
        return String.format("%s-%s", "ticket", id);
    }
}

