class ReleaseGridPage {
    constructor() {
        Browser.waitFor('.ui-grid-contents-wrapper');
    }

    expectItemWithTitleStatusAndDates(title, status, startDate, endDate) {
        expect(element(By.$(`.ui-grid-canvas .ui-grid-row:contains(${title}):contains(${status}):contains(${startDate}):contains(${endDate})`))).toBePresent();
        return this;
    }

    expectItemWithTitle(title) {
        expect(element(By.$(`.ui-grid-canvas .name-cell:contains(${title})`))).toBePresent();
        return this;
    }

    openContextMenu(task) {
        element(By.$(`.ui-grid-cell-contents:contains(${task}) .context-menu-button`)).click();
        return this;
    }

    openReleaseFlowAndWaitForGrid() {
        element(By.css('#release-header .subpage-links button')).click();
        element(By.$("#subpages-container div:contains('Release flow')")).click();
        return new ReleaseGridPage();
    }
}

global.ReleaseGridPage = ReleaseGridPage;
