/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.xlrelease.api.v1.EnvironmentApi;
import com.xebialabs.xlrelease.api.v1.EnvironmentLabelApi;
import com.xebialabs.xlrelease.api.v1.EnvironmentReservationApi;
import com.xebialabs.xlrelease.api.v1.EnvironmentStageApi;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentLabelFilters;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentStageFilters;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.ascode.service.GenerateService;
import com.xebialabs.xlrelease.ascode.utils.DateUtils$;
import com.xebialabs.xlrelease.ascode.utils.Utils$;
import com.xebialabs.xlrelease.ascode.yaml.model.Environment;
import com.xebialabs.xlrelease.ascode.yaml.model.Label;
import com.xebialabs.xlrelease.ascode.yaml.model.Reservation;
import java.io.Serializable;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001\u0002\u0006\f\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tM\u0001\u0011\t\u0011)A\u0005O!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\u0011\u0011$\u00128wSJ|g.\\3oiN\f5oQ8eKN+'O^5dK*\u0011A\"D\u0001\bg\u0016\u0014h/[2f\u0015\tqq\"\u0001\u0004bg\u000e|G-\u001a\u0006\u0003!E\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005I\u0019\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005!\u0012aA2p[\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u0006A1\u000f^1hK\u0006\u0003\u0018\u000e\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005\u0011a/\r\u0006\u0003G=\t1!\u00199j\u0013\t)\u0003EA\nF]ZL'o\u001c8nK:$8\u000b^1hK\u0006\u0003\u0018.\u0001\u0005mC\n,G.\u00119j!\ty\u0002&\u0003\u0002*A\t\u0019RI\u001c<je>tW.\u001a8u\u0019\u0006\u0014W\r\\!qS\u0006qQM\u001c<je>tW.\u001a8u\u0003BL\u0007CA\u0010-\u0013\ti\u0003E\u0001\bF]ZL'o\u001c8nK:$\u0018\t]5\u00023\u0015tg/\u001b:p]6,g\u000e\u001e*fg\u0016\u0014h/\u0019;j_:\f\u0005/\u001b\t\u0003?AJ!!\r\u0011\u00033\u0015sg/\u001b:p]6,g\u000e\u001e*fg\u0016\u0014h/\u0019;j_:\f\u0005/[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bQ2t\u0007O\u001d\u0011\u0005U\u0002Q\"A\u0006\t\u000bu)\u0001\u0019\u0001\u0010\t\u000b\u0019*\u0001\u0019A\u0014\t\u000b)*\u0001\u0019A\u0016\t\u000b9*\u0001\u0019A\u0018)\u0005\u0015Y\u0004C\u0001\u001fH\u001b\u0005i$B\u0001 @\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0001\u0006\u000bqAZ1di>\u0014\u0018P\u0003\u0002C\u0007\u0006)!-Z1og*\u0011A)R\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta)A\u0002pe\u001eL!\u0001S\u001f\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AD4f]\u0016\u0014\u0018\r^3Ti\u0006<Wm\u001d\u000b\u0003\u0017~\u00032\u0001\u0014+X\u001d\ti%K\u0004\u0002O#6\tqJ\u0003\u0002Q+\u00051AH]8pizJ\u0011AG\u0005\u0003'f\tq\u0001]1dW\u0006<W-\u0003\u0002V-\n!A*[:u\u0015\t\u0019\u0016\u0004\u0005\u0002Y9:\u0011\u0011L\u0017\t\u0003\u001dfI!aW\r\u0002\rA\u0013X\rZ3g\u0013\tifL\u0001\u0004TiJLgn\u001a\u0006\u00037fAQ\u0001\u0019\u0004A\u0004\u0005\fqbZ3oKJ\fGo\u001c:D_:4\u0017n\u001a\t\u0003E>t!aY7\u000f\u0005\u0011dgBA3l\u001d\t1'N\u0004\u0002hS:\u0011a\n[\u0005\u0002)%\u0011!cE\u0005\u0003!EI!AD\b\n\u00051i\u0011B\u00018\f\u0003=9UM\\3sCR,7+\u001a:wS\u000e,\u0017B\u00019r\u0005=9UM\\3sCR|'oQ8oM&<'B\u00018\f\u000399WM\\3sCR,G*\u00192fYN$\"\u0001^?\u0011\u00071#V\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006)Qn\u001c3fY*\u0011!0D\u0001\u0005s\u0006lG.\u0003\u0002}o\n)A*\u00192fY\")\u0001m\u0002a\u0002C\u0006!r-\u001a8fe\u0006$X-\u00128wSJ|g.\\3oiN$B!!\u0001\u0002\nA!A\nVA\u0002!\r1\u0018QA\u0005\u0004\u0003\u000f9(aC#om&\u0014xN\\7f]RDQ\u0001\u0019\u0005A\u0004\u0005\fqdZ3oKJ\fG/Z#om&\u0014xN\\7f]R\u0014Vm]3sm\u0006$\u0018n\u001c8t)\u0011\ty!a\u0006\u0011\t1#\u0016\u0011\u0003\t\u0004m\u0006M\u0011bAA\u000bo\nY!+Z:feZ\fG/[8o\u0011\u0015\u0001\u0017\u0002q\u0001bQ\r\u0001\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\"\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002&\u0005}!aB*feZL7-\u001a")
public class EnvironmentsAsCodeService {
    private final EnvironmentStageApi stageApi;
    private final EnvironmentLabelApi labelApi;
    private final EnvironmentApi environmentApi;
    private final EnvironmentReservationApi environmentReservationApi;

    public List<String> generateStages(GenerateService.GeneratorConfig generatorConfig) {
        return Utils$.MODULE$.whenEnabled((Function1<GenerateService.CisConfig, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.generateEnvironments()), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.stageApi.search(new EnvironmentStageFilters((String)generatorConfig.name().orNull(Predef$.MODULE$.$conforms())))).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getTitle(), Buffer$.MODULE$.canBuildFrom())).toList(), generatorConfig);
    }

    public List<Label> generateLabels(GenerateService.GeneratorConfig generatorConfig) {
        return Utils$.MODULE$.whenEnabled((Function1<GenerateService.CisConfig, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.generateEnvironments()), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.labelApi.search(new EnvironmentLabelFilters((String)generatorConfig.name().orNull(Predef$.MODULE$.$conforms())))).asScala()).map((Function1 & Serializable & scala.Serializable)v -> new Label(v.getTitle(), v.getColor()), Buffer$.MODULE$.canBuildFrom())).toList(), generatorConfig);
    }

    public List<Environment> generateEnvironments(GenerateService.GeneratorConfig generatorConfig) {
        return Utils$.MODULE$.whenEnabled((Function1<GenerateService.CisConfig, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.generateEnvironments()), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.environmentApi.search(new EnvironmentFilters((String)generatorConfig.name().orNull(Predef$.MODULE$.$conforms()), null, null))).asScala()).map((Function1 & Serializable & scala.Serializable)v -> new Environment(v.getTitle(), (Option<String>)Option$.MODULE$.apply((Object)v.getDescription()), v.getStage().getTitle(), (List<String>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(v.getLabels()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Buffer$.MODULE$.canBuildFrom())).toList()), Buffer$.MODULE$.canBuildFrom())).toList(), generatorConfig);
    }

    public List<Reservation> generateEnvironmentReservations(GenerateService.GeneratorConfig generatorConfig) {
        return Utils$.MODULE$.whenEnabled((Function1<GenerateService.CisConfig, Object>)(Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.generateEnvironments()), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter($this.environmentReservationApi.search(new ReservationFilters((String)generatorConfig.name().orNull(Predef$.MODULE$.$conforms()), null, null, null, new Date(), null))).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            java.util.List reservations = (java.util.List)tuple2._2();
            Buffer buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(reservations).asScala()).map((Function1 & Serializable & scala.Serializable)res -> new Reservation(res.getEnvironment().getTitle(), (List<String>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.getApplications()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getTitle(), Buffer$.MODULE$.canBuildFrom())).toList(), DateUtils$.MODULE$.toString(res.getStartDate()), DateUtils$.MODULE$.toString(res.getEndDate()), res.getNote()), Buffer$.MODULE$.canBuildFrom());
            return buffer;
        }, Iterable$.MODULE$.canBuildFrom())).toList(), generatorConfig);
    }

    @Autowired
    public EnvironmentsAsCodeService(EnvironmentStageApi stageApi, EnvironmentLabelApi labelApi, EnvironmentApi environmentApi, EnvironmentReservationApi environmentReservationApi) {
        this.stageApi = stageApi;
        this.labelApi = labelApi;
        this.environmentApi = environmentApi;
        this.environmentReservationApi = environmentReservationApi;
    }
}

