/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.xlrelease.api.v1.EnvironmentApi;
import com.xebialabs.xlrelease.api.v1.EnvironmentLabelApi;
import com.xebialabs.xlrelease.api.v1.EnvironmentReservationApi;
import com.xebialabs.xlrelease.api.v1.EnvironmentStageApi;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.ascode.service.FolderSearch;
import com.xebialabs.xlrelease.ascode.service.GenerateService;
import com.xebialabs.xlrelease.ascode.utils.DateUtils$;
import com.xebialabs.xlrelease.ascode.utils.Utils$;
import com.xebialabs.xlrelease.ascode.yaml.model.Environment;
import com.xebialabs.xlrelease.ascode.yaml.model.Label;
import com.xebialabs.xlrelease.ascode.yaml.model.Reservation;
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.io.Serializable;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001B\u0006\r\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004\"\u0002*\u0001\t\u0003\u0019\u0006\"B>\u0001\t\u0003a\bbBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0005e)eN^5s_:lWM\u001c;t\u0003N\u001cu\u000eZ3TKJ4\u0018nY3\u000b\u00055q\u0011aB:feZL7-\u001a\u0006\u0003\u001fA\ta!Y:d_\u0012,'BA\t\u0013\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0014)\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002+\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0011M$\u0018mZ3Ba&\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u0005Y\f$B\u0001\u0013\u0011\u0003\r\t\u0007/[\u0005\u0003M\u0005\u00121#\u00128wSJ|g.\\3oiN#\u0018mZ3Ba&\f\u0001\u0002\\1cK2\f\u0005/\u001b\t\u0003A%J!AK\u0011\u0003'\u0015sg/\u001b:p]6,g\u000e\u001e'bE\u0016d\u0017\t]5\u0002\u001d\u0015tg/\u001b:p]6,g\u000e^!qSB\u0011\u0001%L\u0005\u0003]\u0005\u0012a\"\u00128wSJ|g.\\3oi\u0006\u0003\u0018.A\rf]ZL'o\u001c8nK:$(+Z:feZ\fG/[8o\u0003BL\u0007C\u0001\u00112\u0013\t\u0011\u0014EA\rF]ZL'o\u001c8nK:$(+Z:feZ\fG/[8o\u0003BL\u0017a\u00039fe6L7o]5p]N\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\t\u0002\u0011M,7-\u001e:jifL!!\u000f\u001c\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0004=S:LGO\u0010\u000b\u0007yyz\u0004)\u0011\"\u0011\u0005u\u0002Q\"\u0001\u0007\t\u000by1\u0001\u0019A\u0010\t\u000b\u001d2\u0001\u0019\u0001\u0015\t\u000b-2\u0001\u0019\u0001\u0017\t\u000b=2\u0001\u0019\u0001\u0019\t\u000bM2\u0001\u0019\u0001\u001b)\u0005\u0019!\u0005CA#Q\u001b\u00051%BA$I\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0013*\u000bqAZ1di>\u0014\u0018P\u0003\u0002L\u0019\u0006)!-Z1og*\u0011QJT\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq*A\u0002pe\u001eL!!\u0015$\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AD4f]\u0016\u0014\u0018\r^3Ti\u0006<Wm\u001d\u000b\u0003)\"\u00042!V/a\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Z-\u00051AH]8pizJ\u0011aG\u0005\u00039j\tq\u0001]1dW\u0006<W-\u0003\u0002_?\n!A*[:u\u0015\ta&\u0004\u0005\u0002bK:\u0011!m\u0019\t\u0003/jI!\u0001\u001a\u000e\u0002\rA\u0013X\rZ3g\u0013\t1wM\u0001\u0004TiJLgn\u001a\u0006\u0003IjAQ![\u0004A\u0002)\fqbZ3oKJ\fGo\u001c:D_:4\u0017n\u001a\t\u0003Wbt!\u0001\u001c<\u000f\u00055,hB\u00018u\u001d\ty7O\u0004\u0002qe:\u0011q+]\u0005\u0002+%\u00111\u0003F\u0005\u0003#II!a\u0004\t\n\u00055q\u0011BA<\r\u0003=9UM\\3sCR,7+\u001a:wS\u000e,\u0017BA={\u0005=9UM\\3sCR|'oQ8oM&<'BA<\r\u000399WM\\3sCR,G*\u00192fYN$2!`A\u0007!\r)VL \t\u0004\u007f\u0006%QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u000b5|G-\u001a7\u000b\u0007\u0005\u001da\"\u0001\u0003zC6d\u0017\u0002BA\u0006\u0003\u0003\u0011Q\u0001T1cK2DQ!\u001b\u0005A\u0002)\fAcZ3oKJ\fG/Z#om&\u0014xN\\7f]R\u001cH\u0003BA\n\u00037\u0001B!V/\u0002\u0016A\u0019q0a\u0006\n\t\u0005e\u0011\u0011\u0001\u0002\f\u000b:4\u0018N]8o[\u0016tG\u000fC\u0003j\u0013\u0001\u0007!.A\u0010hK:,'/\u0019;f\u000b:4\u0018N]8o[\u0016tGOU3tKJ4\u0018\r^5p]N$B!!\t\u0002*A!Q+XA\u0012!\ry\u0018QE\u0005\u0005\u0003O\t\tAA\u0006SKN,'O^1uS>t\u0007\"B5\u000b\u0001\u0004Q\u0007f\u0001\u0001\u0002.A!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u000241\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t9$!\r\u0003\u000fM+'O^5dK\u0002")
public class EnvironmentsAsCodeService {
    private final EnvironmentStageApi stageApi;
    private final EnvironmentLabelApi labelApi;
    private final EnvironmentApi environmentApi;
    private final EnvironmentReservationApi environmentReservationApi;
    private final PermissionChecker permissions;

    public List<String> generateStages(GenerateService.GeneratorConfig generatorConfig) {
        return generatorConfig.cisConfig().generateEnvironments() && !(generatorConfig.searchScope() instanceof FolderSearch) && this.permissions.hasGlobalPermission(XLReleasePermissions.EDIT_ENVIRONMENT) ? CollectionConverters$.MODULE$.ListHasAsScala(this.stageApi.search(null)).asScala().toList().filter((Function1 & Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)EnvironmentsAsCodeService.$anonfun$generateStages$1(generatorConfig, stage))).map((Function1 & Serializable)x$1 -> x$1.getTitle()) : List$.MODULE$.empty();
    }

    public List<Label> generateLabels(GenerateService.GeneratorConfig generatorConfig) {
        return generatorConfig.cisConfig().generateEnvironments() && !(generatorConfig.searchScope() instanceof FolderSearch) && this.permissions.hasGlobalPermission(XLReleasePermissions.EDIT_ENVIRONMENT) ? CollectionConverters$.MODULE$.ListHasAsScala(this.labelApi.search(null)).asScala().toList().filter((Function1 & Serializable)label -> BoxesRunTime.boxToBoolean((boolean)EnvironmentsAsCodeService.$anonfun$generateLabels$1(generatorConfig, label))).map((Function1 & Serializable)v -> new Label(v.getTitle(), v.getColor())) : List$.MODULE$.empty();
    }

    public List<Environment> generateEnvironments(GenerateService.GeneratorConfig generatorConfig) {
        return generatorConfig.cisConfig().generateEnvironments() && !(generatorConfig.searchScope() instanceof FolderSearch) && this.permissions.hasGlobalPermission(XLReleasePermissions.EDIT_ENVIRONMENT) ? CollectionConverters$.MODULE$.ListHasAsScala(this.environmentApi.search(null)).asScala().toList().filter((Function1 & Serializable)env -> BoxesRunTime.boxToBoolean((boolean)EnvironmentsAsCodeService.$anonfun$generateEnvironments$1(generatorConfig, env))).map((Function1 & Serializable)v -> new Environment(v.getTitle(), (Option<String>)Option$.MODULE$.apply((Object)v.getDescription()), v.getStage().getTitle(), (List<String>)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(v.getLabels()).asScala().map((Function1 & Serializable)x$2 -> x$2.getTitle())).toList())) : List$.MODULE$.empty();
    }

    public List<Reservation> generateEnvironmentReservations(GenerateService.GeneratorConfig generatorConfig) {
        return generatorConfig.cisConfig().generateEnvironments() && !(generatorConfig.searchScope() instanceof FolderSearch) && this.permissions.hasGlobalPermission(XLReleasePermissions.EDIT_RESERVATION) ? ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(this.environmentReservationApi.search(new ReservationFilters(null, null, null, null, new Date(), null))).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            java.util.List reservations = (java.util.List)tuple2._2();
            List list = CollectionConverters$.MODULE$.ListHasAsScala(reservations).asScala().toList().filter((Function1 & Serializable)envRes -> BoxesRunTime.boxToBoolean((boolean)EnvironmentsAsCodeService.$anonfun$generateEnvironmentReservations$2(generatorConfig, envRes))).map((Function1 & Serializable)res -> new Reservation(res.getEnvironment().getTitle(), (List<String>)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(res.getApplications()).asScala().map((Function1 & Serializable)x$3 -> x$3.getTitle())).toList(), DateUtils$.MODULE$.toString(res.getStartDate()), DateUtils$.MODULE$.toString(res.getEndDate()), res.getNote()));
            return list;
        })).toList() : List$.MODULE$.empty();
    }

    public static final /* synthetic */ boolean $anonfun$generateStages$1(GenerateService.GeneratorConfig generatorConfig$1, EnvironmentStage stage) {
        return generatorConfig$1.name().forall((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.stringLike(stage.getTitle(), n)));
    }

    public static final /* synthetic */ boolean $anonfun$generateLabels$1(GenerateService.GeneratorConfig generatorConfig$2, EnvironmentLabel label) {
        return generatorConfig$2.name().forall((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.stringLike(label.getTitle(), n)));
    }

    public static final /* synthetic */ boolean $anonfun$generateEnvironments$1(GenerateService.GeneratorConfig generatorConfig$3, com.xebialabs.xlrelease.domain.environments.Environment env) {
        return generatorConfig$3.name().forall((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.stringLike(env.getTitle(), n)));
    }

    public static final /* synthetic */ boolean $anonfun$generateEnvironmentReservations$2(GenerateService.GeneratorConfig generatorConfig$4, EnvironmentReservation envRes) {
        return generatorConfig$4.name().forall((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.stringLike(envRes.getEnvironment().getTitle(), n)));
    }

    @Autowired
    public EnvironmentsAsCodeService(EnvironmentStageApi stageApi, EnvironmentLabelApi labelApi, EnvironmentApi environmentApi, EnvironmentReservationApi environmentReservationApi, PermissionChecker permissions) {
        this.stageApi = stageApi;
        this.labelApi = labelApi;
        this.environmentApi = environmentApi;
        this.environmentReservationApi = environmentReservationApi;
        this.permissions = permissions;
    }
}

