/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.model.CiSpec;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.writer.DefinitionWriter;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlrelease.ascode.metadata.MetadataFields$;
import com.xebialabs.xlrelease.ascode.service.CreationService;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService;
import com.xebialabs.xlrelease.ascode.service.FolderSearch;
import com.xebialabs.xlrelease.ascode.service.FolderSearch$;
import com.xebialabs.xlrelease.ascode.service.GenerateService;
import com.xebialabs.xlrelease.ascode.service.GenerateService$CisConfig$;
import com.xebialabs.xlrelease.ascode.service.GenerateService$GeneratorConfig$;
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser;
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter;
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter$;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings$;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.scm.connector.JGitConnector$;
import com.xebialabs.xlrelease.scm.connector.Repository;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.scm.data.GitTag;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo$;
import com.xebialabs.xlrelease.scm.data.VersionInfo;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnector;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.Exception;
import scala.util.control.Exception$;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0005\t}h\u0001B\u0013'\u0001MB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u0011!\u0004!\u0011!Q\u0001\n%D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\ta\u0002\u0011\t\u0011)A\u0005c\"AA\u000f\u0001B\u0001B\u0003%Q\u000f\u0003\u0005y\u0001\t\u0015\r\u0011\"\u0001z\u0011!i\bA!A!\u0002\u0013Q\b\"\u0002@\u0001\t\u0003y\b\"CA\u001d\u0001\t\u0007I\u0011BA\u001e\u0011!\t)\u0006\u0001Q\u0001\n\u0005u\u0002BCA,\u0001!\u0015\r\u0011\"\u0001\u0002Z!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0005bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003{\u0003A\u0011AA`\u0011%\ty\rAI\u0001\n\u0003\t\t\u000eC\u0004\u0002f\u0002!\t!a:\t\u000f\u0005E\b\u0001\"\u0001\u0002t\"9!q\u0005\u0001\u0005\u0002\t%\u0002b\u0002B\u0017\u0001\u0011\u0005!q\u0006\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000bBqA!\u0014\u0001\t\u0003\u0011y\u0005C\u0004\u0003b\u0001!IAa\u0019\t\u000f\t=\u0005\u0001\"\u0003\u0003\u0012\"9!q\u0013\u0001\u0005\n\te\u0005b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\b\u0005[\u0003A\u0011\u0002BX\u0011\u001d\u00119\f\u0001C\u0005\u0005sCqAa0\u0001\t\u0013\u0011\t\rC\u0004\u0003b\u0002!IAa9\t\u000f\t-\b\u0001\"\u0003\u0003n\n9bi\u001c7eKJ4VM]:j_:LgnZ*feZL7-\u001a\u0006\u0003O!\n1a]2n\u0015\tI#&\u0001\u0004bg\u000e|G-\u001a\u0006\u0003W1\n!B^3sg&|g.\u001b8h\u0015\tic&A\u0005yYJ,G.Z1tK*\u0011q\u0006M\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!M\u0001\u0004G>l7\u0001A\n\u0004\u0001QR\u0004CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\r\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005)1\u000f\u001c45U*\tq(\u0001\u0005he&T(\u0010\\3e\u0013\t\tEHA\u0004M_\u001e<\u0017N\\4\u0002%U\u001cXM\u001d)s_\u001aLG.Z*feZL7-\u001a\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r2\nqa]3sm&\u001cW-\u0003\u0002I\u000b\n\u0011Rk]3s!J|g-\u001b7f'\u0016\u0014h/[2f\u0003=9WM\\3sCR,7+\u001a:wS\u000e,\u0007CA&O\u001b\u0005a%B\u0001$N\u0015\tIC&\u0003\u0002P\u0019\nyq)\u001a8fe\u0006$XmU3sm&\u001cW-A\bde\u0016\fG/[8o'\u0016\u0014h/[2f!\tY%+\u0003\u0002T\u0019\ny1I]3bi&|gnU3sm&\u001cW-\u0001\teK\u001aLg.\u001b;j_:\u0004\u0016M]:feB\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005ik\u0015\u0001B=b[2L!\u0001X,\u0003'ac%\u000bR3gS:LG/[8o!\u0006\u00148/\u001a:\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bCA0c\u001b\u0005\u0001'BA1-\u0003)\u0011X\r]8tSR|'/_\u0005\u0003G\u0002\u0014qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u00029\r|gNZ5hkJ\fG/[8o-\u0006\u0014\u0018.\u00192mKN+'O^5dKB\u0011AIZ\u0005\u0003O\u0016\u0013AdQ8oM&<WO]1uS>tg+\u0019:jC\ndWmU3sm&\u001cW-\u0001\u000bd_:4\u0017nZ;sCRLwN\\*feZL7-\u001a\t\u0003\t*L!a[#\u0003)\r{gNZ5hkJ\fG/[8o'\u0016\u0014h/[2f\u0003M1w\u000e\u001c3fe\u0006\u001b8i\u001c3f'\u0016\u0014h/[2f!\tYe.\u0003\u0002p\u0019\n\u0019bi\u001c7eKJ\f5oQ8eKN+'O^5dK\u0006q!/\u001a7fCN,7+\u001a:wS\u000e,\u0007C\u0001#s\u0013\t\u0019XI\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002\u0017\rL\u0017\nZ*feZL7-\u001a\t\u0003\tZL!a^#\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\u000eM>dG-\u001a:TKJ4\u0018nY3\u0016\u0003i\u0004\"\u0001R>\n\u0005q,%!\u0004$pY\u0012,'oU3sm&\u001cW-\u0001\bg_2$WM]*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)a\t\t!!\u0002\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011\u0004\t\u0004\u0003\u0007\u0001Q\"\u0001\u0014\t\u000b\tk\u0001\u0019A\"\t\u000b%k\u0001\u0019\u0001&\t\u000bAk\u0001\u0019A)\t\u000bQk\u0001\u0019A+\t\u000buk\u0001\u0019\u00010\t\u000b\u0011l\u0001\u0019A3\t\u000b!l\u0001\u0019A5\t\u000b1l\u0001\u0019A7\t\u000bAl\u0001\u0019A9\t\u000bQl\u0001\u0019A;\t\u000bal\u0001\u0019\u0001>)\u00075\ti\u0002\u0005\u0003\u0002 \u0005URBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002(\u0005%\u0012a\u00024bGR|'/\u001f\u0006\u0005\u0003W\ti#A\u0003cK\u0006t7O\u0003\u0003\u00020\u0005E\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005M\u0012aA8sO&!\u0011qGA\u0011\u0005%\tU\u000f^8xSJ,G-\u0001\u0004dSRK\b/Z\u000b\u0003\u0003{\u0001B!a\u0010\u0002R5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0004sK\u001adWm\u0019;\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0004CBL'\u0002BA&\u0003\u001b\na\u0001\u001d7vO&t'bAA(]\u0005AA-\u001a9m_fLG/\u0003\u0003\u0002T\u0005\u0005#\u0001\u0002+za\u0016\fqaY5UsB,\u0007%\u0001\bxe\u0006\u0004X\t_2faRLwN\\:\u0016\u0005\u0005m\u0003CBA/\u0003{\n\u0019I\u0004\u0003\u0002`\u0005]d\u0002BA1\u0003crA!a\u0019\u0002n9!\u0011QMA6\u001b\t\t9GC\u0002\u0002jI\na\u0001\u0010:p_Rt\u0014\"A\u001c\n\u0007\u0005=d'\u0001\u0003vi&d\u0017\u0002BA:\u0003k\nqaY8oiJ|GNC\u0002\u0002pYJA!!\u001f\u0002|\u0005IQ\t_2faRLwN\u001c\u0006\u0005\u0003g\n)(\u0003\u0003\u0002\u0000\u0005\u0005%!B\"bi\u000eD'\u0002BA=\u0003w\u00022!NAC\u0013\r\t9I\u000e\u0002\b\u001d>$\b.\u001b8h\u000311\u0017N\u001c3TKR$\u0018N\\4t)\u0011\ti)a)\u0011\u000bU\ny)a%\n\u0007\u0005EeG\u0001\u0004PaRLwN\u001c\t\u0005\u0003+\u000by*\u0004\u0002\u0002\u0018*\u0019\u0011&!'\u000b\u0007-\nYJC\u0002\u0002\u001e2\na\u0001Z8nC&t\u0017\u0002BAQ\u0003/\u0013\u0001DR8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4TKR$\u0018N\\4t\u0011\u001d\t)+\u0005a\u0001\u0003O\u000b\u0001BZ8mI\u0016\u0014\u0018\n\u001a\t\u0005\u0003S\u000b\tL\u0004\u0003\u0002,\u00065\u0006cAA3m%\u0019\u0011q\u0016\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019,!.\u0003\rM#(/\u001b8h\u0015\r\tyKN\u0001\fO\u0016$8+\u001a;uS:<7\u000f\u0006\u0003\u0002\u0014\u0006m\u0006bBAS%\u0001\u0007\u0011qU\u0001\u0017GJ,\u0017\r^3PeV\u0003H-\u0019;f'\u0016$H/\u001b8hgR1\u00111SAa\u0003\u000bDq!a1\u0014\u0001\u0004\t\u0019*A\u0005oK^\u001cuN\u001c4jO\"I\u0011qY\n\u0011\u0002\u0003\u0007\u0011\u0011Z\u0001\u0012e\u0016lw\u000e^3WC2LG-\u0019;j_:\u001c\bcA\u001b\u0002L&\u0019\u0011Q\u001a\u001c\u0003\u000f\t{w\u000e\\3b]\u0006\u00013M]3bi\u0016|%/\u00169eCR,7+\u001a;uS:<7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019N\u000b\u0003\u0002J\u0006U7FAAl!\u0011\tI.!9\u000e\u0005\u0005m'\u0002BAo\u0003?\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rb'\u0003\u0003\u0002d\u0006m'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006qA-\u001a7fi\u0016\u001cV\r\u001e;j]\u001e\u001cH\u0003BAu\u0003_\u00042!NAv\u0013\r\tiO\u000e\u0002\u0005+:LG\u000fC\u0004\u0002&V\u0001\r!a*\u0002\u0017\u001d,GOV3sg&|gn\u001d\u000b\u0005\u0003k\u0014)\u0003E\u00046\u0003o\fYP!\u0003\n\u0007\u0005ehG\u0001\u0004UkBdWM\r\t\u0005\u0003{\u0014)!\u0004\u0002\u0002\u0000*!\u0011q\u000eB\u0001\u0015\t\u0011\u0019!\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0004\u0003\u007f\u0014A\u0001R1uKB1!1\u0002B\t\u0005/qA!a\u0019\u0003\u000e%\u0019!q\u0002\u001c\u0002\u000fA\f7m[1hK&!!1\u0003B\u000b\u0005\r\u0019V-\u001d\u0006\u0004\u0005\u001f1\u0004\u0003\u0002B\r\u0005Ci!Aa\u0007\u000b\t\tu!qD\u0001\u0005I\u0006$\u0018M\u0003\u0002(Y%!!1\u0005B\u000e\u0005-1VM]:j_:LeNZ8\t\u000f\u0005\u0015f\u00031\u0001\u0002(\u0006aa-\u001a;dQ\u000eC\u0017M\\4fgR!\u0011Q\u001fB\u0016\u0011\u001d\t)k\u0006a\u0001\u0003O\u000bQb\u0019:fCR,g+\u001a:tS>tG\u0003\u0003B\f\u0005c\u0011\u0019Da\u000e\t\u000f\u0005\u0015\u0006\u00041\u0001\u0002(\"9!Q\u0007\rA\u0002\u0005\u001d\u0016a\u0002<feNLwN\u001c\u0005\b\u0005sA\u0002\u0019AAT\u0003-!Wm]2sSB$\u0018n\u001c8\u0002\u0019\u0005\u0004\b\u000f\\=WKJ\u001c\u0018n\u001c8\u0015\r\u0005%(q\bB!\u0011\u001d\t)+\u0007a\u0001\u0003OCqA!\u000e\u001a\u0001\u0004\t9+A\bhK:,'/\u0019;f!J,g/[3x)\u0019\t9Ka\u0012\u0003J!9\u0011Q\u0015\u000eA\u0002\u0005\u001d\u0006b\u0002B\u001b5\u0001\u0007!1\n\t\u0006k\u0005=\u0015qU\u0001\u000eS:LGoQ8o]\u0016\u001cGo\u001c:\u0015\t\tE#Q\f\t\u0005\u0005'\u0012I&\u0004\u0002\u0003V)\u0019!q\u000b\u0014\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002\u0002B.\u0005+\u00121#Q:D_\u0012,'jR5u\u0007>tg.Z2u_JDqAa\u0018\u001c\u0001\u0004\t\u0019*\u0001\u0004d_:4\u0017nZ\u0001\u000fO\u0016tWM]1uK\u001a{G\u000eZ3s)!\u0011)Ga\"\u0003\n\n-\u0005cB\u001b\u0002x\n\u001d$\u0011\u000f\t\u0005\u0005S\u0012i'\u0004\u0002\u0003l)!!q\u000bB\u0010\u0013\u0011\u0011yGa\u001b\u0003\u0011M\u001bWN\u00117pEN\u0004bAa\u0003\u0003t\t]\u0014\u0002\u0002B;\u0005+\u0011A\u0001T5tiB!!\u0011\u0010BB\u001b\t\u0011YH\u0003\u0003\u0003~\t}\u0014!B7pI\u0016d'b\u0001.\u0003\u0002*\u0011\u0011FL\u0005\u0005\u0005\u000b\u0013YH\u0001\u0006EK\u001aLg.\u001b;j_:Dq!!*\u001d\u0001\u0004\t9\u000bC\u0004\u0003`q\u0001\r!a%\t\u000f\t5E\u00041\u0001\u0002(\u0006Aa-\u001b7f!\u0006$\b.\u0001\twC2LG-\u0019;f'\u0016$H/\u001b8hgR1\u0011\u0011\u001eBJ\u0005+CqAa\u0018\u001e\u0001\u0004\t\u0019\nC\u0004\u0002Hv\u0001\r!!3\u0002+Y\fG.\u001b3bi\u0016\u001c\u0006/Z2jM&\u001c\u0017\r^5p]R!\u0011\u0011\u001eBN\u0011\u001d\u0011iJ\ba\u0001\u0003O\u000bAa\u001d9fG\u0006YQ.\u001a;bI\u0006$\u0018-T1q)\u0011\u0011\u0019Ka+\u0011\u000bU\nyI!*\u0011\u0011\u0005%&qUAT\u0003OKAA!+\u00026\n\u0019Q*\u00199\t\u000f\u0005\u0015v\u00041\u0001\u0002(\u0006aQ\r\u001f;sC\u000e$8\u000b]3dgR!!\u0011\u0017BZ!\u0019\u0011YA!\u0005\u0002(\"9!Q\u0017\u0011A\u0002\t\u001d\u0014!\u00022m_\n\u001c\u0018!D7be.\f5/\u00119qY&,G\r\u0006\u0004\u0002j\nm&Q\u0018\u0005\b\u0005k\t\u0003\u0019AAT\u0011\u001d\u0011y&\ta\u0001\u0003'\u000b\u0011$\u00199qYf\u001c6-\u001c#bi\u0006$v\u000eR3gS:LG/[8ogR1\u0011\u0011\u001eBb\u0005\u0013DqA!2#\u0001\u0004\u00119-A\u0006eK\u001aLg.\u001b;j_:\u001c\bC\u0002B\u0006\u0005#\u00119\bC\u0004\u0003L\n\u0002\rA!4\u0002\u000fM\u001cW\u000eR1uCB!!q\u001aBo\u001b\t\u0011\tN\u0003\u0003\u0003T\nU\u0017a\u00013u_*!!q\u001bBm\u0003\r\u0019wn\u0019\u0006\u0004\u00057t\u0013A\u0003=ma2\fGOZ8s[&!!q\u001cBi\u0005M\u00196)\u0014+sC\u000e,\u0017MY5mSRLH)\u0019;b\u0003Y9W\r^*d[R\u0013\u0018mY3bE&d\u0017\u000e^=ECR\fGC\u0002Bg\u0005K\u00149\u000fC\u0004\u0003`\r\u0002\r!a%\t\u000f\t%8\u00051\u0001\u0003\u0018\u0005Ya/\u001a:tS>t\u0017J\u001c4p\u0003a\u0011Xm]8mm\u00164u\u000e\u001c3feRKG\u000f\\3Ge>l\u0017\n\u001a\u000b\u0005\u0003O\u0013y\u000fC\u0004\u0002&\u0012\u0002\r!a*)\u0007\u0001\u0011\u0019\u0010\u0005\u0003\u0003v\nmXB\u0001B|\u0015\u0011\u0011I0!\f\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003~\n](aB*feZL7-\u001a")
public class FolderVersioningService
implements Logging {
    private Exception.Catch<Nothing$> wrapExceptions;
    private final UserProfileService userProfileService;
    private final GenerateService generateService;
    private final CreationService creationService;
    private final XLRDefinitionParser definitionParser;
    private final ConfigurationRepository configurationRepository;
    private final ConfigurationVariableService configurationVariableService;
    private final ConfigurationService configurationService;
    private final FolderAsCodeService folderAsCodeService;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final FolderService folderService;
    private final Type ciType;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderVersioningService folderVersioningService = this;
        synchronized (folderVersioningService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public FolderService folderService() {
        return this.folderService;
    }

    private Type ciType() {
        return this.ciType;
    }

    private Exception.Catch<Nothing$> wrapExceptions$lzycompute() {
        FolderVersioningService folderVersioningService = this;
        synchronized (folderVersioningService) {
            if (!this.bitmap$0) {
                this.wrapExceptions = Exception$.MODULE$.catchingPromiscuously((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{AsCodeException.class, GitAPIException.class, JGitInternalException.class})).withApply((Function1 & Serializable)e -> {
                    throw new ScmException(new StringBuilder(44).append("Error performing version control operation: ").append(e.getMessage()).toString(), e.getCause(), ScmException$.MODULE$.apply$default$3());
                });
                this.bitmap$0 = true;
            }
        }
        return this.wrapExceptions;
    }

    public Exception.Catch<Nothing$> wrapExceptions() {
        return !this.bitmap$0 ? this.wrapExceptions$lzycompute() : this.wrapExceptions;
    }

    public Option<FolderVersioningSettings> findSettings(String folderId) {
        return (Option)this.wrapExceptions().apply((Function0 & Serializable)() -> CollectionConverters$.MODULE$.ListHasAsScala($this.configurationRepository.findAllByTypeAndTitle(this.ciType(), null, folderId, true)).asScala().headOption());
    }

    public FolderVersioningSettings getSettings(String folderId) {
        return (FolderVersioningSettings)((Object)this.wrapExceptions().apply((Function0 & Serializable)() -> (FolderVersioningSettings)((Object)((Object)this.findSettings(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new ScmException("No version control settings defined for folder", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        })))));
    }

    public FolderVersioningSettings createOrUpdateSettings(FolderVersioningSettings newConfig, boolean remoteValidations) {
        return (FolderVersioningSettings)((Object)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings folderVersioningSettings;
            this.validateSettings(newConfig, remoteValidations);
            Option<FolderVersioningSettings> option = this.findSettings(newConfig.getFolderId());
            if (option instanceof Some) {
                Some some = (Some)option;
                FolderVersioningSettings existingConfig = (FolderVersioningSettings)((Object)((Object)some.value()));
                existingConfig.updateWith(newConfig);
                folderVersioningSettings = existingConfig;
            } else if (None$.MODULE$.equals(option)) {
                newConfig.setId($this.ciIdService.getUniqueId(this.ciType(), FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_ID_ROOT()));
                folderVersioningSettings = newConfig;
            } else {
                throw new MatchError(option);
            }
            FolderVersioningSettings config = folderVersioningSettings;
            $this.configurationService.createOrUpdate((BaseConfiguration)config);
            return config;
        }));
    }

    public boolean createOrUpdateSettings$default$2() {
        return true;
    }

    public void deleteSettings(String folderId) {
        this.wrapExceptions().apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option<FolderVersioningSettings> option = this.findSettings(folderId);
            if (option instanceof Some) {
                Some some = (Some)option;
                FolderVersioningSettings config = (FolderVersioningSettings)((Object)((Object)some.value()));
                $this.configurationRepository.delete(config.getId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        });
    }

    public Tuple2<Date, Seq<VersionInfo>> getVersions(String folderId) {
        return (Tuple2)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            Seq<VersionInfo> versions = scmConnector.listVersions();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.lastFetched()), versions.sortBy((Function1 & Serializable)x$1 -> x$1.commitTime(), package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).reverse()));
        });
    }

    public Tuple2<Date, Seq<VersionInfo>> fetchChanges(String folderId) {
        return (Tuple2)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            Seq<VersionInfo> versions = scmConnector.pullAndListVersions();
            config.lastFetched_$eq(new Date());
            $this.configurationRepository.update((BaseConfiguration)config);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.lastFetched()), versions.sortBy((Function1 & Serializable)x$2 -> x$2.commitTime(), package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).reverse()));
        });
    }

    public VersionInfo createVersion(String folderId, String version, String description) {
        return (VersionInfo)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            Tuple2<ScmBlobs, List<Definition>> tuple2 = this.generateFolder(folderId, config, filePath);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ScmBlobs blobs = (ScmBlobs)tuple2._1();
            List definitions = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)blobs, (Object)definitions);
            Tuple2 tuple23 = tuple22;
            ScmBlobs blobs2 = (ScmBlobs)tuple23._1();
            List definitions2 = (List)tuple23._2();
            GitTag tag = new GitTag((String)FolderVersioningSettings$.MODULE$.generateTagName(config.getEffectiveTagPrefix(), version, FolderVersioningSettings$.MODULE$.generateTagName$default$3()).get());
            ValidatedCommitInfo commitInfo = (ValidatedCommitInfo)ValidatedCommitInfo$.MODULE$.create(version, description, tag).get();
            UserProfile userProfile = $this.userProfileService.findByUsername(Permissions.getAuthenticatedUserName());
            scmConnector.createNewVersion(blobs2, commitInfo, userProfile).get();
            VersionInfo versionInfo = scmConnector.getVersion(commitInfo.tag().refName());
            SCMTraceabilityData scmData = this.getScmTraceabilityData(config, versionInfo);
            this.markAsApplied(versionInfo.name(), config);
            this.applyScmDataToDefinitions((Seq<Definition>)definitions2, scmData);
            return versionInfo;
        });
    }

    public void applyVersion(String folderId, String version) {
        this.wrapExceptions().apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            VersionInfo versionInfo = scmConnector.getVersion(version);
            SCMTraceabilityData scmData = this.getScmTraceabilityData(config, versionInfo);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            ScmBlobs blobs = (ScmBlobs)scmConnector.checkout(filePath, version, scmConnector.checkout$default$3()).get();
            Seq<String> specs = this.extractSpecs(blobs);
            specs.foreach((Function1 & Serializable)spec -> {
                this.validateSpecification((String)spec);
                Definition definition = $this.definitionParser.parse((String)spec);
                Definition updatedDefinition = new Definition(definition.apiVersion(), this.metadataMap(folderId), definition.kind(), definition.spec());
                return $this.creationService.processBlueprint(updatedDefinition, scmData);
            });
            this.markAsApplied(version, config);
        });
    }

    public String generatePreview(String folderId, Option<String> version) {
        return (String)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            ScmBlobs scmBlobs;
            FolderVersioningSettings config = this.getSettings(folderId);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                String ver = (String)some.value();
                AsCodeJGitConnector scmConnector = this.initConnector(config);
                scmBlobs = (ScmBlobs)scmConnector.checkout(filePath, ver, false).get();
            } else if (None$.MODULE$.equals(option)) {
                scmBlobs = (ScmBlobs)this.generateFolder(folderId, config, filePath)._1();
            } else {
                throw new MatchError((Object)option);
            }
            ScmBlobs blobs = scmBlobs;
            return new String((byte[])((BinaryFile)blobs.files().head()).getContent().apply(), StandardCharsets.UTF_8);
        });
    }

    public AsCodeJGitConnector initConnector(FolderVersioningSettings config) {
        Repository connectorConfig = config.gitConnection();
        this.configurationVariableService.resolve((Configuration)connectorConfig);
        return new AsCodeJGitConnector(config);
    }

    private Tuple2<ScmBlobs, List<Definition>> generateFolder(String folderId, FolderVersioningSettings config, String filePath) {
        Tuple2 tuple2;
        boolean x$1 = config.exportConfiguration();
        boolean x$2 = config.exportDashboards();
        boolean x$3 = config.exportTemplates();
        boolean x$4 = config.exportTriggers();
        boolean x$5 = config.exportVariables();
        boolean x$6 = config.exportPatterns();
        boolean x$7 = config.exportNotifications();
        boolean x$8 = config.exportSecurity();
        boolean x$9 = GenerateService$CisConfig$.MODULE$.apply$default$2();
        boolean x$10 = GenerateService$CisConfig$.MODULE$.apply$default$3();
        boolean x$11 = GenerateService$CisConfig$.MODULE$.apply$default$4();
        boolean x$12 = GenerateService$CisConfig$.MODULE$.apply$default$5();
        boolean x$13 = GenerateService$CisConfig$.MODULE$.apply$default$6();
        boolean x$14 = GenerateService$CisConfig$.MODULE$.apply$default$12();
        boolean x$15 = GenerateService$CisConfig$.MODULE$.apply$default$13();
        boolean x$16 = GenerateService$CisConfig$.MODULE$.apply$default$16();
        boolean x$17 = GenerateService$CisConfig$.MODULE$.apply$default$17();
        GenerateService.CisConfig cisConfig = new GenerateService.CisConfig(x$8, x$9, x$10, x$11, x$12, x$13, x$3, x$4, x$6, x$2, x$1, x$14, x$15, x$5, x$7, x$16, x$17);
        try {
            FolderSearch scope = FolderSearch$.MODULE$.apply(this.folderAsCodeService.getFolderPath(folderId), folderId, true);
            List<Definition> definitions = this.generateService.generate(new GenerateService.GeneratorConfig((Option<String>)None$.MODULE$, scope, cisConfig, GenerateService$GeneratorConfig$.MODULE$.apply$default$4()));
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            XLRDefinitionWriter qual$1 = XLRDefinitionWriter$.MODULE$.apply();
            ByteArrayOutputStream x$18 = stream;
            DefinitionWriter.WriterConfig x$19 = new DefinitionWriter.WriterConfig(definitions, false, false);
            boolean x$20 = qual$1.writeYaml$default$3();
            qual$1.writeYaml(x$18, x$19, x$20);
            tuple2 = new Tuple2((Object)new ScmBlobs((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BinaryFile[]{new BinaryFile(filePath, (Function0 & Serializable)() -> stream.toByteArray())}))), definitions);
        }
        catch (AsCodeException e) {
            throw new ScmException(e.getMessage(), e.getCause(), ScmException$.MODULE$.apply$default$3());
        }
        return tuple2;
    }

    private void validateSettings(FolderVersioningSettings config, boolean remoteValidations) {
        block2: {
            if (StringUtils.isBlank((CharSequence)config.scmPath())) {
                throw new AsCodeException(new StringBuilder(80).append("Can't create version control configurations for folder ").append(this.resolveFolderTitleFromId(config.getFolderId())).append(", scmPath cannot be blank").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            AsCodeJGitConnector connector = this.initConnector(config);
            String url = connector.getConnectionSettings().getUrl();
            if (JGitConnector$.MODULE$.isFileRepo(url)) break block2;
            JGitConnector$.MODULE$.verifyRepositoryPath(url);
            if (remoteValidations) {
                JGitConnector$.MODULE$.verifyRemoteBranch(url, config.branch());
            }
        }
    }

    private void validateSpecification(String spec) {
        Regex taggedValueRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(":\\s*!value\\b"));
        if (taggedValueRegex.findFirstMatchIn((CharSequence)spec).isDefined()) {
            throw new ScmException("Unable to apply: '!value' tags in passwords not supported. Use variables for passwords", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        }
    }

    private Option<Map<String, String>> metadataMap(String folderId) {
        return new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MetadataFields$.MODULE$.FOLDER().toString()), (Object)folderId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MetadataFields$.MODULE$.HOMEFOLDER().toString()), (Object)this.folderAsCodeService.getFolderPath(folderId))})));
    }

    private Seq<String> extractSpecs(ScmBlobs blobs) {
        Regex SPEC_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\Rspec:"));
        String content = new String((byte[])((BinaryFile)blobs.files().head()).getContent().apply(), StandardCharsets.UTF_8);
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])content.split("\\R---")), (Function1 & Serializable)x$4 -> x$4.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)spec -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningService.$anonfun$extractSpecs$2(SPEC_REGEX, spec)))));
    }

    private void markAsApplied(String version, FolderVersioningSettings config) {
        Date now = new Date();
        config.lastFetched_$eq(now);
        config.appliedVersion_$eq(version);
        config.appliedDate_$eq(now);
        config.appliedBy_$eq(Permissions.getAuthenticatedUserName());
        this.configurationRepository.update((BaseConfiguration)config);
    }

    private void applyScmDataToDefinitions(Seq<Definition> definitions, SCMTraceabilityData scmData) {
        Seq foldersAndCis = (Seq)definitions.withFilter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningService.$anonfun$applyScmDataToDefinitions$2(x$5))).flatMap((Function1 & Serializable)x$6 -> ((CiSpec)x$6.spec()).cis());
        Seq justCis = FolderVersioningService.flattenCis$1(foldersAndCis);
        justCis.foreach((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            ConfigurationItem configurationItem = x0$1;
            if (configurationItem instanceof Release) {
                Release release = (Release)configurationItem;
                boxedUnit = $this.releaseService.createSCMData(release.getId(), scmData);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    private SCMTraceabilityData getScmTraceabilityData(FolderVersioningSettings config, VersionInfo versionInfo) {
        return new SCMTraceabilityData("git", String.valueOf(versionInfo.commitHash()), versionInfo.author(), new DateTime((Object)versionInfo.commitTime()), new StringBuilder(3).append("[").append(versionInfo.name()).append("] ").append(versionInfo.shortMessage()).toString(), config.gitConnection().getUrl(), FolderVersioningSettings$.MODULE$.getDefinitionsPath(config));
    }

    private String resolveFolderTitleFromId(String folderId) {
        return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.folderService().findById(folderId, this.folderService().findById$default$2())).map((Function1 & Serializable)x$7 -> x$7.getTitle()).getOrElse((Function0 & Serializable)() -> "");
    }

    public static final /* synthetic */ boolean $anonfun$extractSpecs$2(Regex SPEC_REGEX$1, String spec) {
        return !spec.isBlank() && SPEC_REGEX$1.findFirstIn((CharSequence)spec).isDefined();
    }

    private static final Seq flattenCis$1(Seq cis) {
        return (Seq)cis.flatMap((Function1 & Serializable)x0$1 -> {
            Seq seq;
            ConfigurationItem configurationItem = x0$1;
            if (configurationItem instanceof Folder) {
                Folder folder = (Folder)configurationItem;
                seq = FolderVersioningService.flattenCis$1(CollectionConverters$.MODULE$.SetHasAsScala(folder.getChildren()).asScala().toSeq());
            } else {
                seq = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigurationItem[]{configurationItem}));
            }
            return seq;
        });
    }

    public static final /* synthetic */ boolean $anonfun$applyScmDataToDefinitions$2(Definition x$5) {
        return x$5.spec() instanceof CiSpec;
    }

    @Autowired
    public FolderVersioningService(UserProfileService userProfileService, GenerateService generateService, CreationService creationService, XLRDefinitionParser definitionParser, ConfigurationRepository configurationRepository, ConfigurationVariableService configurationVariableService, ConfigurationService configurationService, FolderAsCodeService folderAsCodeService, ReleaseService releaseService, CiIdService ciIdService, FolderService folderService) {
        this.userProfileService = userProfileService;
        this.generateService = generateService;
        this.creationService = creationService;
        this.definitionParser = definitionParser;
        this.configurationRepository = configurationRepository;
        this.configurationVariableService = configurationVariableService;
        this.configurationService = configurationService;
        this.folderAsCodeService = folderAsCodeService;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.folderService = folderService;
        Logging.$init$((Logging)this);
        this.ciType = Type.valueOf(FolderVersioningSettings.class);
    }
}

