/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlrelease.ascode.service.DashboardAsCodeService;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.ImportResult$;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.service.spec.CiSpecInterpreter;
import com.xebialabs.xlrelease.ascode.utils.DateUtils$;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.ascode.utils.ImportContext$;
import com.xebialabs.xlrelease.ascode.utils.ImportScope;
import com.xebialabs.xlrelease.ascode.utils.TemplateScope;
import com.xebialabs.xlrelease.ascode.utils.Utils$;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.events.CreatedFromAsCode;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedFromAsCodeEvent;
import com.xebialabs.xlrelease.domain.events.TemplateVariablesChangedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xltype.serialization.CiReference;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\tMe\u0001\u0002\r\u001a\u0001\u0011B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bQ\u0003A\u0011A+\t\u000b1\u0004A\u0011A7\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u0011q\n\u0001\u0005\n\u0005E\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\t)\b\u0001C\u0005\u0003oBq!a!\u0001\t\u0013\t)\tC\u0004\u0002:\u0002!I!a/\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bb\u0002B\u0003\u0001\u0011%!q\u0001\u0005\b\u0005W\u0001A\u0011\u0002B\u0017\u0011\u001d\u00119\u0004\u0001C\u0005\u0005sAqAa\u0011\u0001\t\u0013\u0011)\u0005C\u0004\u0003P\u0001!IA!\u0015\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h\t)B+Z7qY\u0006$X-Q:D_\u0012,7+\u001a:wS\u000e,'B\u0001\u000e\u001c\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001H\u000f\u0002\r\u0005\u001c8m\u001c3f\u0015\tqr$A\u0005yYJ,G.Z1tK*\u0011\u0001%I\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AI\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-c5\tQF\u0003\u0002/_\u0005)1\u000f\u001c45U*\t\u0001'\u0001\u0005he&T(\u0010\\3e\u0013\t\u0011TFA\u0004M_\u001e<\u0017N\\4\u0002\u001dI,G.Z1tKN+'O^5dKB\u0011QgN\u0007\u0002m)\u0011!$H\u0005\u0003qY\u0012aBU3mK\u0006\u001cXmU3sm&\u001cW-\u0001\feCND'm\\1sI\u0006\u001b8i\u001c3f'\u0016\u0014h/[2f!\tYD(D\u0001\u001a\u0013\ti\u0014D\u0001\fECND'm\\1sI\u0006\u001b8i\u001c3f'\u0016\u0014h/[2f\u0003=\u0011XMZ3sK:\u001cWmU8mm\u0016\u0014\bCA\u001eA\u0013\t\t\u0015DA\bSK\u001a,'/\u001a8dKN{GN^3s\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rv\t!B]3q_NLGo\u001c:z\u0013\tAUIA\tSK2,\u0017m]3SKB|7/\u001b;pef\f1bY5JIN+'O^5dKB\u0011QgS\u0005\u0003\u0019Z\u00121bQ5JIN+'O^5dK\u0006AQM^3oi\n+8\u000f\u0005\u0002P%6\t\u0001K\u0003\u0002R;\u00051QM^3oiNL!a\u0015)\u0003#ac%+\u001a7fCN,WI^3oi\n+8/\u0001\u0004=S:LGO\u0010\u000b\b-^C\u0016LW.]!\tY\u0004\u0001C\u00034\u000f\u0001\u0007A\u0007C\u0003:\u000f\u0001\u0007!\bC\u0003?\u000f\u0001\u0007q\bC\u0003C\u000f\u0001\u00071\tC\u0003J\u000f\u0001\u0007!\nC\u0003N\u000f\u0001\u0007a\n\u000b\u0002\b=B\u0011qL[\u0007\u0002A*\u0011\u0011MY\u0001\u000bC:tw\u000e^1uS>t'BA2e\u0003\u001d1\u0017m\u0019;pefT!!\u001a4\u0002\u000b\t,\u0017M\\:\u000b\u0005\u001dD\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003%\f1a\u001c:h\u0013\tY\u0007MA\u0005BkR|w/\u001b:fI\u00069\u0001O]8dKN\u001cHc\u00018rsB\u00111h\\\u0005\u0003af\u0011A\"S7q_J$(+Z:vYRDQA\u001d\u0005A\u0002M\fqaY8oi\u0016DH\u000f\u0005\u0002uo6\tQO\u0003\u0002w7\u0005)Q\u000f^5mg&\u0011\u00010\u001e\u0002\u000e\u00136\u0004xN\u001d;D_:$X\r\u001f;\t\u000biD\u0001\u0019A>\u0002\u0011Q,W\u000e\u001d7bi\u0016\u0004\"\u0001`@\u000e\u0003uT!A`\u000f\u0002\r\u0011|W.Y5o\u0013\r\t\t! \u0002\b%\u0016dW-Y:f\u0003a1\u0017N\u001c3PeB\u0013X\rZ5diR+W\u000e\u001d7bi\u0016LEm\u001d\u000b\u0005\u0003\u000f\t\u0019\u0003\u0005\u0005\u0002\n\u0005]\u0011QDA\u000f\u001d\u0011\tY!a\u0005\u0011\u0007\u00055q%\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u0012\u0002\rq\u0012xn\u001c;?\u0013\r\t)bJ\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00111\u0004\u0002\u0004\u001b\u0006\u0004(bAA\u000bOA!\u0011\u0011BA\u0010\u0013\u0011\t\t#a\u0007\u0003\rM#(/\u001b8h\u0011\u001d\t)#\u0003a\u0001\u0003O\tA\"\u00197m)\u0016l\u0007\u000f\\1uKN\u0004\u0002\"!\u000b\u00024\u0005]\u0012QH\u0007\u0003\u0003WQA!!\f\u00020\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003c9\u0013AC2pY2,7\r^5p]&!\u0011QGA\u0016\u0005\u001da\u0015n\u001d;NCB\u00042\u0001^A\u001d\u0013\r\tY$\u001e\u0002\f\u00136\u0004xN\u001d;TG>\u0004X\rE\u0003\u0002@\u0005%3P\u0004\u0003\u0002B\u0005\u0015c\u0002BA\u0007\u0003\u0007J\u0011\u0001K\u0005\u0004\u0003\u000f:\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\niE\u0001\u0003MSN$(bAA$O\u0005!B/Z7qY\u0006$X-\u00112t_2,H/\u001a)bi\"$b!!\b\u0002T\u0005]\u0003bBA+\u0015\u0001\u0007\u0011qG\u0001\u0006g\u000e|\u0007/\u001a\u0005\b\u00033R\u0001\u0019AA\u000f\u0003\u0015!\u0018\u000e\u001e7f\u0003\u00111\u0017N\u001c3\u0015\r\u0005}\u0013QMA4!\u00111\u0013\u0011M>\n\u0007\u0005\rtE\u0001\u0004PaRLwN\u001c\u0005\u0006e.\u0001\ra\u001d\u0005\u0006u.\u0001\ra_\u0001\u0007GJ,\u0017\r^3\u0015\u000fm\fi'a\u001c\u0002r!)!\u000f\u0004a\u0001g\")!\u0010\u0004a\u0001w\"9\u00111\u000f\u0007A\u0002\u0005u\u0011AA5e\u0003\u0019)\b\u000fZ1uKR910!\u001f\u0002|\u0005}\u0004\"\u0002:\u000e\u0001\u0004\u0019\bBBA?\u001b\u0001\u000710\u0001\u0005fq&\u001cH/\u001b8h\u0011\u0019\t\t)\u0004a\u0001w\u00069Q\u000f\u001d3bi\u0016$\u0017AC4f]\u0016\u0014\u0018\r^3JIV!\u0011qQAI)\u0019\ti\"!#\u00026\"9\u00111\u0012\bA\u0002\u00055\u0015AA2j!\u0011\ty)!%\r\u0001\u00119\u00111\u0013\bC\u0002\u0005U%!\u0001+\u0012\t\u0005]\u0015Q\u0014\t\u0004M\u0005e\u0015bAANO\t9aj\u001c;iS:<\u0007\u0003BAP\u0003ck!!!)\u000b\t\u0005\r\u0016QU\u0001\u0004k\u0012l'\u0002BAT\u0003S\u000b1!\u00199j\u0015\u0011\tY+!,\u0002\rAdWoZ5o\u0015\r\tykH\u0001\tI\u0016\u0004Hn\\=ji&!\u00111WAQ\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c\u0005\b\u0003os\u0001\u0019AA\u000f\u0003!\u0001\u0018M]3oi&#\u0017\u0001\u00069paVd\u0017\r^3UK6\u0004H.\u0019;f\t\u0006$\u0018\r\u0006\u0005\u0002>\u0006\r\u0017QYAd!\r1\u0013qX\u0005\u0004\u0003\u0003<#\u0001B+oSRDQA]\bA\u0002MDQA_\bA\u0002mDq!a\u001d\u0010\u0001\u0004\ti\"A\tq_B,H.\u0019;f!\"\f7/\u001a#bi\u0006$B\"!0\u0002N\u0006]\u0017\u0011\\Ao\u0003GDq!a4\u0011\u0001\u0004\t\t.A\u0003qQ\u0006\u001cX\rE\u0002}\u0003'L1!!6~\u0005\u0015\u0001\u0006.Y:f\u0011\u0015Q\b\u00031\u0001|\u0011\u001d\tY\u000e\u0005a\u0001\u0003;\t\u0001BZ8mI\u0016\u0014\u0018\n\u001a\u0005\b\u0003?\u0004\u0002\u0019AAq\u0003\u0011Aw.\\3\u0011\u000b\u0019\n\t'!\b\t\u000bI\u0004\u0002\u0019A:\u0002!A|\u0007/\u001e7bi\u0016$\u0016m]6ECR\fGCDA_\u0003S\f\u00190!@\u0002\u0000\n\u0005!1\u0001\u0005\b\u0003W\f\u0002\u0019AAw\u0003\u0011!\u0018m]6\u0011\u0007q\fy/C\u0002\u0002rv\u0014A\u0001V1tW\"9\u0011Q_\tA\u0002\u0005]\u0018!C2p]R\f\u0017N\\3s!\ra\u0018\u0011`\u0005\u0004\u0003wl(!\u0004+bg.\u001cuN\u001c;bS:,'\u000fC\u0003{#\u0001\u00071\u0010C\u0004\u0002\\F\u0001\r!!\b\t\u000f\u0005}\u0017\u00031\u0001\u0002b\")!/\u0005a\u0001g\u0006)\u0002o\u001c9vY\u0006$X-V:fe&s\u0007/\u001e;UCN\\GCBA_\u0005\u0013\u0011\t\u0002C\u0004\u0002lJ\u0001\rAa\u0003\u0011\u0007q\u0014i!C\u0002\u0003\u0010u\u0014Q\"V:fe&s\u0007/\u001e;UCN\\\u0007b\u0002B\n%\u0001\u0007!QC\u0001\nm\u0006\u0014\u0018.\u00192mKN\u0004bAa\u0006\u0003\u001e\t\u0005RB\u0001B\r\u0015\u0011\u0011Y\"a\f\u0002\u000f5,H/\u00192mK&!!q\u0004B\r\u0005\u0019\u0011UO\u001a4feB!!1\u0005B\u0014\u001b\t\u0011)CC\u0002\u0003\u0014uLAA!\u000b\u0003&\tAa+\u0019:jC\ndW-\u0001\rq_B,H.\u0019;f\u0007V\u001cHo\\7TGJL\u0007\u000f\u001e+bg.$B!!0\u00030!9\u00111^\nA\u0002\tE\u0002c\u0001?\u00034%\u0019!QG?\u0003!\r+8\u000f^8n'\u000e\u0014\u0018\u000e\u001d;UCN\\\u0017!\u00079paVd\u0017\r^3De\u0016\fG/\u001a*fY\u0016\f7/\u001a+bg.$B!!0\u0003<!9\u00111\u001e\u000bA\u0002\tu\u0002c\u0001?\u0003@%\u0019!\u0011I?\u0003#\r\u0013X-\u0019;f%\u0016dW-Y:f)\u0006\u001c8.\u0001\tq_B,H.\u0019;f\u000f\u0006$X\rV1tWR!\u0011Q\u0018B$\u0011\u001d\tY/\u0006a\u0001\u0005\u0013\u00022\u0001 B&\u0013\r\u0011i% \u0002\t\u000f\u0006$X\rV1tW\u0006\t\u0002o\u001c9vY\u0006$X\rV1tW\u001e\u0013x.\u001e9\u0015\u0019\u0005u&1\u000bB/\u0005?\u0012\tGa\u0019\t\u000f\tUc\u00031\u0001\u0003X\u0005)qM]8vaB\u0019AP!\u0017\n\u0007\tmSPA\u0005UCN\\wI]8va\")!P\u0006a\u0001w\"9\u00111\u001c\fA\u0002\u0005u\u0001bBAp-\u0001\u0007\u0011\u0011\u001d\u0005\u0006eZ\u0001\ra]\u0001\u000faJ|7-Z:t'\u000elG)\u0019;b)\u0019\tiL!\u001b\u0003\u0004\"9!1N\fA\u0002\t5\u0014\u0001\u00023bi\u0006\u0004RAJA1\u0005_\u0002BA!\u001d\u0003\u00005\u0011!1\u000f\u0006\u0005\u0005k\u00129(A\u0002ei>TAA!\u001f\u0003|\u0005\u00191m\\2\u000b\u0007\tut$\u0001\u0006yYBd\u0017\r\u001e4pe6LAA!!\u0003t\t\u00192kQ'Ue\u0006\u001cW-\u00192jY&$\u0018\u0010R1uC\")!p\u0006a\u0001w\"\u001a\u0001Aa\"\u0011\t\t%%qR\u0007\u0003\u0005\u0017S1A!$g\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005#\u0013YIA\u0004TKJ4\u0018nY3")
public class TemplateAsCodeService
implements Logging {
    private final ReleaseService releaseService;
    private final DashboardAsCodeService dashboardAsCodeService;
    private final ReferenceSolver referenceSolver;
    private final ReleaseRepository releaseRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TemplateAsCodeService templateAsCodeService = this;
        synchronized (templateAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ImportResult process(ImportContext context, Release template) {
        CiSpecInterpreter.ProcessedCi<Release> processedCi;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Processing template: ").append(template.toString()).append(" with metadata ").append(context.metadata().toString()).toString());
        if (!template.getReleaseTriggers().isEmpty()) {
            throw new AsCodeException("Templates with release triggers are no longer supported.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        this.referenceSolver.resolveReferences((ConfigurationItem)template, context.references(), (String)context.scope().getFolderId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Option<Release> option = this.find(context, template);
        if (option instanceof Some) {
            Some some = (Some)option;
            Release existing = (Release)some.value();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(19).append("Updating template: ").append(existing.toString()).toString());
            Release updated = this.update(context, existing, template);
            java.util.List templateVars = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(updated.getVariables()).asScala().withFilter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.getShowOnReleaseStart())).map((Function1 & Serializable)v -> (Variable)CiCloneHelper.cloneCi((ConfigurationItem)v))).asJava();
            processedCi = new CiSpecInterpreter.ProcessedCi<Release>(updated, AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId()), (Seq<PostCommitAction>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PostCommitAction[]{() -> $this.eventBus.publish((XLReleaseEvent)new ReleaseUpdatedFromAsCodeEvent(updated, context.scmData())), () -> $this.eventBus.publish((XLReleaseEvent)new TemplateVariablesChangedEvent(updated.getId(), templateVars))}))));
        } else if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(19).append("Creating template: ").append(template.toString()).toString());
            String id = (String)context.templateIds().getOrElse((Object)this.templateAbsolutePath(context.scope(), template.getTitle()), (Function0 & Serializable)() -> this.generateId(template, (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> Ids.ROOT_FOLDER_ID)));
            Release created = this.create(context, template, id);
            processedCi = new CiSpecInterpreter.ProcessedCi<Release>(created, AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId()), (Seq<PostCommitAction>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PostCommitAction[]{() -> $this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(created, (ReleaseCreationSource)new CreatedFromAsCode(context.scmData())))}))));
        } else {
            throw new MatchError(option);
        }
        CiSpecInterpreter.ProcessedCi<Release> processed = processedCi;
        this.processScmData(context.scmData(), processed.ci());
        return new ImportResult((List<AsCodeResponse.ChangedIds>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsCodeResponse.ChangedIds[]{processed.changedIds()}))), processed.postCommitActions(), ImportResult$.MODULE$.apply$default$3());
    }

    public Map<String, String> findOrPredictTemplateIds(ListMap<ImportScope, List<Release>> allTemplates) {
        return (Map)allTemplates.toList().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Map map;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    map = (Map)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            ImportScope scope = (ImportScope)tuple2._1();
            List templates = (List)tuple2._2();
            ImportContext context = new ImportContext(scope, (Map<String, String>)Predef$.MODULE$.Map().empty(), (List<CiReference>)package$.MODULE$.List().empty(), (Option<SCMTraceabilityData>)None$.MODULE$, ImportContext$.MODULE$.apply$default$5());
            Map map2 = (Map)map.$plus$plus((IterableOnce)templates.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$2, x1$2) -> {
                String string;
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Map idMap = (Map)tuple2._1();
                Release template = (Release)tuple2._2();
                Option<Release> option = this.find(context, template);
                if (None$.MODULE$.equals(option)) {
                    string = this.generateId(template, (String)scope.getFolderId().getOrElse((Function0 & Serializable)() -> Ids.ROOT_FOLDER_ID));
                } else {
                    if (!(option instanceof Some)) throw new MatchError(option);
                    Some some = (Some)option;
                    Release existing = (Release)some.value();
                    string = existing.getId();
                }
                String id = string;
                return (Map)idMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.templateAbsolutePath(scope, template.getTitle())), (Object)id));
            }));
            return map2;
        });
    }

    private String templateAbsolutePath(ImportScope scope, String title) {
        String string;
        Option<String> option = scope.getFolderPath();
        if (None$.MODULE$.equals(option)) {
            string = title;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            string = Utils$.MODULE$.joinPaths((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path, title}))));
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private Option<Release> find(ImportContext context, Release template) {
        List matches = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseService.findTemplatesByTitle((String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), template.getTitle(), 0, 2, 1)).asScala().toList();
        if (matches.length() > 1) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(51).append("There are multiple templates named [").append(template.getTitle()).append("] ").append(context.scope().description()).append(", those are: ").append(matches.toString()).toString());
            throw new AsCodeException(new StringBuilder(72).append("Multiple templates are named [").append(template.getTitle()).append("] ").append(context.scope().description()).append(". Can not determine which one to update.").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return matches.headOption();
    }

    private Release create(ImportContext context, Release template, String id) {
        this.populateTemplateData(context, template, id);
        return this.releaseRepository.create(template, null);
    }

    private Release update(ImportContext context, Release existing, Release updated) {
        this.populateTemplateData(context, updated, existing.getId());
        updated.setCiUid(existing.getCiUid());
        return this.releaseRepository.replace(existing, updated);
    }

    private <T extends ConfigurationItem> String generateId(T ci, String parentId) {
        return this.ciIdService.getUniqueId(ci.getType(), parentId);
    }

    private void populateTemplateData(ImportContext context, Release template, String id) {
        Option<String> home = context.scope().getMetadataHome();
        template.setId(id);
        template.setStatus(ReleaseStatus.TEMPLATE);
        if (template.getScheduledStartDate() == null) {
            template.setScheduledStartDate(new Date());
        }
        if (template.getDueDate() == null) {
            if (template.getPlannedDuration() == null) {
                Date nextHour = DateUtils$.MODULE$.addHoursToDate(template.getScheduledStartDate(), 1);
                template.setDueDate(nextHour);
            } else {
                template.setDueDate(DateUtils$.MODULE$.addHoursToDate(template.getScheduledStartDate(), DateUtils$.MODULE$.secondsToHours(Predef$.MODULE$.Integer2int(template.getPlannedDuration()))));
            }
        }
        CollectionConverters$.MODULE$.ListHasAsScala(template.getVariables()).asScala().foreach((Function1 & Serializable)variable -> {
            VariablePersistenceHelper$.MODULE$.fixUpReleaseVariable(variable, template.getId(), this.ciIdService);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(template.getPhases()).asScala().foreach((Function1 & Serializable)phase -> {
            this.populatePhaseData(phase, template, (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
        ImportContext templateScopedContext = context.copy(new TemplateScope(template.getId(), template.getTitle(), context.scope()), context.copy$default$2(), context.copy$default$3(), context.copy$default$4(), context.copy$default$5());
        template.getExtensions().forEach(x0$1 -> {
            ReleaseExtension releaseExtension = x0$1;
            if (!(releaseExtension instanceof Dashboard)) {
                throw new MatchError((Object)releaseExtension);
            }
            Dashboard dashboard = (Dashboard)releaseExtension;
            $this.dashboardAsCodeService.initializeTemplateDashboard(templateScopedContext, dashboard);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private void populatePhaseData(Phase phase, Release template, String folderId, Option<String> home, ImportContext context) {
        phase.setId(this.generateId(phase, template.getId()));
        phase.setStatus(PhaseStatus.PLANNED);
        phase.setRelease(template);
        CollectionConverters$.MODULE$.ListHasAsScala(phase.getTasks()).asScala().foreach((Function1 & Serializable)task -> {
            this.populateTaskData(task, (TaskContainer)phase, template, folderId, (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
    }

    private void populateTaskData(Task task, TaskContainer container, Release template, String folderId, Option<String> home, ImportContext context) {
        task.setId(this.generateId(task, container.getId()));
        task.setStatus(TaskStatus.PLANNED);
        task.setContainer(container);
        CollectionConverters$.MODULE$.ListHasAsScala(task.getFacets()).asScala().foreach((Function1 & Serializable)facet -> {
            TemplateAsCodeService.$anonfun$populateTaskData$1(this, task, folderId, home, facet);
            return BoxedUnit.UNIT;
        });
        this.referenceSolver.resolveStringReference((ConfigurationItem)task, folderId, home, context.templateIds());
        Task task2 = task;
        if (task2 instanceof CustomScriptTask) {
            CustomScriptTask customScriptTask = (CustomScriptTask)task2;
            this.populateCustomScriptTask(customScriptTask);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (task2 instanceof CreateReleaseTask) {
            CreateReleaseTask createReleaseTask = (CreateReleaseTask)task2;
            this.populateCreateReleaseTask(createReleaseTask);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (task2 instanceof GateTask) {
            GateTask gateTask = (GateTask)task2;
            this.populateGateTask(gateTask);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (task2 instanceof TaskGroup) {
            TaskGroup taskGroup = (TaskGroup)task2;
            this.populateTaskGroup(taskGroup, template, folderId, home, context);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (task2 instanceof UserInputTask) {
            UserInputTask userInputTask = (UserInputTask)task2;
            this.populateUserInputTask(userInputTask, (Buffer<Variable>)CollectionConverters$.MODULE$.ListHasAsScala(template.getVariables()).asScala());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void populateUserInputTask(UserInputTask task, Buffer<Variable> variables) {
        Map varMap = ((IterableOnceOps)variables.map((Function1 & Serializable)variable -> new Tuple2((Object)variable.getKey(), variable))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Buffer usedVars = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(task.getVariables()).asScala().filter((Function1 & Serializable)taskVar -> BoxesRunTime.boxToBoolean((boolean)varMap.contains((Object)taskVar.getKey())))).map((Function1 & Serializable)taskVar -> (Variable)varMap.apply((Object)taskVar.getKey()));
        task.setVariables(CollectionConverters$.MODULE$.BufferHasAsJava(usedVars).asJava());
    }

    private void populateCustomScriptTask(CustomScriptTask task) {
        PythonScript pythonScript = task.getPythonScript();
        pythonScript.setId(new StringBuilder(13).append(task.getId()).append("/").append("PythonScript").toString());
        pythonScript.setCustomScriptTask(task);
    }

    private void populateCreateReleaseTask(CreateReleaseTask task) {
        CollectionConverters$.MODULE$.ListHasAsScala(task.getTemplateVariables()).asScala().foreach((Function1 & Serializable)variable -> {
            variable.setId(this.generateId(variable, task.getId()));
            return BoxedUnit.UNIT;
        });
    }

    private void populateGateTask(GateTask task) {
        CollectionConverters$.MODULE$.ListHasAsScala(task.getConditions()).asScala().foreach((Function1 & Serializable)condition -> {
            condition.setId(this.ciIdService.getUniqueId(condition.getType(), task.getId()));
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(task.getDependencies()).asScala().foreach((Function1 & Serializable)dep -> {
            TemplateAsCodeService.$anonfun$populateGateTask$2(this, task, dep);
            return BoxedUnit.UNIT;
        });
    }

    private void populateTaskGroup(TaskGroup group, Release template, String folderId, Option<String> home, ImportContext context) {
        CollectionConverters$.MODULE$.ListHasAsScala(group.getTasks()).asScala().foreach((Function1 & Serializable)task -> {
            this.populateTaskData(task, (TaskContainer)group, template, folderId, (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
        TaskGroup taskGroup = group;
        if (taskGroup instanceof ParallelGroup) {
            BoxedUnit boxedUnit;
            ParallelGroup parallelGroup = (ParallelGroup)taskGroup;
            if (!parallelGroup.getLinks().isEmpty()) {
                Map nameToTask = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(parallelGroup.getTasks()).asScala().map((Function1 & Serializable)task -> new Tuple2((Object)task.getTitle(), task))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                CollectionConverters$.MODULE$.SetHasAsScala(parallelGroup.getLinks()).asScala().foreach((Function1 & Serializable)link -> {
                    TemplateAsCodeService.$anonfun$populateTaskGroup$3(this, group, nameToTask, link);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void processScmData(Option<SCMTraceabilityData> data, Release template) {
        data.filterNot((Function1 & Serializable)scmData -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isSCMDataEmpty(scmData))).foreach((Function1 & Serializable)x$2 -> $this.releaseService.createSCMData(template.getId(), x$2));
    }

    public static final /* synthetic */ void $anonfun$populateTaskData$1(TemplateAsCodeService $this, Task task$1, String folderId$2, Option home$3, Facet facet) {
        facet.setTargetId(task$1.getId());
        facet.setId($this.generateId(facet, ""));
        $this.referenceSolver.resolveStringReference((ConfigurationItem)facet, folderId$2, (Option<String>)home$3, $this.referenceSolver.resolveStringReference$default$4());
    }

    public static final /* synthetic */ void $anonfun$populateGateTask$2(TemplateAsCodeService $this, GateTask task$3, Dependency dep) {
        if (!VariableHelper$.MODULE$.containsVariables(dep.getTargetId())) {
            throw new AsCodeException("Gate tasks with hardcoded release dependencies cannot be applied, change the dependency to using a variable instead.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        dep.setId($this.ciIdService.getUniqueId(dep.getType(), task$3.getId()));
    }

    public static final /* synthetic */ void $anonfun$populateTaskGroup$3(TemplateAsCodeService $this, TaskGroup group$1, Map nameToTask$1, Link link) {
        link.setId($this.generateId(link, group$1.getId()));
        link.setSource((Task)nameToTask$1.apply((Object)link.getSource().getTitle()));
        link.setTarget((Task)nameToTask$1.apply((Object)link.getTarget().getTitle()));
    }

    @Autowired
    public TemplateAsCodeService(ReleaseService releaseService, DashboardAsCodeService dashboardAsCodeService, ReferenceSolver referenceSolver, ReleaseRepository releaseRepository, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.releaseService = releaseService;
        this.dashboardAsCodeService = dashboardAsCodeService;
        this.referenceSolver = referenceSolver;
        this.releaseRepository = releaseRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

